<?php
add_filter( 'sd/edi/importer/config', 'sd_edi_full_site_config' );

function sd_edi_full_site_config() {
	return [
		'themeName'     => 'Shopi',
		'themeSlug'     => 'shopi',
		'multipleZip'   => false,
		'demoZip'       => get_template_directory_uri() . '/demo/sample-demo-zip.zip',
		'blogSlug'      => '',
		'settingsJson'  => [],
        'menus' => [
            'mobile-menu' => 'منو موبایل',
            'mega-menu'   => 'مگامنوجدید',
        ],
		'demoData'      => [
			'home-1' => [
				'name'         => 'دموی دیجیتال',
				'previewImage' => get_template_directory_uri() . '/demo/Screenshot.png',
				'previewUrl'   => 'http://localhost/shopi-v-05/home-1',
			],
		],
		'plugins'       => [
			// Elementor رایگان
			'elementor' => [
				'name'     => 'Elementor',
				'source'   => 'wordpress',
				'filePath' => 'elementor/elementor.php',
			],
			// ووکامرس اصلی
			'woocommerce' => [
				'name'     => 'WooCommerce',
				'source'   => 'wordpress',
				'filePath' => 'woocommerce/woocommerce.php',
			],
			// ووکامرس فارسی
			'persian-woocommerce' => [
				'name'     => 'ووکامرس فارسی',
				'source'   => 'wordpress',
				'filePath' => 'persian-woocommerce/woocommerce-persian.php',
			],
			// Elementor Pro
			'elementor-pro' => [
				'name'     => 'Elementor Pro',
				'source'   => 'remote',
				'filePath' => 'elementor-pro/elementor-pro.php',
				'location'      => 'http://codisa.ir/file-shopi/elementor-pro.zip',
			],

		],
	];
}

function af_import_redux_json_file( $file_path ) {
    $content = file_get_contents( $file_path );
    $data = json_decode( $content, true );

    if ( ! $data ) {
        return '❌ فایل JSON معتبر نیست.';
    }

    array_walk_recursive( $data, function( &$item ) {
        $item = str_replace( 'http://shopitest.codisa.ir', site_url(), $item );
    });

    update_option( 'shopi_option', $data );
}

add_action( 'sd/edi/after_import', function() {
    af_import_redux_json_file( get_theme_file_path( 'demo/redux_options' ) );
});

