<?php
$action_delete_address = "wp_delete_address";
$action_active_address = "wp_active_address";


//ajax delete adress panel
function func_wp_delete_address() {
    $key = $_POST["key"];
    $address_User = get_user_meta(get_current_user_id(), 'list_address');
    $value_decode = json_decode($address_User[0], JSON_UNESCAPED_UNICODE);
    if (array_key_exists("$key", $value_decode)) {
        unset($value_decode["$key"]);
        update_user_meta(get_current_user_id(), 'list_address', json_encode($value_decode, JSON_UNESCAPED_UNICODE));
    }
    wp_send_json([
        'success' => false,
        'message' => "با موفقیت حذف شد",
    ], 200);
}

add_action("wp_ajax_{$action_delete_address}", 'func_wp_delete_address');


//ajax active adress panel
function func_wp_active_address() {
    $key = $_POST["key"];
    $get_address_User = get_user_meta(get_current_user_id(), 'list_address', true);
    $address_user = json_decode($get_address_User, JSON_UNESCAPED_UNICODE);
    $status = false;

    if (isset($address_user[$key]) && !empty($address_user[$key])) {
        foreach ($address_user[$key]["billing"] as $key_name => $value) {
            if (isset($value) && !empty($value)) {
                update_user_meta(get_current_user_id(), $key_name, sanitize_text_field($value));
            }
        }
        update_option("lat_billing", $address_user[$key]['lat']);
        update_option("lng_billing", $address_user[$key]['lng']);
        update_user_meta(get_current_user_id(), 'active_address', sanitize_text_field($key));
        $status = true;
        $message = "ادرس مورد نظر به عنوان ادرس پیش فرض انتخاب شد";
    } else {
        $message = "عملیات با خطا مواجه شد";
    }

    wp_send_json([
        "success" =>  $status,
        "message" => $message,
    ], 200);
}
add_action("wp_ajax_{$action_active_address}", 'func_wp_active_address');


function extract_unique_param_id($url = null, $dynamic_pattern = null) {
    $url = $url == null ? $_SERVER['REQUEST_URI'] : $url;
    $pattern = '/\/address\/([^\/]+)/';
    $pattern = '/\/' . ($dynamic_pattern ? $dynamic_pattern : 'address') . '\/([^\/]+)/';
    preg_match($pattern, $url, $matches);
    $address_id = $matches[1];
    return $address_id;
}
