<?php

/* Create Post type  */
add_action('init', 'ft_cpt_init');
function ft_cpt_init() {
    $contact_labels = array(
        'name'                => _x('پیام ها', 'Post Type General Name', 'ft'),
        'singular_name'       => _x('پیام', 'Post Type Singular Name', 'ft'),
        'menu_name'           => __('فرم تماس', 'ft'),
        'all_items'           => __('همه پیام ها', 'ft'),
        'view_item'           => __('', 'ft'),
        'add_new_item'        => __('افزودن پیام جدید', 'ft'),
        'add_new'             => __('افزودن پیام جدید', 'ft'),
        'edit_item'           => __('ویرایش پیام', 'ft'),
        'update_item'         => __('بروزرسانی پیام', 'ft'),
        'search_items'        => __('جستجو پیام', 'ft'),
    );

    $contact_args = array(
        'label'               => __('پیام ها', 'ft'),
        'description'         => __('پیام ها', 'ft'),
        'labels'              => $contact_labels,
        'supports'            => array('title', 'custom-fields',),
        'hierarchical'        => false,
        'public'              => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_nav_menus'   => true,
        'show_in_admin_bar'   => true,
        'show_in_rest'       => false,
        'can_export'          => true,
        'has_archive'         => false,
        'exclude_from_search' => false,
        'publicly_queryable'  => false,
        'capability_type'     => 'page',
        'rewrite'             => false,
        'query_var'             => false,
        'menu_icon' => 'dashicons-email-alt',
    );
    register_post_type('contact', $contact_args);
}

/* Contact function */

/* acf contact form */
if (!function_exists('ft_contact_form')) {
    function ft_contact_form() {
        $setting = array(
            'id'    =>     12,
            'post_id'        => 'new_post',
            'post_title'    => false,
            'post_content' => false,
            'submit_value'    => 'ارسال',
            'updated_message' => __("از پیام شما متشکریم، پیام شما با موفقیت ارسال شد.", 'acf'),
            'new_post'        => array(
                'post_type'        => 'contact',
                'post_status'    => 'draft'
            ),
            'form' => false,
            'html_after_fields' => '<div class="acf-form-submit btn col-span-3 relative"><input type="submit" class="acf-button button button-primary button-large text-[15px] text-white bg-[#22da90] rounded-[9px] h-[51px] w-full" value="ارسال"><span class="acf-spinner"></span></div>',
        );
        acf_form($setting);
    }


    add_action('acf/save_post', 'send_email_cform');
    function send_email_cform($post_id) {
        if (get_post_type($post_id) !== 'contact') {
            return;
        }
        if (is_admin()) {
            return;
        }
        /* change name of post in cform */
        $content = array(
            'ID' => $post_id,
            'post_title' => 'پیام-' . $post_id . ''
        );
        wp_update_post($content);

        $page_id = find_page_id('templates/template-contact.php');
        $name = get_field('name_cform', $post_id);
        $email = get_field('email_cform', $post_id);
        $subject = 'فرم تماس با ما';
        $body = get_field('comment_cform', $post_id);
        $to = get_field('emailsend_cform', $page_id);
        $headers = 'From: ' . $name . ' <' . $email . '>' . "\r\n";


        // send email
        wp_mail($to, $subject, $body, $headers);
    }
}


add_action('wp_print_scripts', 'pp_deregister_javascript', 99);
function pp_deregister_javascript() {
    if (!is_admin()) {
        wp_dequeue_script('wp-color-picker');
        wp_deregister_script('wp-color-picker-js-extra');
        wp_deregister_script('wp-color-picker');
    }
}
