<?php
define('VERIFICATION_CODE', 'verification_code');
define('MOBILE_SEND_CODE', 'mobile_send_code_login');
define('VERIFICATION_CODE_TIME', 'verification_code_time');
define('USER_PHONE_NUMBER', 'user_phone_number');


//function
function get_user_ip() {
    if (isset($_SERVER['REMOTE_ADDR'])) {
        $user_ip = sanitize_text_field($_SERVER['REMOTE_ADDR']);
        return $user_ip;
    } else {
        return;
    }
}


function send_code_mobile($mobile) {
    $key = "transient_login_" . $mobile;
    $get_transient = get_transient($key);
    if (false === $get_transient) {
        $code = rand(1000, 9999);
        $result = send_sms($mobile, $code);
        if ($result) {
            $_SESSION[VERIFICATION_CODE] = $code;
            $_SESSION[MOBILE_SEND_CODE] = $mobile;
            // set_transient($key, true, 60 * 2);
            set_transient($key, true, 60 * 2);

            return [
                "سسس" => $code,
                "success" => true,
                "msg" => "کد تایید برای شما ارسال شد ",
            ];
        } else {
            return [
                "success" => false,
                "msg" => "مشکلی در ارسال کد تایید برای شما به وجود آمده است. لطفا بعدا تلاش فرمائید ",
            ];
        }
    } else {
        return [
            "success" => false,
            "msg" => "شما قبلاً کد تایید درخواست کرده‌اید. لطفاً " . get_remaining_time($key) . " ثانیه دیگر منتظر بمانید.",
        ];
    }
}

function login_user_by_code($code) {
    $mobile = isset($_SESSION[MOBILE_SEND_CODE]) ? $_SESSION[MOBILE_SEND_CODE] : '';
    $result = [
        "success" => true,
    ];

    // Define keys and limits for login attempts
    $attempts_key = 'transient_login_attempts_' . $mobile;
    $lock_key     = 'transient_login_lock_' . $mobile;
    $max_attempts = 3;       // Maximum wrong attempts allowed
    $lock_seconds = 120;     // Lock time in seconds (2 minutes)

    // Check if mobile number is set
    if (empty($mobile)) {
        return [
            "success" => false,
            "msg" => "شماره موبایل وارد نشده است",
        ];
    }

    // If user is locked, prevent further attempts
    if (get_transient($lock_key) !== false) {
        return [
            "success" => false,
            "msg" => "شما موقتاً قفل شده‌اید. لطفاً بعد از ۲ دقیقه دوباره تلاش کنید.",
            "locked" => true,
        ];
    }

    // Verify if the verification code is expired
    $key = "transient_login_" . $mobile;
    $get_transient = get_transient($key);
    if (false === $get_transient) {
        delete_transient($attempts_key); // Reset attempts if code expired
        return [
            "success" => false,
            "msg" => "کد تایید منقضی شده است. لطفاً دوباره اقدام کنید",
        ];
    }

    // Check if code is correct
    if (intval($code) !== intval($_SESSION[VERIFICATION_CODE] ?? 0)) {
        // Increase failed attempts count
        $attempts = (int) get_transient($attempts_key);
        $attempts++;
        set_transient($attempts_key, $attempts, $lock_seconds);

        if ($attempts >= $max_attempts) {
            // Lock the user for 2 minutes
            set_transient($lock_key, 1, $lock_seconds);
            delete_transient($attempts_key); // Reset attempts after lock

            return [
                "success" => false,
                "msg" => "شما بیش از {$max_attempts} بار کد اشتباه وارد کرده‌اید. حساب برای ۲ دقیقه قفل شد.",
                "locked" => true,
            ];
        } else {
            $remaining = $max_attempts - $attempts;
            return [
                "success" => false,
                "msg" => "کد وارد شده اشتباه است. تعداد تلاش‌های باقیمانده: {$remaining}",
                "attempts" => $attempts,
            ];
        }
    }

    // If code is correct -> reset attempts and lock
    delete_transient($attempts_key);
    delete_transient($lock_key);

    // Continue login or register process
    $user_name   = "user" . $mobile;
    $site_domain = parse_url(get_site_url(), PHP_URL_HOST) ?: wp_parse_url(get_site_url(), PHP_URL_HOST);

    $args = [
        'meta_key'     => USER_PHONE_NUMBER,
        'meta_value'   => $mobile,
        'meta_compare' => '=',
    ];
    $user_query = new WP_User_Query($args);

    // If user exists -> login
    if (!empty($user_query->get_results()) && isset($user_query->get_results()[0]->data->ID)) {
        $user_id = $user_query->get_results()[0]->data->ID;
        wp_set_current_user($user_id);
        wp_set_auth_cookie($user_id);

        return [
            "success" => true,
            "msg" => "خوش آمدید",
            "type" => "login",
        ];
    } else {
        // If user does not exist -> register new one
        $user_id = wp_insert_user([
            'user_email'   => apply_filters('pre_user_email', $user_name . '@' . $site_domain),
            'user_login'   => apply_filters('pre_user_login', $user_name),
            'user_pass'    => apply_filters('pre_user_pass', wp_generate_password()),
            'first_name'   => apply_filters('pre_user_first_name', "نام "),
            'last_name'    => apply_filters('pre_user_last_name', "نام خانوادگی"),
            'display_name' => apply_filters('pre_user_display_name', "نام نمایشی شما"),
        ]);

        if (is_wp_error($user_id)) {
            return [
                "success" => false,
                "msg" => "مشکلی در ثبت نام وجود دارد",
            ];
        } else {
            update_user_meta($user_id, USER_PHONE_NUMBER, $mobile);
            wp_set_current_user($user_id);
            wp_set_auth_cookie($user_id);
            return [
                "success" => true,
                "msg" => "خوش آمدید",
                "type" => "register",
            ];
        }
    }
}


function login_user_by_password($password) {
    $mobile = isset($_SESSION[MOBILE_SEND_CODE]) ? $_SESSION[MOBILE_SEND_CODE] : '';
    $result = [
        "success" => true,
    ];

    // Define keys and limits for login attempts
    $attempts_key = 'transient_login_attempts_' . $mobile;
    $lock_key     = 'transient_login_lock_' . $mobile;
    $max_attempts = 3;       // Maximum wrong attempts allowed
    $lock_seconds = 120;     // Lock time in seconds (2 minutes)

    // Check if mobile number exists in session
    if (empty($mobile)) {
        return [
            "success" => false,
            "msg" => "شماره موبایل وارد نشده است",
        ];
    }

    // If user is locked, prevent login
    if (get_transient($lock_key) !== false) {
        return [
            "success" => false,
            "msg" => "شما موقتاً قفل شده‌اید. لطفاً بعد از ۲ دقیقه دوباره تلاش کنید.",
            "locked" => true,
        ];
    }

    // Find user by mobile meta
    $args = [
        'meta_key'     => USER_PHONE_NUMBER,
        'meta_value'   => $mobile,
        'meta_compare' => '=',
    ];
    $user_query = new WP_User_Query($args);
    if (!empty($user_query->get_results()) && isset($user_query->get_results()[0]->data->ID)) {
        $user = $user_query->get_results()[0]->data;
    }

    // If no user found
    if (!isset($user) || empty($user)) {
        return [
            "success" => false,
            "msg" => "کاربری با این مشخصات در سیستم یافت نشد ",
        ];
    }

    // Authenticate user with given password
    $auth_user = wp_authenticate_username_password(null, $user->user_login, $password);

    if (is_wp_error($auth_user)) {
        // Increase failed attempts
        $attempts = (int) get_transient($attempts_key);
        $attempts++;
        set_transient($attempts_key, $attempts, $lock_seconds);

        if ($attempts >= $max_attempts) {
            // Lock user for lock_seconds
            set_transient($lock_key, 1, $lock_seconds);
            delete_transient($attempts_key);

            return [
                "success" => false,
                "msg" => "شما بیش از {$max_attempts} بار رمز اشتباه وارد کرده‌اید. حساب برای ۲ دقیقه قفل شد.",
                "locked" => true,
            ];
        } else {
            $remaining = $max_attempts - $attempts;
            return [
                "success" => false,
                "msg" => "شماره موبایل یا رمز عبور اشتباه است. تعداد تلاش‌های باقیمانده: {$remaining}",
                "attempts" => $attempts,
            ];
        }
    } else {
        // Reset attempts and lock if login success
        delete_transient($attempts_key);
        delete_transient($lock_key);

        $login_result = wp_signon([
            'user_login'    => $auth_user->user_login,
            'user_password' => $password,
            'remember'      => false,
        ]);

        if (is_wp_error($login_result)) {
            return [
                "success" => false,
                "msg" => "در حال حاضر امکان ورود به سایت وجود ندارد",
            ];
        } else {
            return [
                "success" => true,
                "msg" => "عملیات ورود با موفقیت انجام شد",
            ];
        }
    }
}

//ajax
$send_code_mobile = "send_code_mobile";
$verification_code = "verification_code";
$verification_pass = "verification_pass";
$send_code_again = "send_code_again";
$record_mobile_login = "record_mobile_login";

function record_mobile_login($mobile) {
    if (!isset($mobile) && empty($mobile)) {
        $result =  [
            "success" => false,
            "msg" => "شماره موبایل نمی تواند خالی باشد",
        ];
    } else {
        if (!validatePhoneNumber($mobile)) {
            $result =  [
                "success" => false,
                "msg" => "فرمت شماره موبایل اشتباه است",
            ];
        } else {
            $user_exists = username_exists('user' . $mobile) ? true : false;
            $_SESSION[MOBILE_SEND_CODE] = $mobile;
            if (!$user_exists) {
                $send_code_result = send_code_mobile($mobile);
            }
            $result =  [
                "success" => true,
                "msg" => "شماره همراه ثبت شد",
                'user_exists' => $user_exists,
                'send_code_result' => $send_code_result
            ];
        }
    }

    return $result;
}

function record_mobile_login_action() {
    $mobile = sanitize_text_field($_POST['data']['mobile']);
    $result = record_mobile_login($mobile);

    wp_send_json($result, 200);
}
add_action("wp_ajax_nopriv_{$record_mobile_login}", 'record_mobile_login_action');


function send_code_mobile_action() {
    $result =  [
        "success" => true,
        "msg" => "کد تایید با موفقیت ارسال شد",
    ];
    $result = record_mobile_login($_POST['data']['mobile']);
    if ($result['success']) {
        $mobile = $_SESSION[MOBILE_SEND_CODE];
        if (!empty($mobile)) {
            $result = send_code_mobile($mobile);
        }
    }


    wp_send_json($result, 200);
}
add_action("wp_ajax_nopriv_{$send_code_mobile}", 'send_code_mobile_action');


function verification_code_action() {
    $code = $_POST['data']['code'] ?? null;
    $result = [
        'success' => true
    ];
    if (!empty($_SESSION[MOBILE_SEND_CODE]) && !empty($code)) {
        $result = login_user_by_code($code);
    }
    wp_send_json($result, 200);
}
add_action("wp_ajax_nopriv_{$verification_code}", 'verification_code_action');

function verification_pass() {
    $password = $_POST['data']['password'] ?? null;
    if (!empty($password)) {
        $result = login_user_by_password($password);
    } else {
        $result = [
            'success' => false,
            'msg' => 'پسورد خالی است',
        ];
    }
    wp_send_json($result, 200);
}
add_action("wp_ajax_nopriv_{$verification_pass}", 'verification_pass');


function send_code_again() {
    $mobile = $_SESSION[MOBILE_SEND_CODE];
    $key = "transient_login_" . $mobile;
    $get_transient = get_transient($key);
    if (false === $get_transient) {
        $result = send_code_mobile($mobile);
    } else {
        $result = [
            "success" => false,
            "msg" => "شما قبلاً کد تایید درخواست کرده‌اید. لطفاً " . get_remaining_time($key) . " ثانیه دیگر منتظر بمانید.",
        ];
    }
    wp_send_json($result, 200);
}
add_action("wp_ajax_nopriv_{$send_code_again}", 'send_code_again');



function get_remaining_time($key) {
    $value = get_transient($key);
    if (!$value) {
        return false;
    }
    $expiration = get_option('_transient_timeout_' . $key);
    $current_time = time();
    $remaining_time = $expiration - $current_time;

    return $remaining_time;
}

add_action('init', 'action_save_password_register');

function action_save_password_register() {

    function checkPasswordStrength($password) {
        $lengthRegex = '/^.{8,100}$/';
        $numberRegex = '/\d/';
        $specialCharRegex = '/[!@#$%^&*()_+\-=\[\]{};\'":\\\\|,.<>\/?]/';
        $lowercaseRegex = '/[a-z]/';
        $uppercaseRegex = '/[A-Z]/';

        $strength = 0;
        $classList = array();

        if (preg_match($lengthRegex, $password)) {
            $strength++;
            $classList[] = "lengthRegex";
        }
        // if (preg_match($numberRegex, $password)) {
        //     $strength++;
        //     $classList[] = "numberRegex";
        // }
        // if (preg_match($lowercaseRegex, $password)) {
        //     $strength++;
        //     $classList[] = "lowercaseRegex";
        // }
        // if (preg_match($uppercaseRegex, $password)) {
        //     $strength++;
        //     $classList[] = "uppercaseRegex";
        // }

        return $strength == 1;
    }

    if (is_user_logged_in()) {
        if (isset($_POST['password']) && !empty($_POST['password'])) {
            $password = $_POST['password'];
            $user_id = get_current_user_id();

            if (isset($_POST['displayname']) && !empty($_POST['displayname'])) {
                $data = $_POST['displayname'];
                $len = mb_strlen($data, 'utf-8');
                if ($len > 1 && $len < 200) {
                    wp_update_user(array('ID' => $user_id, 'display_name' => $data));
                    $success[] = ' نام نمایشی بروزرسانی شد ';
                } else {
                    $errors[] = 'نام نمایشی شما باید بیشتر از 4 کاراکتر و کمتر از 100 کاراکتر باشد';
                }
            }

            if (checkPasswordStrength($password)) {
                wp_set_password($password, $user_id);
                wp_set_current_user($user_id);
                wp_set_auth_cookie($user_id);
                header("Refresh:0");
            }
        }
    }
}
