<?php
function comment_reply_enqueue() {
    if ((is_singular('product') || is_singular('post')) && comments_open() && (get_option('thread_comments') == 1)) {
        wp_enqueue_script('comment-reply', '/wp-includes/js/comment-reply.min.js', array(), false, true);
    }
}
add_action('wp_enqueue_scripts', 'comment_reply_enqueue');

function mytheme_comment($comment, $args, $depth) {
?>
    <?php
    if ('div' === $args['style']) {
        $tag       = 'div';
        $add_below = 'comment';
    } else {
        $tag       = 'li';
        $add_below = 'div-comment';
    }
    $class_sp = empty($args['has_children']) ? '' : 'parent'; ?>
    <<?php echo $tag; ?> <?php comment_class('review' . $class_sp); ?> id="comment-<?php comment_ID() ?>">
        <?php if ('div' != $args['style']) { ?>
            <div id="div-comment-<?php comment_ID() ?>" class="comment-body">
            <?php } ?>
            <div class="flex items-stretch gap-11 mb-14 a-sm:gap-3">
                <div class="pic-user-comment">
                    <?= get_avatar($comment, 50, '', '', ['class' => 'min-w-[45px] max-w-[45px] h-[45px] object-cover overflow-hidden rounded-[15px]']) ?>
                </div>
                <div class="w-full">
                    <div class="text-[13px] text-[#5f7d7d] font-bold leading-[2.4] mb-9 a-sm:text-[12px] a-sm:leading-[2] a-sm:mb-4">
                        <?php comment_text(); ?>
                    </div>
                    <div class="flex flex-wrap items-center gap-7 a-sm:gap-5 CommentLike w-full" data-id="<?= comment_ID() ?>">
                        <div class="flex items-center gap-3">
                            <i class='icon-arrow-top2 text-[5px] text-[#fff] font-bold w-5 h-5 rounded-full bg-[#97c0c0] flex items-center justify-center transition-3s hover:bg-[#29cd8d] cursor-pointer'></i>
                            <span class='text-[16px] text-[#85a2a2] font-bold like-count'><?= count_comment_like($comment->comment_ID) ?></span>
                            <i class='icon-arrow-btn text-[5px] text-[#fff] font-bold w-5 h-5 rounded-full bg-[#97c0c0] flex items-center justify-center transition-3s hover:bg-[#29cd8d] cursor-pointer'></i>
                        </div>
                        <?php
                        comment_reply_link(
                            array_merge(
                                $args,
                                array(
                                    'reply_text' => '<span>
                            <span class="text-[11px] text-[#4c6a6a] font-bold rounded-[6px] bg-[#dae8e8] px-4 py-1 transition-3s hover:bg-[#29cd8d] hover:text-white">
                                پاسخ به این پیام
                            </span>
                        </span>',
                                    'add_below' => $add_below,
                                    'depth'     => $depth,
                                    'max_depth' => $args['max_depth']
                                )
                            )
                        ); ?>
                        <span class='text-[13px] text-[#85a2a2] font-bold'>
                            <?= @esc_attr($comment->comment_author) ?>
                        </span>
                        <span class='text-[14px] text-[#85a2a2] font-bold'>
                            <?= get_comment_date('d . m . Y', $comment->comment_ID) ?>
                        </span>
                        <?php
                        if (is_singular('experts') && $comment->comment_parent == 0) {
                            $rating = get_comment_meta($comment->comment_ID, 'rating', true);
                        ?>
                            <div class="box-rating-comment flex items-center gap-4 justify-between mr-auto">
                                <span class="text-[12px] text-[#85a2a2] font-bold">امتیاز من به کارشناس</span>
                                <div class="flex items-center gap-2">
                                    <div class="rating-comment clicked">
                                        <?php for ($i = 1; $i <= 5; $i++) { ?>
                                            <span class="item star-comment-icon <?= $i <= $rating ? 'click-color-change' : '' ?>"></span>
                                        <?php } ?>
                                    </div>
                                    <div class="flex items-end text-[14px] text-[#cfd4e3]">
                                        <ins class="text-[16px] text-[#233564] font-bold leading-[1]">5</ins>
                                        /
                                        <ins class="text-[30px] text-[#233564] font-bold leading-[1] tab:text-[24px]"><?= @esc_attr($rating) ?></ins>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <?php
                        if ($comment->comment_approved == '0') { ?>
                            <em class="comment-awaiting-moderation"><?php _e('Your comment is awaiting moderation.'); ?></em>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php
            if ('div' != $args['style']) : ?>
            </div><?php
                endif; ?>
    <?php
}

function set_comment_like() {
    $comment_id = isset($_POST['comment_id']) && !empty($_POST['comment_id']) && is_numeric($_POST['comment_id']) ? $_POST['comment_id'] : null;
    if ($comment_id) {
        if (isset($_SERVER['REMOTE_ADDR'])) {
            $user_ip = sanitize_text_field($_SERVER['REMOTE_ADDR']);
        } else {
            return;
        }

        // Combine post ID & IP to form unique key
        $key = 'comment_like_' . $user_ip . '_comment_' . $comment_id;

        // Get transient and store in variable
        $visited = get_transient($key);

        // Check if the Post ID/IP ($key) address is currently stored as a transient
        if (false === $visited) {
            // Store the unique key, Post ID & IP address for 24 hours if it does not exist
            set_transient($key, true, 60 * 60 * 24);

            // Now run post views function
            $count_key = 'comment_like';
            $count = get_comment_meta($comment_id, $count_key, true);

            if ($count === '') {
                // If the count doesn't exist, initialize it
                update_comment_meta($comment_id, $count_key, 1);
            } else {
                // Increment the count
                $count++;
                update_comment_meta($comment_id, $count_key, $count);
            }
            $message = 'رای شما با موفقیت ثبت شد ';
        } else {
            $message = 'رای شما ثبت شده است ';
        }
    }
    wp_send_json(
        array(
            'message' => @$message,
            'count' => count_comment_like($comment_id)
        ),
        $status_code ?? 200
    );
}
add_action('wp_ajax_set_comment_like', 'set_comment_like');
add_action('wp_ajax_nopriv_set_comment_like', 'set_comment_like');

function count_comment_like($id = null) {
    $id = $id ?? get_comment_ID();
    $count_key = 'comment_like';
    $count = get_comment_meta($id, $count_key, true);

    // Return zero if post_views is not set or is empty
    return $count !== '' ? $count : 0;
}

function get_average_comment_post($id) {
    global $wpdb;
    $table_commentmeta = $wpdb->prefix . 'commentmeta';
    $table_comments = $wpdb->prefix . 'comments';
    $result = $wpdb->prepare("
		 SELECT COUNT(*) as count  , SUM($table_commentmeta.meta_value) / COUNT(*) as avg
         FROM $table_comments  
         INNER JOIN $table_commentmeta  
		 ON $table_comments.comment_ID = $table_commentmeta.comment_id
		 WHERE $table_comments.comment_post_ID = %d AND $table_commentmeta.meta_key = 'rating' AND $table_comments.comment_approved = 1;
	", $id);
    $result = $wpdb->get_results($result)[0];
    return $result;
}

function round_special($number) {
    return round($number * 2) / 2;
}

function filter_comments_query($query) {
    if (is_admin()) return;

    if (isset($_GET['sort'])) {
        switch ($_GET['sort']) {
            case 'newest':
                $query->query_vars['orderby'] = 'comment_date';
                $query->query_vars['order'] = 'DESC';
                break;

            case 'popular':
                $query->query_vars['orderby'] = 'meta_value_num';
                $query->query_vars['meta_key'] = 'comment_like';
                $query->query_vars['order'] = 'DESC';
                break;

            case 'most_replied':
                $query->query_vars['orderby'] = 'comment_count';
                $query->query_vars['order'] = 'DESC';
                break;
        }
    }
}
add_action('pre_get_comments', 'filter_comments_query');



add_action('comment_post', 'add_meta_to_comment_submit', 10, 3);
function add_meta_to_comment_submit($comment_id, $approved, $commentdata) {
    // The pros and cons fields are not required, so we have to check if they're not empty
    $shopi_options = get_option('shopi_option');
    if (!empty($shopi_options['list_comment_rate']) && is_array($shopi_options['list_comment_rate'])) {
        $sum = 0;
        $i = 1;
        $list = [];
        foreach ($shopi_options['list_comment_rate']['redux_repeater_data'] as $key =>  $item) {
            $_item = $shopi_options['list_comment_rate'];
            $title   = isset($_item['title'][$key]) ? $_item['title'][$key] : '';
            $key_post = "rate_count_" . $i;
            if (isset($_POST[$key_post]) && !empty($_POST[$key_post])) {
                $option = $_POST[$key_post];
                $option = isset($option) && !empty($option) && is_numeric($option) && ($option <= 5 && $option >= 1) ? $option : 1;
                $sum += $option;
                $list[$i]['title'] = sanitize_text_field($title);
                $list[$i]['count'] = sanitize_text_field($option);
            }
            $i++;
        }
        $avg_rating = $sum / count($shopi_options['list_comment_rate']['redux_repeater_data']);
        update_comment_meta($comment_id, "rating_option", $list);
        update_comment_meta($comment_id, 'rating', sanitize_text_field($avg_rating));
    }
}
