<?php

/* Creating create faq post type
 */

function create_faq_post_type() {

    // Set UI labels for Custom Post Type
    $labels = array(
        'name' => "سوالات متداول",
        'singular_name' => 'سوال',
        'menu_name' => 'سوالات متداول',
        'parent_item_colon' => 'سوال والد',
        'all_items' => 'همه سوالات متداول',
        'view_item' => 'مشاهده سوال',
        'add_new_item' => 'افزودن سوال',
        'add_new' => 'افزودن سوال',
        'edit_item' => 'ویرایش سوال',
        'update_item' => 'بروزرسانی سوال',
        'search_items' => 'جستجوی سوال',
        'not_found' => 'پیدا نشد',
        'not_found_in_trash' => 'در زباله دان پیدا نشد.'
    );

    // Set other options for Custom Post Type
    $args = array(
        'label' => 'سوالات متداول',
        'description' => 'سوالات متداول',
        'labels' => $labels,
        'supports' => array(
            'title',
            'editor',
            'author',
            'custom-fields',
        ),
        'taxonomies' => array('faq_category'),
        'hierarchical' => true,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-format-chat',
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'publicly_queryable' => true,
        'capability_type' => 'post',
        'show_in_rest' => true,
    );

    // Registering your Custom Post Type
    register_post_type('faq', $args);
}

add_action('init', 'create_faq_post_type', 0);


// create faq category taxonomy
add_action('init', function () {
    register_taxonomy('faq_category', ['faq'], [
        'label' => 'دسته بندی سوالات',
        'hierarchical' => true,
        'rewrite' => ['slug' => 'faq_category'],
        'show_admin_column' => true,
        'show_in_rest' => true,
        'labels' => [
            'singular_name' => 'دسته بندی سوالات',
            'all_items' => 'همه دسته بندی ها',
            'edit_item' => 'ویرایش دسته بندی',
            'view_item' => 'نمایش دسته بندی',
            'update_item' => 'بروزرسانی دسته بندی',
            'add_new_item' => 'افزودن دسته بندی سوالات',
            'new_item_name' => 'نام دسته بندی سوالات',
            'search_items' => 'جستجو دسته بندی سوالات',
            'parent_item' => 'دسته بندی والد',
            'parent_item_colon' => 'دسته بندی والد',
            'not_found' => 'پیدا نشد',
        ]
    ]);
    register_taxonomy_for_object_type('faq_category', 'faq');
});
