<?php
add_action('init', function() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
        if (!isset($_SESSION['CSRF_TOKENS'])) {
        $_SESSION['CSRF_TOKENS'] = md5(uniqid(mt_rand(), true));
    }
});

function convertPersianToEnglishNumbers($input_str) {
    $persianNumbers = array('۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');
    $englishNumbers = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
    return str_replace($persianNumbers, $englishNumbers, $input_str);
}

function validatePhoneNumber($input_str) {
    $input_str = convertPersianToEnglishNumbers($input_str);
    $regex = '/^((\+98|0)9\d{9})$/m';

    return preg_match($regex, $input_str);
}

function title_generator($title, $class = '') {
    if (!empty($title)) {
        $pattern = '/\'(.*?)\'/';
        $result = preg_replace_callback($pattern, function ($matches) use ($class) {
            return '<span class="' . $class . '" >' . str_replace("'", "", $matches[0]) . '</span>';
        }, $title);
    } else {
        $result = null;
    }


    return $result;
}

function generate_link($link, $class = '', $icon = '') {
    if (!empty($link["url"]) || !empty($link["title"])) {
        echo '<a href="' . @$link["url"] . '" class="' . @$class . '" target="' . @$link["target"] . '" title="' . @$link["title"] . '">';
        echo $link["title"];
        if ($icon) {
            echo '<i class="' . $icon . '"></i>';
        }
        echo '</a>';
    }
}

function generate_map_link($lat_lang) {
    if (isset($lat_lang) && !empty($lat_lang)) {
        $location = explode(",", $lat_lang);
        $lat = $location[0];
        $lng = $location[1];
        return "https://www.google.com/maps/dir/?api=1&amp;destination=$lat,$lng";
    } else {
        return "#";
    }
}

function printMsg($msg = "هیچ نتیجه ای یافت نشد") {
    echo '<div class="woocommerce-message">';
    echo $msg;
    echo '</div>';
}

function get_csrf_token() {
    if (!isset($_SESSION['CSRF_TOKENS'])) {
        $_SESSION['CSRF_TOKENS'] = md5(uniqid(mt_rand(), true));
        $token = $_SESSION['CSRF_TOKENS'];
    } else {
        $token = $_SESSION['CSRF_TOKENS'];
    }
    return $token;
}

function regenerate_csrf_token() {
    $_SESSION['CSRF_TOKENS'] = md5(uniqid(mt_rand(), true));
    return $_SESSION['CSRF_TOKENS'];
}

function csrf_field() {
    return '<input type="hidden" name="token" value="' . $_SESSION['CSRF_TOKENS'] . '">';
}

if (!isset($_SESSION['CSRF_TOKENS'])) {
    $_SESSION['CSRF_TOKENS'] = md5(uniqid(mt_rand(), true));
}

if (!function_exists('find_page_id')) {
    function find_page_id($redirect_slug) {
        $template_page_property_comparison_array = get_pages(
            array(
                'meta_key' => '_wp_page_template',
                'meta_value' => $redirect_slug
            )
        );
        if ($template_page_property_comparison_array) {
            return $template_page_property_comparison_array[0]->ID;
        } else {
            return 0;
        }
    }
}

if (!function_exists('custom_pagination')) {
    function custom_pagination($query = null, $class = "pagination-wrap", $current_page = null) {
        $args = array(
            'type' => '',
            'prev_text' => '<svg class="icon w-[9px] h-[9px] rotate-180">
                            <use xlink:href="#arrow-left-wave-icon"></use>
                        </svg>',
            'next_text' => '<svg class="icon w-[9px] h-[9px]">
                            <use xlink:href="#arrow-left-wave-icon"></use>
                        </svg>',
        );
        if ($query != '') $args['total'] = $query->max_num_pages;
        if ($current_page == true) {
            $args['current'] = get_page_number_from_url();
        }
        echo '<div class="' . $class . ' woocommerce-pagination">';
        echo paginate_links($args);
        echo '</div>';
    }
}

if (!function_exists('get_first_taxonomy_term')) {
    function get_first_taxonomy_term($post_id, $taxonomy) {
        $terms = wp_get_post_terms($post_id, $taxonomy);
        if (!empty($terms) && !is_wp_error($terms)) {
            return $terms[0];
        }
        return null;
    }
}

function custom_display_breadcrumb() {
    if (function_exists('yoast_breadcrumb')) {
        yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
    } else if (function_exists('rank_math_the_breadcrumbs') && !is_home()) {
        rank_math_the_breadcrumbs();
    }
}

function get_menu_items_by_registered_slug($menu_slug) {

    $menu_items = array();
    if (($locations = get_nav_menu_locations()) && isset($locations[$menu_slug])) {
        $menu = get_term($locations[$menu_slug]);
        $menu_items = wp_get_nav_menu_items($menu->term_id);
    }

    return $menu_items;
}


function get_page_number_from_url($url = null) {
    $url = $url == null ? $_SERVER['REQUEST_URI'] : $url;
    preg_match('/\/page\/(\d+)(?:\/\?([^\/]+))?/', $url, $matches);
    $page_number = isset($matches[1]) ? intval($matches[1]) : null;
    return $page_number ?? 1;
}


function print_msg($msg, $type = 'error') {
    if (!empty($msg)) {
        if ($type == 'error') {
            echo '<p
    class="p-3 mb-3  bg-white text-gray-600 text-[13px] font-bold  border-solid border-t-2 border-red-500  list-none w-auto break-words shadow-[0px_0px_1px_1px_#e9ebed] rounded-lg">
    ' . $msg . '</p>';
        } else {
            echo '<p
        class="p-3 mb-3  bg-white text-gray-600 text-[13px] font-bold  border-solid border-t-2 border-green-500  list-none w-auto break-words shadow-[0px_0px_1px_1px_#e9ebed] rounded-lg">
        ' . $msg . '</p>';
        }
    }
}


function generateColors($startColor, $endColor, $numColors) {
    $startRGB = sscanf($startColor, "#%02x%02x%02x");
    $endRGB = sscanf($endColor, "#%02x%02x%02x");

    $colors = array();

    for ($i = 0; $i < $numColors; $i++) {
        $newColor = "#";
        for ($j = 0; $j < 3; $j++) {
            $colorComponent = round($startRGB[$j] + ($endRGB[$j] - $startRGB[$j]) * ($i / ($numColors - 1)));
            $newColor .= str_pad(dechex($colorComponent), 2, "0", STR_PAD_LEFT);
        }
        $colors[] = $newColor;
    }

    return $colors;
}

function extractPathAfterKeyword($input_str, $keyword) {
    $pos = strpos($input_str, $keyword);
    if ($pos !== false) {
        return substr($input_str, $pos);
    }
    return "";
}

function validatePassword($input_str) {
    $regex = '/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[0-9])(?=.{8,})/';

    return preg_match($regex, $input_str);
}

function get_list_calculate_weight() {
    return [
        'rebar' => [
            'title' => 'محاسبه وزن میلگرد',
            'formula' => '((((((a / 2)*(a / 2))*b)*3.14)*7.8)/1000)*c',
            'items' => [
                'product_diameter' => [
                    'next' => 'میلیمتر',
                    'name' => 'قطر (سایز)',
                    'placeholder' => '12',
                    'symbol' => 'a',
                ],
                'product_length' => [
                    'next' => 'متر',
                    'name' => 'طول (h)',
                    'placeholder' => '6',
                    'symbol' => 'b',
                ],
                'product_count' => [
                    'name' => 'تعداد',
                    'next' => '',
                    'placeholder' => '2',
                    'symbol' => 'c',
                ],
            ]
        ],
        'profile' => [
            'title' => 'محاسبه وزن پروفیل',
            'formula' => '((((((z+y)*2)*c)*b)*7.85)*d)/1000',
            'items' => [
                'product_clip_length' => [
                    'name' => ' طول مقطع ',
                    'next' => 'میلیمتر',
                    'placeholder' => '10',
                    'symbol' => 'z',
                ],
                'product_show_clip' => [
                    'name' => ' عرض مقطع ',
                    'next' => 'میلیمتر',
                    'placeholder' => '25',
                    'symbol' => 'y',
                ],
                'product_length' => [
                    'name' => ' طول شاخه ',
                    'next' => 'متر',
                    'placeholder' => '6',
                    'symbol' => 'b',
                ],
                'product_thickness' => [
                    'name' => 'ضخامت',
                    'next' => 'میلیمتر',
                    'placeholder' => '1.25',
                    'symbol' => 'c',
                ],
                'product_count' => [
                    'name' => 'تعداد',
                    'next' => '',
                    'placeholder' => '2',
                    'symbol' => 'd',
                ],
            ]
        ],
        'pipe' => [
            'title' => 'محاسبه وزن لوله',
            'formula' => '(a*b*(c / 6)*147*d)/1000',
            'items' => [
                'product_diameter' => [
                    'name' => 'قطر',
                    'next' => 'میلیمتر',
                    'placeholder' => '10',
                    'symbol' => 'a',
                ],
                'product_thickness' => [
                    'name' => 'ضخامت',
                    'next' => 'میلیمتر',
                    'placeholder' => '1',
                    'symbol' => 'b',
                ],
                'product_length' => [
                    'name' => 'طول (h)',
                    'next' => 'متر',
                    'placeholder' => '6',
                    'symbol' => 'c',
                ],
                'product_count' => [
                    'name' => 'تعداد',
                    'next' => '',
                    'placeholder' => '2',
                    'symbol' => 'd',
                ],
            ]
        ],
        'sheet' => [
            'title' => 'محاسبه وزن ورق',
            'formula' => '(a*b*c*7.85)*d',
            'items' => [
                'product_length' => [
                    'name' => 'طول ورق ',
                    'next' => 'متر',
                    'placeholder' => '2',
                    'symbol' => 'a',
                ],
                'product_thickness' => [
                    'name' => 'عرض ورق',
                    'next' => 'متر',
                    'placeholder' => '0.66',
                    'symbol' => 'b',
                ],
                'product_size' => [
                    'name' => 'ضخامت',
                    'next' => '',
                    'placeholder' => '0.3',
                    'symbol' => 'c',
                ],
                'product_count' => [
                    'name' => 'تعداد',
                    'next' => '',
                    'placeholder' => '2',
                    'symbol' => 'd',
                ],
            ]
        ],
        'corner' => [
            'title' => 'محاسبه وزن نبشی',
            'formula' => '((a*2*b*c*7.86)/1000)*d',
            'items' => [
                'product_length' => [
                    'name' => 'سایز',
                    'next' => 'میلیمتر',
                    'placeholder' => '50',
                    'symbol' => 'a',
                ],
                'product_thickness' => [
                    'name' => 'ضخامت',
                    'next' => 'میلیمتر',
                    'placeholder' => '5',
                    'symbol' => 'b',
                ],
                'product_size' => [
                    'name' => 'طول (h)',
                    'next' => 'متر',
                    'placeholder' => '6',
                    'symbol' => 'c',
                ],
                'product_count' => [
                    'name' => 'تعداد',
                    'next' => '',
                    'placeholder' => '2',
                    'symbol' => 'd',
                ],
            ]
        ],
        'girder' => [
            'title' => 'محاسبه وزن تیرآهن',
            'formula' => 'a*b',
            'items' => [
                'product_size' => [
                    'name' => 'سایز',
                    'placeholder' => '8',
                    'symbol' => 'a',
                ],
                'product_length' => [
                    'name' => 'طول (h)',
                    'next' => 'متر',
                    'placeholder' => '12',
                    'symbol' => 'b',
                ],
                'product_count' => [
                    'name' => 'تعداد',
                    'next' => '',
                    'placeholder' => '2',
                    'symbol' => 'c',
                ],
            ]
        ],
    ];
}

function remove_query_params_from_url($url, $params_to_remove) {
    // Parse the URL into components
    $url_parts = parse_url($url);

    // If there are no query parameters, return the original URL
    if (!isset($url_parts['query'])) {
        return $url;
    }

    // Parse the query string into an associative array
    parse_str($url_parts['query'], $query_params);

    // Remove the specified parameters from the query array
    foreach ($params_to_remove as $param) {
        unset($query_params[$param]);
    }

    // Rebuild the query string
    $new_query_string = http_build_query($query_params);

    // Rebuild the URL without the removed parameters
    $new_url = $url_parts['scheme'] . '://' . $url_parts['host'] . $url_parts['path'];
    if (!empty($new_query_string)) {
        $new_url .= '?' . $new_query_string;
    }

    return $new_url;
}

function map_user_administrator_id($item) {
    return ($item->ID);
}

function get_user_administrator_id() {
    $get_user_administrator_id = get_users(
        [
            'role' => 'Administrator'
        ]
    );
    $list_admin_user_id = array_map("map_user_administrator_id", $get_user_administrator_id);
    return $list_admin_user_id;
}


function send_email_request_record($consultation_id) {
    $to = get_field("email_send_notification_request", 'option') ?? 'fatehiali7466@gmail.com';
    if ($consultation_id) {
        $mobile = get_field("mobile", $consultation_id) ?? '';
        $user_email = get_field("email", $consultation_id) ?? '';
        $displayname = get_field("displayname", $consultation_id) ?? '';
        $description = get_field("description", $consultation_id) ?? '';
        $receive_notifications_inquiry = get_field("receive_notifications_inquiry", $consultation_id) ?? '';
        $link_edit = get_edit_post_link($consultation_id);
        $subject = 'درخواست مشاوره جدید';
        $body = "مشتری گرامی،\n\n";
        $body .= "درخواست مشاوره جدیدی دریافت شده است. جزئیات زیر را بررسی کنید:\n\n";
        $body .= "نام: $displayname\n";
        $body .= "ایمیل: $user_email\n";
        $body .= "تلفن همراه: $mobile\n";
        $body .= "توضیحات: $description\n\n";
        $body .= "راه ارتباطی: $receive_notifications_inquiry\n\n";
        $body .= "لینک در سایت: $link_edit\n\n";
        $body .= "با تشکر";

        $headers[] = 'Content-type: text/plain; charset=utf-8';
        $headers[] = 'From:' . "imomid@gmail.com";

        $statusEmail = wp_mail($to, $subject, $body, $headers);
    }
    if ($statusEmail) {
        return [
            "success" => true,
            "msg" => "درخواست مشاوره جدید ارسال شد ",
        ];
    } else {
        return [
            "success" => false,
            "msg" => "مشکلی به وجود امده ",
        ];
    }
}

function getCurrentUrl() {
    $protocol = is_ssl() ? 'https://' : 'http://';
    return ($protocol) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
}

function compare_urls($url_to_compare) {
    global $wp;
    if ($url_to_compare) {
        $current_url = getCurrentUrl();
        $cleaned_url = trailingslashit(strtolower(rtrim($url_to_compare, '/')));
        $current_url = trailingslashit(strtolower(rtrim($current_url, '/')));
        if ($current_url == $cleaned_url) {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}



add_action('wp', function () {
    remove_action('woocommerce_login_form', 'woocommerce_output_login_form', 10);
});



add_filter('body_class', function($classes) {
    global $shopi_options;
    if (!empty($shopi_options['mini_access_bar_enabled']) && $shopi_options['mini_access_bar_enabled'] === '1') {
        $classes[] = 'mini-access-bar-enabled'; 
    }

    return $classes;
});


add_action('wp_footer', function () {
    global $shopi_options;

    if (empty($shopi_options['mini_access_bar_enabled'])) {
        return;
    }

    if (
        !isset($shopi_options['mini_access_bar']['redux_repeater_data']) ||
        empty($shopi_options['mini_access_bar']['redux_repeater_data'])
    ) {
        return;
    }
    ?>
    <div class="access-mobile border border-[#e1ebebb3] rounded-[10px] fixed bottom-3 mx-[15px] left-0 right-0 z-[999] pb-2 pt-3 hidden ml:grid bg-white">
        <div class="flex">
            <?php
            foreach ($shopi_options['mini_access_bar']['redux_repeater_data'] as $key => $link) {
                $item       = $shopi_options['mini_access_bar'];
                $link_text  = isset($item['title'][$key]) ? $item['title'][$key] : '';
                $link_url   = isset($item['link'][$key]) ? $item['link'][$key] : '#';
                $link_class = isset($item['class'][$key]) ? $item['class'][$key] : '';
                $icon       = isset($item['icon'][$key]) ? $item['icon'][$key]['id'] : '';
                ?>
                <a href="<?= esc_attr($link_url) ?>" class="flex-1 flex flex-col gap-3 items-center justify-center cursor-pointer <?= esc_attr($link_class) ?>">
                    <?php if (!empty($icon)) : ?>
                        <?= wp_get_attachment_image($icon, "full", false, ['class' => 'w-4 h-4 object-contain']) ?>
                    <?php endif; ?>
                    <span class="text-[12px] text-[#757575] font-bold"><?= esc_html($link_text) ?></span>
                </a>
                <?php
            }
            ?>
        </div>
    </div>
    <?php
});


add_action('wp_footer', function () {
    ?>
    <div id="mini-cart-mobile" class="mini-cart-mobile box-mini-cart flex flex-col">
        <div class="action-close-min-cart flex items-center justify-between border-b-2 border-[#e9f3f3] pb-5 cursor-pointer p-5">
            <span class="text-[16px] text-[#7f7777] font-bold">سبد خرید</span>
            <i class="text-[#fff] text-[8px] w-5 h-5 rounded-[6px] bg-primary_bg flex items-center justify-center cursor-pointer">
                <svg class="fill-white w-[9px] h-[8px]">
                    <use xlink:href="#close-icon">
                    </use>
                </svg>
            </i>
        </div>
        <div class="border border-[#dfe4ed] rounded-[20px] bg-white append-mini-cart h-full">
            <?php get_template_part('woocommerce/cart/mini-cart') ?>
        </div>
    </div>
<?php
});
