document.addEventListener('DOMContentLoaded', function () {
    const currentUrl = window.location.href;

    new QRCode(document.getElementById("qrcode"), {
        text: currentUrl,
        width: 50,
        height: 50,
        colorDark: "#000000",
        colorLight: "#ffffff",
        correctLevel: QRCode.CorrectLevel.H
    });
});

document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('save-button').addEventListener('click', saveAsJPG);

    async function saveAsJPG() {
        const element = document.getElementById('print-content');
        const orderNumber = document.getElementById('order-number').innerText;

        if (!element || !orderNumber) {
            console.error('عنصر مورد نظر یافت نشد.');
            return;
        }

        // document.getElementById('print-button-box').style.display = 'flex';

        try {
            const canvas = await html2canvas(element, { useCORS: true });
            const imgData = canvas.toDataURL('image/jpeg', 1.0);

            const link = document.createElement('a');
            link.href = imgData;
            link.download = `factor-${orderNumber}.jpg`;

            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        } catch (error) {
            console.error('Error creating JPG:', error);
        } finally {
            // document.getElementById('print-button-box').style.display = 'none';
        }
    }
});

document.getElementById('download-pdf').addEventListener('click', function () {
    var element = document.getElementById('print-content');
    const orderNumber = document.getElementById('order-number').innerText;

    html2canvas(element, {
        useCORS: true,
        allowTaint: true
    }).then(function (canvas) {
        var imgData = canvas.toDataURL('image/png');
        var pdf = new jspdf.jsPDF('p', 'mm', 'a4');
        var imgWidth = 210;
        var imgHeight = canvas.height * imgWidth / canvas.width;
        pdf.addImage(imgData, 'PNG', 0, 0, imgWidth, imgHeight);
        pdf.save(`factor-${orderNumber}.pdf`);

    }).catch(function (error) {
        console.error('Error capturing content:', error);
    });
});

