<?php
function generate_ai_reply_from_comment($comment_id) {
    global $shopi_options;

    if (empty($shopi_options['enable_openai_comments']) || !$shopi_options['enable_openai_comments']) {
        return;
    }

    $comment = get_comment($comment_id);
    $comment_content = $comment->comment_content;

    $api_key = $shopi_options['openai_api_key'];
    $openai_comment_author = $shopi_options['openai_comment_author'] ?? 'ربات هوش مصنوعی';
    $model = $shopi_options['openai_model_comments'] ?? 'gpt-3.5-turbo';
    $max_tokens = (int) ($shopi_options['openai_max_tokens_comments'] ?? 1000);
    $temperature = isset($shopi_options['openai_temperature_comments']) ? (float)$shopi_options['openai_temperature_comments'] : 0.7;

    if (empty($api_key)) {
        error_log('کلید API تنظیم نشده است.');
        return;
    }

    $site_name = get_option('blogname', 'سایت ناشناخته');
    $site_url = get_option('home', '');
    $product_description = 'جزئیات و قیمت‌های محصول به‌روز هستند.';

    $product_id = null;
    if ($comment->comment_post_ID) {
        $product_id = $comment->comment_post_ID;
    }

    if ($product_id) {
        $product = wc_get_product($product_id);
        if ($product) {
            $product_title = $product->get_name();
            $product_price = $product->get_price();
            $product_description = $product->get_description();
            $product_sku = $product->get_sku();
        } else {
            $product_title = 'محصول پیدا نشد';
            $product_price = 'قیمت محصول در دسترس نیست';
            $product_description = 'توضیحات محصول در دسترس نیست';
            $product_sku = 'شناسه محصول در دسترس نیست';
        }
    } else {
        $product_title = 'محصول مرتبط یافت نشد';
        $product_price = 'قیمت محصول در دسترس نیست';
        $product_description = 'توضیحات محصول در دسترس نیست';
        $product_sku = 'شناسه محصول در دسترس نیست';
    }

    $messages = [
        ['role' => 'system', 'content' => 'شما یک دستیار مفید هستید.'],
        ['role' => 'user', 'content' => $comment_content],
        ['role' => 'assistant', 'content' => "جزئیات محصول به شرح زیر است:\n\nعنوان محصول: $product_title\nقیمت: $product_price\nتوضیحات: $product_description\nشناسه محصول: $product_sku"]
    ];

    $api_url = 'https://api.openai.com/v1/chat/completions';

    $response = wp_remote_post($api_url, [
        'headers' => [
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . $api_key,
        ],
        'body' => json_encode([
            'model' => $model,
            'messages' => $messages,
            'max_tokens' => (int) $max_tokens,
            'temperature' => (float) $temperature,
        ]),
    ]);

    if (is_wp_error($response)) {
        error_log('خطا در اتصال به OpenAI: ' . $response->get_error_message());
        return;
    }

    $response_body = json_decode(wp_remote_retrieve_body($response), true);

    if (!empty($response_body['choices'][0]['message']['content'])) {
        $ai_reply = trim($response_body['choices'][0]['message']['content']);
        $auto_approve = !empty($shopi_options['auto_approve_openai_replies']) && $shopi_options['auto_approve_openai_replies'];

        wp_insert_comment([
            'comment_post_ID' => $comment->comment_post_ID,
            'comment_content' => $ai_reply,
            'comment_type' => '',
            'comment_parent' => $comment_id,
            'user_id' => 0,
            'comment_author' => $openai_comment_author,
            'comment_author_email' => 'noreply@' . $site_url,
            'comment_approved'     => $auto_approve ? 1 : 0,
        ]);
    }
}

add_action('comment_post', 'generate_ai_reply_from_comment');


// Add custom row actions for title and content optimization
function add_optimize_row_actions($actions, $post) {
    // Check if it's a post (or any other type you want)
    if (in_array($post->post_type, ['post'])) {
        // Add a row action for optimizing the title
        $actions['optimize_title'] = '<a href="' . admin_url('admin.php?action=optimize_title_with_openai&post_id=' . $post->ID) . '">بهینه‌سازی عنوان با OpenAI</a>';

        // Add a row action for optimizing the content
        $actions['optimize_content'] = '<a href="' . admin_url('admin.php?action=optimize_content_with_openai&post_id=' . $post->ID) . '">بهینه‌سازی محتوا با OpenAI</a>';
    }
    return $actions;
}
add_filter('post_row_actions', 'add_optimize_row_actions', 10, 2);

// Handle the optimization actions
function handle_optimization_actions() {
    // Check if the action for title optimization is triggered
    if (isset($_GET['action']) && $_GET['action'] == 'optimize_title_with_openai' && isset($_GET['post_id'])) {
        $post_id = intval($_GET['post_id']);
        $post = get_post($post_id);

        if ($post) {
            // Optimize the title using OpenAI
            global $shopi_options;
            $model = $shopi_options['openai_model_titles'] ?? 'gpt-3.5-turbo';
            $max_tokens = (int) ($shopi_options['openai_max_tokens_titles'] ?? 1000);
            $temperature = isset($shopi_options['openai_temperature_titles']) ? (float)$shopi_options['openai_temperature_titles'] : 0.7;

            $optimized_title = openai_optimize_text($post->post_title, 'title', $model, $max_tokens, $temperature);
            wp_update_post(array(
                'ID' => $post_id,
                'post_title' => $optimized_title,
            ));
            // Redirect to avoid re-triggering the action
            wp_redirect(admin_url('edit.php?post_type=post'));
            exit;
        }
    }

    // Check if the action for content optimization is triggered
    if (isset($_GET['action']) && $_GET['action'] == 'optimize_content_with_openai' && isset($_GET['post_id'])) {
        $post_id = intval($_GET['post_id']);
        $post = get_post($post_id);

        if ($post) {
            // Optimize the content using OpenAI
            global $shopi_options;
            $model = $shopi_options['openai_model_content'] ?? 'gpt-3.5-turbo';
            $max_tokens = (int) ($shopi_options['openai_max_tokens_content'] ?? 1000);
            $temperature = isset($shopi_options['openai_temperature_content']) ? (float)$shopi_options['openai_temperature_content'] : 0.7;

            $optimized_content = openai_optimize_text($post->post_content, 'content', $model,  $max_tokens, $temperature);
            wp_update_post(array(
                'ID' => $post_id,
                'post_content' => $optimized_content,
            ));
            // Redirect to avoid re-triggering the action
            wp_redirect(admin_url('edit.php?post_type=post'));
            exit;
        }
    }
}
add_action('admin_init', 'handle_optimization_actions');

// Function to send text to OpenAI and return the optimized version
function openai_optimize_text($text, $type = 'title', $model = 'gpt-3.5-turbo', $max_tokens = 1000, $temperature = 0.7) {
    global $shopi_options;

    // Get the API key from Redux options
    $api_key = $shopi_options['openai_api_key'];

    // Define the system message based on the optimization type
    $system_message = ($type === 'title')
        ? 'شما یک متخصص بهبود عنوان هستید. عنوان را برای جذب بیشتر کاربران بهبود دهید.'
        : 'شما یک متخصص بهبود محتوا هستید. محتوا را برای جذب بیشتر کاربران بهینه کنید.';

    // Send a request to the OpenAI API
    $response = wp_remote_post('https://api.openai.com/v1/chat/completions', array(
        'body'    => json_encode(array(
            'model' => $model,  // Use the provided model
            'messages' => [
                ['role' => 'system', 'content' => $system_message],
                ['role' => 'user', 'content' => $text],
            ],
            'max_tokens' => $max_tokens,  // Use the provided max_tokens value
            'temperature' => $temperature,  // Use the provided temperature value
        )),
        'headers' => array(
            'Authorization' => 'Bearer ' . $api_key,
            'Content-Type'  => 'application/json',
        ),
    ));

    // Check for any error in the response
    if (is_wp_error($response)) {
        return $text;  // If there's an error, return the original text
    }

    // Get the response body
    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);
    // Return the optimized text
    return $data['choices'][0]['message']['content'] ?? $text;
}
