<?php
if (version_compare(PHP_VERSION, '8.1.0', '<')) {
    return;
}

require_once __DIR__ . '/vendor/autoload.php';

// use App\Admin\MenusController;

// (new MenusController);

global $shopi_options;

if (!$shopi_options['modian_enable']) {
    return;
}

if (!class_exists('\SnappMarketPro\Moadian\Moadian')) {
    // Handle error if Moadian class is missing
    $error_message = "کلاس Moadian موجود نیست. لطفا بسته یا کلاس مورد نیاز را نصب کنید.";
    add_settings_error('your-plugin', 'moadian-error', $error_message, 'error');
    settings_errors('your-plugin');
    return;
}

// Your existing code for Moadian integration
$modian_api = $shopi_options['modian_api'];

$username = $shopi_options['modian_username'];
$taxOrgPublicKey = '';
$privateKey = $shopi_options['modian_private_key'];
$taxOrgKeyId = '';
$baseUrl = $modian_api === 'original' ? 'https://tp.tax.gov.ir/' : 'https://sandboxrc.tax.gov.ir/';


// Create an instance of the Moadian class
try {
    $moadian = new \SnappMarketPro\Moadian\Moadian(
        $taxOrgPublicKey,
        $privateKey,
        $taxOrgKeyId,
        $username,
        $baseUrl
    );

    // Make the request to the server
    $response = $moadian->getServerInformation();

    // Store public key
    $taxOrgKeyId = $response['result']['data']['publicKeys'][0]['id'];
    update_option("taxOrgKeyIdModian", $taxOrgKeyId);

    $publicKey = $response['result']['data']['publicKeys'][0]['key'];
    $file = fopen(__DIR__ . "/public.key", 'w+');
    fwrite($file, "-----BEGIN PUBLIC KEY-----\n");
    fwrite($file, chunk_split($publicKey, 64, "\n"));
    fwrite($file, "-----END PUBLIC KEY-----\n");
    fclose($file);
} catch (Exception $e) {
    // echo "خطا: " . $e->getMessage();
}


function send_invoice_to_modian($order_id) {
    try {
        // Get the Shopi options
        global $shopi_options;
        $modian_api = $shopi_options['modian_api'];
        $username = $shopi_options['modian_username'];
        $privateKey = $shopi_options['modian_private_key'];
        $baseUrl = $modian_api === 'original' ? 'https://tp.tax.gov.ir/' : 'https://sandboxrc.tax.gov.ir/';
        $taxId = $shopi_options['modian_tax_id'];

        // Load the private key and public key
        $privateKey = file_get_contents('private.key');
        if (!$privateKey) {
            throw new Exception('Private key could not be loaded.');
        }
        $taxOrgPublicKey = file_get_contents('moadian-public.key');
        if (!$taxOrgPublicKey) {
            throw new Exception('Public key could not be loaded.');
        }
        $taxOrgKeyId = get_option('taxOrgKeyIdModian', true) ?? '';

        // Get the WooCommerce order object
        $order = wc_get_order($order_id);
        if (!$order) {
            throw new Exception('Invalid order ID.');
        }

        // Create an instance of the Moadian class
        $moadian = new \SnappMarketPro\Moadian\Moadian(
            $taxOrgPublicKey,
            $privateKey,
            $taxOrgKeyId,
            $username,
            $baseUrl
        );

        // Set up the invoice header (Header)
        $invoiceHeader = new \SnappMarketPro\Moadian\Dto\InvoiceHeaderDto();
        $invoiceHeader->setTaxid('Tax ID');
        $invoiceHeader->setIndati2m(time() * 1000); // Timestamp for the invoice
        $invoiceHeader->setIndatim(time() * 1000); // Timestamp for the invoice
        $invoiceHeader->setInty(2); // Type of invoice
        $invoiceHeader->setInno($order_id); // Invoice number
        $invoiceHeader->setTins($taxId); // Your tax ID

        // Set up the invoice body (Body)
        $invoiceBody = new \SnappMarketPro\Moadian\Dto\InvoiceBodyDto();
        foreach ($order->get_items() as $item_id => $item) {
            $product = $item->get_product();
            $invoiceBody->setSstid($product->get_sku()); // Product SKU
            $invoiceBody->setSstt($item->get_name()); // Product name
            $invoiceBody->setAm($item->get_quantity()); // Quantity of the product
            $invoiceBody->setFee($item->get_total()); // Total amount
        }

        // Set up the payment details (Payment)
        $invoicePayment = new \SnappMarketPro\Moadian\Dto\InvoicePaymentDto();
        // Set payment details as required...

        // Set up the full invoice (Dto)
        $invoiceDto = new \SnappMarketPro\Moadian\Dto\InvoiceDto();
        $invoiceDto->setHeader($invoiceHeader);
        $invoiceDto->setBody([$invoiceBody]);
        $invoiceDto->setPayments([$invoicePayment]);

        // Log in to the Moadian system and get the token
        $token = $moadian->login();
        if (!$token) {
            throw new Exception('Failed to authenticate with Moadian.');
        }
        $moadian->setToken($token);

        // Send the invoice to Moadian
        $response = $moadian->sendInvoices([$invoiceDto]);

        // Check the response and store the identifiers
        if ($response['result'][0]['errorCode']) {
            throw new Exception('Error sending the invoice to Moadian: ' . $response['result'][0]['errorMessage']);
        } else {
            // Invoice sent successfully
            $uid = $response['result'][0]['uid'];
            $referenceNumber = $response['result'][0]['referenceNumber'];

            // Save the identifiers in the order meta
            update_post_meta($order_id, '_moadian_invoice_sent', true);
            update_post_meta($order_id, '_moadian_invoice_uid', $uid);
            update_post_meta($order_id, '_moadian_invoice_reference_number', $referenceNumber);

            return true;
        }
    } catch (Exception $e) {
        // Handle the exception by logging the error or displaying a message
        error_log('Error sending invoice to Modian: ' . $e->getMessage());
        return false;
    }
}


add_action('woocommerce_order_status_completed', 'send_invoice_to_moadian', 10, 1);

function send_invoice_to_moadian($order_id) {
    global $shopi_options;
    if (!$shopi_options['modian_auto_invoice']) {
        return;
    }

    // Check if the invoice has already been sent
    $already_sent = get_post_meta($order_id, '_moadian_invoice_sent', true);
    if ($already_sent) {
        // Invoice has already been sent, do nothing
        return;
    }

    send_invoice_to_modian($order_id);
}


// Adding a new column "Send to Modian" to the orders table
add_filter('manage_edit-shop_order_columns', 'add_send_modian_column_to_orders');
add_filter('manage_woocommerce_page_wc-orders_columns', 'add_send_modian_column_to_orders');
function add_send_modian_column_to_orders($columns) {
    $reordered_columns = array();

    foreach ($columns as $key => $column) {
        $reordered_columns[$key] = $column;

        // Adding the "Send to Modian" column after the order status column
        if ($key === 'order_status') {
            $reordered_columns['send-modian'] = __('مودیان', 'text-domain');
        }
    }

    return $reordered_columns;
}


add_action('manage_shop_order_posts_custom_column', 'display_send_modian_column_content', 10, 2);
add_action('manage_woocommerce_page_wc-orders_custom_column', 'display_send_modian_column_content', 10, 2);

function display_send_modian_column_content($column, $order) {
    if ($column === 'send-modian') {
        if (did_action('manage_shop_order_posts_custom_column')) {
            $order_id = $order;
            $order = wc_get_order($order);
        } elseif (did_action('manage_woocommerce_page_wc-orders_custom_column')) {
            $order_id = $order->get_id();
            $order = $order;
        }

        $icon_modian = 'ارسال به سامانه مودیان';
        $modian_url = wp_nonce_url(admin_url('edit.php?post_type=shop_order&send_modian_action=true&order_id=' . $order_id), 'send-modian');
        echo '<a href="' . esc_url($modian_url) . '" title="ارسال به سامانه مودیان" class="button modian-send">' . $icon_modian . '</a>';
    }
}


add_action('init', 'handle_send_modian_action');

function handle_send_modian_action() {
    if (isset($_GET['send_modian_action']) && $_GET['send_modian_action'] === 'true' && isset($_GET['order_id'])) {
        if (!isset($_GET['_wpnonce']) || !wp_verify_nonce($_GET['_wpnonce'], 'send-modian')) {
            wp_die(__('عدم اعتبارسنجی nonce. لطفا دوباره تلاش کنید.'));
        }

        $order_id = intval($_GET['order_id']);
        if ($order_id > 0) {
            $result = send_invoice_to_modian($order_id);

            if ($result) {
                wp_redirect(admin_url('edit.php?post_type=shop_order&send_modian_status=success'));
            } else {
                wp_redirect(admin_url('edit.php?post_type=shop_order&send_modian_status=error'));
            }
            exit;
        } else {
            wp_die(__('شناسه سفارش نامعتبر است.'));
        }
    }
}

add_action('admin_notices', 'display_send_modian_status_message');
function display_send_modian_status_message() {
    if (isset($_GET['send_modian_status'])) {
        $status = sanitize_text_field($_GET['send_modian_status']);
        if ($status === 'success') {
            echo '<div class="updated"><p>' . __('فاکتور با موفقیت به مودیان ارسال شد.', 'text-domain') . '</p></div>';
        } elseif ($status === 'error') {
            echo '<div class="error"><p>' . __('در ارسال فاکتور به مودیان خطا رخ داد.', 'text-domain') . '</p></div>';
        }
    }
}
