<?php

/* Creating create podcast post type
 */

function create_podcast_post_type() {

    // Set UI labels for Custom Post Type
    $labels = array(
        'name' => "پادکست ها ",
        'singular_name' => 'پادکست',
        'menu_name' => 'پادکست ها',
        'parent_item_colon' => 'سوال والد',
        'all_items' => 'همه پادکست ها',
        'view_item' => 'مشاهده پادکست',
        'add_new_item' => 'افزودن پادکست',
        'add_new' => 'افزودن پادکست',
        'edit_item' => 'ویرایش پادکست',
        'update_item' => 'بروزرسانی پادکست',
        'search_items' => 'جستجوی پادکست',
        'not_found' => 'پیدا نشد',
        'not_found_in_trash' => 'در زباله دان پیدا نشد.'
    );

    // Set other options for Custom Post Type
    $args = array(
        'label' => 'پادکست ها',
        'description' => 'پادکست ها',
        'labels' => $labels,
        'supports' => array(
            'title',
            'author',
            'custom-fields',
            'thumbnail',
        ),
        'taxonomies' => array('faq_category'),
        'hierarchical' => true,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-format-audio',
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'publicly_queryable' => true,
        'capability_type' => 'post',
        'show_in_rest' => true,
    );

    // Registering your Custom Post Type
    register_post_type('podcast', $args);
}

add_action('init', 'create_podcast_post_type', 0);


// create faq category taxonomy
add_action('init', function () {
    register_taxonomy('podcast_category', [], [
        'label' => 'دسته بندی پادکست ها',
        'hierarchical' => true,
        'show_admin_column' => true,
        'show_in_rest' => true,
        'labels' => [
            'singular_name' => 'دسته بندی پادکست ها',
            'all_items' => 'همه دسته بندی ها',
            'edit_item' => 'ویرایش دسته بندی',
            'view_item' => 'نمایش دسته بندی',
            'update_item' => 'بروزرسانی دسته بندی',
            'add_new_item' => 'افزودن دسته بندی پادکست ها',
            'new_item_name' => 'نام دسته بندی پادکست ها',
            'search_items' => 'جستجو دسته بندی پادکست ها',
            'parent_item' => 'دسته بندی والد',
            'parent_item_colon' => 'دسته بندی والد',
            'not_found' => 'پیدا نشد',
        ]
    ]);
    register_taxonomy_for_object_type('podcast_category', 'podcast');
});
