<?php
function post_assets_enqueue() {
    if (is_singular('post')) {
        wp_enqueue_script('Print', THEME_URL . '/includes/post/assets/js/printThis.js', array('jquery'), null, true);
    }
}

add_action('wp_enqueue_scripts', 'post_assets_enqueue');
function humanTiming($time_main) {

    $time = current_time('timestamp') - $time_main; // to get the time since that moment
    $time = ($time < 1) ? 1 : $time;
    $tokens = array(
        31536000 => 'سال ',
        2592000 => 'ماه ',
        604800 => 'هفته ',
        86400 => 'روز ',
        3600 => 'ساعت ',
        60 => 'دقیقه ',
        1 => 'ثانیه ',
    );

    // if ($time < 2592000) {

    foreach ($tokens as $unit => $text) {
        if ($time < $unit) {
            continue;
        }

        $numberOfUnits = floor($time / $unit);
        return $numberOfUnits . ' ' . $text . (($numberOfUnits > 1) ? '' : '') . 'پیش';
    }
}

function reading_time($id) {
    $content = get_post_field('post_content', $id);
    $word_count = strip_tags($content);
    $word_count = count(preg_split('~[^\p{L}\p{N}\']+~u', $word_count));
    $readingtime = ceil($word_count / 200);
    return $readingtime;
}

function query_generator_home($post_type, $per_page, $tax, $item) {
    $args = array(
        'post_type'      => $post_type,
        'posts_per_page' => $per_page,
        'order'          => 'DESC',
        'post_status'    => 'publish',
    );
    if ($item['type'] == 'selected') {
        $args['post__in'] = $item['selected'];
    }
    if ($item['type'] == 'category') {
        $args['tax_query'] = array(
            array(
                'taxonomy' => $tax,
                'field' => 'term_id',
                'terms' => $item['category'],
            )
        );
    }
    $query_post = new WP_Query($args);
    return $query_post;
}

add_filter('the_content', 'add_id_heading_content');
function add_id_heading_content($content) {
    global $post;
    if (is_single()) {
        // Add ID to heading
        $content = preg_replace_callback('/<h([1-3])[^>]*>(.*)<\/h([1-3])>/msU', function ($matches) {
            static $i = 1;
            $title = $matches[2];
            return '<h' . $matches[1] . ' id="section-' . $i++ . '">' . $title . '</h' . $matches[1] . '>';
        }, $content);
    }
    return $content;
}

add_filter('the_content', 'filter_scroll_heading_content');
function filter_scroll_heading_content($content) {
    global $post;
    if (is_single()) {
        // Make Help Box by headings
        $re = '/<h([1-3])[^>]*>(.*)<\/h([1-3])>/msU';
        preg_match_all($re, $content, $matches, PREG_SET_ORDER, 0);
        if (is_array($matches) && !empty($matches)) {
            $help_heading = '<aside class="sidebar-left col-span-3 pr-[15px] max-2xl:col-span-2 max-2xl:pr-0 max-2xl:-mr-[10px]"><div class="title-boxes title-single-blog sticky top-[40px]"><ul class="">';
            $i = 1;
            foreach ($matches as $heading) {
                $num = $i++;
                $help_heading .= "<li class='flex items-center mb-[20px]'>";
                $help_heading .= "<a href='#section-" . $num . "'  class='flex items-center text-[13px] text-[#233564] font-bold'>";
                $help_heading .= "<span class='icn inline-block relative z-10 h-[7px] w-[7px] rounded-[4px] border-[2px] border-[#ced5de] bg-white ml-[20px] max-2xl:ml-[10px]'></span><span class='txt text-[#8b9cb3] text-[13px] duration-300 cursor-pointer flex-1 line-clamp-1'>";
                $help_heading .= strip_tags($heading[2]);
                $help_heading .= "</span>";
                $help_heading .= "</a>";
                $help_heading .= "</li>";
            }
            $help_heading .= "</ul></div></aside>";
        }
        add_action('single_help_post', function () use ($help_heading) {
            echo $help_heading;
        });
    }
    remove_filter('the_content', 'filter_scroll_heading_content');
    return $content;
}

add_action('wp_ajax_set_post_like', 'set_post_like');
add_action('wp_ajax_nopriv_set_post_like', 'set_post_like');
function set_post_like() {
    $post_id = isset($_POST['post_id']) && !empty($_POST['post_id']) && is_numeric($_POST['post_id']) ? $_POST['post_id'] : null;
    if ($post_id) {
        $status = $_POST['status'] == 'like' ? 'like' : 'dislike';
        if (isset($_SERVER['REMOTE_ADDR'])) {
            $user_ip = sanitize_text_field($_SERVER['REMOTE_ADDR']);
        } else {
            return;
        }

        // Combine post ID & IP to form unique key
        $key = 'post_' . $status . '_like' . '_' . $user_ip . '_post_' . $post_id;

        // Get transient and store in variable
        $visited = get_transient($key);

        // Check if the Post ID/IP ($key) address is currently stored as a transient
        if (false === $visited) {
            // Store the unique key, Post ID & IP address for 12 hours if it does not exist
            set_transient($key, true, 60 * 60 * 24);

            // Now run post views function
            $count_key = 'post_' . $status;
            $count = get_post_meta($post_id, $count_key, true);

            if ($count === '') {
                // If the count doesn't exist, initialize it
                update_post_meta($post_id, $count_key, 1);
            } else {
                // Increment the count
                $count++;
                update_post_meta($post_id, $count_key, $count);
            }
            $message = 'رای شما با موفقیت ثبت شد ';
        } else {
            $message = 'رای شما ثبت شده است ';
        }
    }
    wp_send_json(
        array(
            'message' => @$message,
            'count' => count_post_like($post_id, $status)
        ),
        200
    );
}

function has_like_post($post_id, $status = 'like') {
    if (isset($_SERVER['REMOTE_ADDR'])) {
        $user_ip = sanitize_text_field($_SERVER['REMOTE_ADDR']);
    } else {
        return;
    }

    // Combine post ID & IP to form unique key
    $key = 'post_' . $status . '_like' . '_' . $user_ip . '_post_' . $post_id;

    // Get transient and store in variable
    $visited = get_transient($key);
    return $visited;
}

function count_post_like($id = null, $status = 'like') {
    $id = $id ?? get_the_ID();
    $count_key = 'post_' . $status;
    $count = get_post_meta($id, $count_key, true);

    // Return zero if post_views is not set or is empty
    return $count !== '' ? $count : 0;
}

//ajax fav,like => post,comment,product 
$action_user_list_id_count = "action_user_list_id_count";

function func_user_list_id_count() {
    if (is_user_logged_in()) {
        $result = generate_list_item_user($_POST['id'], $_POST['type'], $type_click = 'fav');
        $msg = $result['msg'];
        $status = $result['status'];
    } else {
        $msg = "لطفا ابتدا وارد شوید";
    }

    wp_send_json([
        'success' => "true",
        "msg" => $msg,
        "status" => $status

    ], 200);
}
add_action("wp_ajax_{$action_user_list_id_count}", 'func_user_list_id_count');


function generate_list_item_user($post_id, $type = 'post', $type_click = 'fav') {
    $current_user_id = get_current_user_id();
    if (!$current_user_id) {
        return [
            'msg' => 'لطفاً ابتدا وارد شوید',
            'status' => 'error'
        ];
    }

    $list_id_user = [];
    $has_count = true;
    $status = '';
    $msg = '';

    if (isset($post_id)) {
        $id_item = intval($post_id);

        // توابع پیش‌فرض
        $func_update = 'update_post_meta';
        $func_get    = 'get_post_meta';

        if ($type === 'comment') {
            $func_update = 'update_comment_meta';
            $func_get = 'get_comment_meta';
        } elseif ($type === 'post') {
            $type = get_post_type($id_item);
        }

        $name_meta = $type_click === 'save' ? 'wp_list_save_' : 'wp_list_fav_';

        $is_meta_key_user = metadata_exists("user", $current_user_id, $name_meta . $type);
        $count_item = intval($func_get($id_item, "wp_count_" . $type, true));

        if ($is_meta_key_user) {
            $list_id_user = get_user_meta($current_user_id, $name_meta . $type, true);
            $list_id_user = json_decode($list_id_user, true);
            if (!is_array($list_id_user)) $list_id_user = [];

            if (in_array($id_item, $list_id_user)) {
                unset($list_id_user[array_search($id_item, $list_id_user)]);
                update_user_meta($current_user_id, $name_meta . $type, json_encode(array_values($list_id_user)));
                if ($has_count) $func_update($id_item, "wp_count_" . $type, max(0, $count_item - 1));
                $msg = "با موفقیت حذف شد";
                $status = "remove";
            } else {
                $list_id_user[] = $id_item;
                update_user_meta($current_user_id, $name_meta . $type, json_encode($list_id_user));
                if ($has_count) $func_update($id_item, "wp_count_" . $type, $count_item + 1);
                $msg = "با موفقیت اضافه شد";
                $status = "add";
            }
        } else {
            $list_id_user[] = $id_item;
            update_user_meta($current_user_id, $name_meta . $type, json_encode($list_id_user));
            if ($has_count) $func_update($id_item, "wp_count_" . $type, $count_item + 1);
            $msg = "با موفقیت اضافه شد";
            $status = "add";
        }
    } else {
        $msg = "مشکلی در سایت رخ داده است";
        $status = "error";
    }

    return [
        'msg' => $msg,
        'status' => $status
    ];
}


function has_in_list_fl($id, $type) {
    if (is_user_logged_in()) {
        $list_user = get_user_meta(get_current_user_id(), "wp_list_fav_" . $type, true);
        $list_user = json_decode($list_user);
        if (!empty($list_user) && is_array($list_user)) {
            if (in_array($id, $list_user)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    } else {
        return false;
    }
}

function setPostViews($postID) {
    // Validate and sanitize postID
    if (!is_numeric($postID)) {
        return;
    }

    // Validate IP address
    if (isset($_SERVER['REMOTE_ADDR'])) {
        $user_ip = sanitize_text_field($_SERVER['REMOTE_ADDR']);
    } else {
        return;
    }

    // Combine post ID & IP to form unique key
    $key = 'post_views_' . $user_ip . '_post_' . $postID;

    // Get transient and store in variable
    $visited = get_transient($key);

    // Check if the Post ID/IP ($key) address is currently stored as a transient
    if (false === $visited) {
        // Store the unique key, Post ID & IP address for 12 hours if it does not exist
        set_transient($key, true, 60 * 60 * 12);

        // Now run post views function
        $count_key = 'views';
        $count = get_post_meta($postID, $count_key, true);

        if ($count === '') {
            // If the count doesn't exist, initialize it
            update_post_meta($postID, $count_key, 1);
        } else {
            // Increment the count
            $count++;
            update_post_meta($postID, $count_key, $count);
        }
    }
}

function custom_single_post_view_count() {
    if (is_single()) {
        $post_id = get_the_ID();
        setPostViews($post_id);
    }
}
add_action('wp', 'custom_single_post_view_count');

function count_post_views($post_id = null) {
    $post_id = $post_id ?? get_the_ID();
    $count_key = 'views';
    $post_views = get_post_meta($post_id, $count_key, true);

    // Return zero if post_views is not set or is empty
    return $post_views !== '' ? $post_views : 0;
}

function is_new_post($post_id, $new_label_day = 5) {
    $post_id = $post_id ?? get_the_ID();
    $post_date = get_post_time('U', true, $post_id);
    $current_date = current_time('timestamp');
    $date_diff = ($current_date - $post_date) / (60 * 60 * 24);

    if ($date_diff <= $new_label_day) {
        return true;
    } else {
        return false;
    }
}

function get_record_position($post_id) {
    global $wpdb;

    $post_status = 'publish';
    $post_type = 'podcast';

    $position = $wpdb->get_var(
        $wpdb->prepare(
            "SELECT position
            FROM (
                SELECT ID, 
                       @rownum := @rownum + 1 AS position
                FROM wp_posts, 
                     (SELECT @rownum := 0) r
                WHERE post_status LIKE %s
                  AND post_type LIKE %s
                ORDER BY ID ASC
            ) ranked
            WHERE ID = %d",
            $post_status,
            $post_type,
            $post_id
        )
    );

    return $position;
}



add_action('add_meta_boxes', 'add_english_title_metabox');
function add_english_title_metabox() {
    add_meta_box(
        'english_title_metabox',
        __('تنظیمات', 'your-textdomain'),
        'display_english_title_metabox',
        'product',
        'side',
        'default'
    );
}

function display_english_title_metabox($post) {
    $english_title = get_post_meta($post->ID, '_english_title', true);
?>
    <label for="english_title_field"><?php _e('عنوان انگلیسی را وارد کنید', 'your-textdomain'); ?></label>
    <input type="text" name="english_title_field" id="english_title_field" value="<?php echo esc_attr($english_title); ?>" style="width:100%;" />
<?php
}


add_action('save_post', 'save_english_title_meta');
function save_english_title_meta($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (isset($_POST['english_title_field'])) {
        update_post_meta($post_id, '_english_title', sanitize_text_field($_POST['english_title_field']));
    }
}



function product_shortcode($atts) {
    $atts = shortcode_atts(array(
        'id' => 0,
    ), $atts);

    if (!$atts['id'] || !is_numeric($atts['id'])) {
        return;
    }

    $product = wc_get_product($atts['id']);

    if (!$product) {
        return;
    }

    $title = $product->get_name();
    $description = wp_strip_all_tags($product->get_description()); 
    $description = wp_trim_words($description, 30, '...');
    $image = wp_get_attachment_url($product->get_image_id());
    $attributes = $product->get_attributes();

    ob_start();
?>
    <div class="initial call-to-action-product border-b border-[#e8ecf3] pb-10 a-md:pb-4">
        <span class="title-head text-[15px] text-[#718195] font-bold title-line pb-7">پیشنهاد میکنیم
            <span class="line"></span>
        </span>
        <div class="flex items-stretch gap-6 a-lg:gap-3 ml:flex-col">
            <a href="<?= get_the_permalink($product->get_id()) ?>" class="min-w-[380px] max-w-[380px] flex items-center justify-center a-lg:min-w-[280px] a-lg:max-w-[280px] ml:min-w-full ml:max-w-full img-action">
                <img src="<?= esc_url($image); ?>" alt="<?= esc_attr($title); ?>" class="object-contain max-h-[290px] m-auto">
            </a>
            <div class="grow flex flex-col">
                <div class="flex items-center gap-4 box-title">
                    <a href="<?= get_the_permalink($product->get_id()) ?>" class="title line-clamp-1 grow"><?= esc_html($title); ?></a>
                    <a class="link whitespace-nowrap no-underline" href="<?= get_the_permalink($product->get_id()); ?>">مشاهده محصول
                        <span class="w-[42px] h-[24px] bg-primary_bg rounded-[12px] flex items-center justify-start">
                            <svg class="fill-white w-[12px] h-[12px]">
                                <use xlink:href="#arrow-bold-left-icon"></use>
                            </svg>
                        </span>
                    </a>
                </div>
                <div class="flex items-start gap-12 a-xl:gap-6 a-sm:flex-col">
                    <p class="description line-clamp-7 max-w-[402px] min-w-[402px] a-lg:min-w-[280px] a-lg:max-w-[280px] a-sm:max-w-full a-sm:min-w-full">
                        <?= @esc_html($description); ?>
                    </p>
                    <div class="grow a-sm:w-full">
                        <?php if (isset($attributes) && !empty($attributes)) { ?>
                            <ul class="list_attr flex flex-col border-b border-[#e8ecf3] gap-4">
                                <?php foreach ($attributes as $attribute) :
                                    $attr = $product->get_attribute($attribute->get_name());
                                    $taxonomy = $attribute->get_taxonomy_object();
                                ?>
                                    <li class="!flex items-center justify-between gap-2">
                                        <span class="title-attr whitespace-nowrap"><?= @esc_html($taxonomy->attribute_label); ?> </span>
                                        <span class="content-attr line-clamp-1"><?= @esc_html($attr); ?> </span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php } ?>
                        <div class="flex flex-col gap-1 ">
                            <?= $product->get_price_html(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
    return ob_get_clean();
}
add_shortcode('product_shortcode', 'product_shortcode');



add_filter('get_avatar', 'disable_gravatar', 1, 5);
function disable_gravatar($avatar, $id_or_email, $size, $default, $alt) {
    return '';
}
add_filter('pre_option_show_avatars', '__return_false');



register_sidebar(array(
    'name' => 'سایدبار سینگل بلاگ',
    'id' => 'sidebar_blog', 'before_widget' => '<div id="%1$s" class="accordion accordion-group widget widget-side %2$s" data-closeall="true" data-defaultstate="open">',
    'before_widget' => '<div id="%1$s" class="accordion accordion-group widget widget-side %2$s" data-closeall="true" data-defaultstate="open">',
    'after_widget' => '</div>',
    'before_title' => '<div class="widget-title accordion-head"><span>',
    'after_title' => '</span><i class="icon icon-arrow-left"></i></div>',
));
