<?php
define("RATING_COUNT", 'rating_count');
define("RATING_SUM", 'rating_sum');
define("RATING_AVG", 'rating_avg');

function set_rating_post() {
    $rate_count = null;
    $post_id = isset($_POST['post_id']) && !empty($_POST['post_id']) && is_numeric($_POST['post_id']) ? $_POST['post_id'] : null;
    if (isset($_POST['rate_count']) && !empty($_POST['rate_count']) && is_numeric($_POST['rate_count'])) {
        if ($_POST['rate_count'] <= 5 && $_POST['rate_count'] >= 1) {
            $rate_count = $_POST['rate_count'];
        }
    }
    if (get_post_status($post_id) !== false && $rate_count !== null) {
        if (isset($_SERVER['REMOTE_ADDR'])) {
            $user_ip = sanitize_text_field($_SERVER['REMOTE_ADDR']);
        } else {
            return;
        }

        // Combine post ID & IP to form unique key
        $key = 'post_' . $user_ip . '_rating_' . $post_id;

        // Get transient and store in variable
        $rated_status = get_transient($key);

        // Check if the Post ID/IP ($key) address is currently stored as a transient
        if (false === $rated_status) {
            // Store the unique key, Post ID & IP address for 24 hours if it does not exist
            set_transient($key, true, 60 * 60 * 24);

            // Now run post views function
            $count = get_post_meta($post_id, RATING_COUNT, true);

            if ($count === '') {
                // If the count doesn't exist, initialize it
                update_post_meta($post_id, RATING_COUNT, 1);
                update_post_meta($post_id, RATING_SUM, $rate_count);
                update_post_meta($post_id, RATING_AVG, $rate_count);
            } else {
                // Increment the count
                $count++;
                update_post_meta($post_id, RATING_COUNT, $count);

                //sum rating
                $sum_rating = get_post_meta($post_id, RATING_SUM, true);
                $sum_final = $sum_rating + $rate_count;
                update_post_meta($post_id, RATING_SUM, $sum_final);

                //avg rating
                $sum_rating = get_post_meta($post_id, RATING_AVG, true);
                $avg_final = $sum_final / $count;
                update_post_meta($post_id, RATING_AVG, $avg_final);
            }
            $message = 'رای شما با موفقیت ثبت شد ';
        } else {
            $message = 'رای شما ثبت شده است ';
        }
    } else {
        $message = 'مشکلی پیش آمده';
    }
    wp_send_json(
        array(
            'message' => @$message,
            'count' => count_rating_post($post_id),
            'avg' => avg_rating_post($post_id)
        ),
        200
    );
}
add_action('wp_ajax_set_rating_post', 'set_rating_post');
add_action('wp_ajax_nopriv_set_rating_post', 'set_rating_post');

function count_rating_post($id = null) {
    $id = $id ?? get_the_ID();
    $result = get_post_meta($id, RATING_COUNT, true);

    // Return zero if post_views is not set or is empty
    return $result !== '' ? $result : 0;
}

function avg_rating_post($id = null) {
    $id = $id ?? get_the_ID();
    $result = get_post_meta($id, RATING_AVG, true);

    // Return zero if post_views is not set or is empty
    return $result !== '' ? ceil($result) : 0;
}
