<?php
function Ippanel_Send_Sms($apiKey, $patternCode, $originator, $recipient, $variables) {
    // URL for sending SMS with pattern
    $url = 'https://api2.ippanel.com/api/v1/sms/pattern/normal/send';

    // Data to be sent in the request
    $data = [
        'code' => $patternCode,
        'sender' => $originator,
        'recipient' => $recipient,
        'variable' => $variables,
    ];

    // cURL settings
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'apikey: ' . $apiKey,
    ]);

    // Execute the request
    $response = curl_exec($ch);

    // Handle cURL errors
    if (curl_errno($ch)) {
        return ['error' => curl_error($ch)];
    } else {
        $responseData = json_decode($response, true);
        curl_close($ch);

        // Return the response data from the API
        return $responseData;
    }
}
