<?php
function Melipayamak_Send_Sms($apiKey, $patternCode, $recipient, $variables) {
    $patternCode = intval($patternCode);
    $data = array(
        'bodyId' => $patternCode, // Message body ID
        'to' => "$recipient", // Recipient's phone number
        'args' => $variables // Pattern arguments
    );

    // Convert data to JSON format
    $data_string = json_encode($data);

    $apiKey = "https://console.melipayamak.com/api/send/shared/" . $apiKey;
    // cURL settings
    $ch = curl_init($apiKey);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST"); // Use POST request
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string); // Send the data

    // Disable SSL verification (for development environments)
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Make sure to enable this in production

    // Other settings
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Get the response
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json', // Content type JSON
        'Content-Length: ' . strlen($data_string) // Length of the content being sent
    ));

    // Send the request and get the response
    $result = curl_exec($ch);

    // Close the cURL connection
    curl_close($ch);
    return $result;
}
