<?php
add_filter('woocommerce_billing_fields', 'add_custom_billing_fields');
function add_custom_billing_fields($fields) {
    $lat_billing = get_option('lat_billing');
    $lng_billing = get_option('lng_billing');

    $fields['lat'] = array(
        'type'        => 'hidden',
        'label'       => '',
        'placeholder' => '',
        'required'    => false,
        'class'       => array('form-row-wide'),
        'clear'       => true,
        'value' => @esc_attr($lat_billing)
    );

    $fields['lng'] = array(
        'type'        => 'hidden',
        'label'       => '',
        'placeholder' => '',
        'required'    => false,
        'class'       => array('form-row-wide'),
        'clear'       => true,
        'value' => @esc_attr($lng_billing)
    );

    return $fields;
}


add_action('woocommerce_checkout_update_order_meta', 'save_custom_billing_fields');
function save_custom_billing_fields($order_id) {
    if (!empty($_POST['lat'])) {
        update_post_meta($order_id, 'lat', sanitize_text_field($_POST['lat']));
    }
    if (!empty($_POST['lng'])) {
        update_post_meta($order_id, 'lng', sanitize_text_field($_POST['lng']));
    }
}



add_action('woocommerce_admin_order_data_after_billing_address', 'display_custom_billing_fields_in_admin', 10, 1);
function display_custom_billing_fields_in_admin($order) {
    $custom_field_1 = get_post_meta($order->get_id(), 'lat', true);
    $custom_field_2 = get_post_meta($order->get_id(), 'lng', true);

    if (!empty($custom_field_1)) {
        echo '<p><strong>' . __('lat:', 'text-domain') . '</strong> ' . esc_html($custom_field_1) . '</p>';
    }
    if (!empty($custom_field_2)) {
        echo '<p><strong>' . __('lng:', 'text-domain') . '</strong> ' . esc_html($custom_field_2) . '</p>';
    }
}


add_action('woocommerce_admin_order_data_after_billing_address', 'display_custom_map_in_admin_order', 10, 1);
function display_custom_map_in_admin_order($order) {
    $lat = get_post_meta($order->get_id(), 'lat', true);
    $lng = get_post_meta($order->get_id(), 'lng', true);

    if ($lat && $lng) {
        $google_maps_url = "https://www.google.com/maps?q={$lat},{$lng}";
        $balad_url = "https://balad.ir/location?latitude={$lat}&longitude={$lng}";
        echo '<p>';
        echo '<a href="' . esc_url($google_maps_url) . '" target="_blank">مشاهده در Google Maps</a><br>';
        echo '<a href="' . esc_url($balad_url) . '" target="_blank">مشاهده در بلد</a>';
        echo '</p>';
    }
}
