<?php
// Walker main menu
class My_Custom_Walker_Nav_Menu extends Walker_Nav_Menu {
    function start_lvl(&$output, $depth = 0, $args = null) {

        // For sub-menu levels, if both parent and child have sub-menus
        if (isset($args->item_spacing) && 'discard' === $args->item_spacing) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        $indent = str_repeat($t, $depth);

        // HTML structure for sub-menu levels
        $classes = array('sub-menu');

        $class_names = join(' ', apply_filters('nav_menu_submenu_css_class', $classes, $args, $depth));
        $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';

        $output .= "{$n}{$indent}<ul$class_names>{$n}";
    }

    function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
        // HTML structure for each menu item
        if (isset($args->item_spacing) && 'discard' === $args->item_spacing) {
            $t = '';
            $n = '';
        } else {
            $t = "\t";
            $n = "\n";
        }
        $indent = ($depth) ? str_repeat($t, $depth) : '';

        $classes = empty($item->classes) ? array() : (array) $item->classes;
        $classes[] = ' menu-item-' . $item->ID;
        if ($depth == 0) {
            $classes[] = 'text-[15px] font-black leading-[14px] itm-menu cursor-pointer ml-[28px] relative duration-300 before:absolute before:duration-300 before:-bottom-[15px] before:left-0 before:w-full before:h-[3px] before:bg-[rgb(243,245,247)] before:rounded-[3px] max-2xl:ml-[15px]';
        } else {
            $classes[] = 'relative h-[45px] px-[25px] flex items-center justify-between text-white';
        }
        // If the menu item has sub-menu
        if (in_array('menu-item-has-children', $classes)) {
            $classes[] = 'relative megamenu';
        }

        // Additional classes for menu items
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args, $depth));
        $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';

        // Menu item ID
        $id = apply_filters('nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args, $depth);
        $id = $id ? ' id="' . esc_attr($id) . '"' : '';

        // Header items for each menu item
        $output .= $indent . '<li' . $id . $class_names . '>';

        // Link for each menu item
        $atts = array();
        $atts['title']  = !empty($item->attr_title) ? $item->attr_title : '';
        $atts['target'] = !empty($item->target)     ? $item->target     : '';
        $atts['rel']    = !empty($item->xfn)        ? $item->xfn        : '';
        $atts['href']   = !empty($item->url)        ? $item->url        : '';
        if ($depth == 0) {
            $atts['class']   = !empty($item->class)        ? $item->class        : 'title flex flex-col items-center justify-center gap-2';
        } else {
            $atts['class']   = !empty($item->class)        ? $item->class        : 'flex items-center justify-between h-full text-white w-full';
        }

        // Additional attributes for the link
        $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);

        $attributes = '';
        foreach ($atts as $attr => $value) {
            if (!empty($value)) {
                $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }

        // Link content
        $item_output = $args->before;
        $item_output .= '<a' . $attributes . '>';
        if ($depth != 0 &&  in_array('menu-item-has-children', $classes)) {
            $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . '<span class="icn">
                        <svg class="icon w-[11px] h-[11px] fill-color-c2">
                          <use xlink:href="#arrow-l"></use>
                        </svg>
                      </span>' . $args->link_after;
        } else {
            $title = apply_filters('the_title', $item->title, $item->ID);
            $title_parts = explode('.', $title);
            if (count($title_parts) > 1) {
                $first_part = trim($title_parts[0]);
                $second_part = trim($title_parts[1]);
                $item_output .= '<span class="text-[#C1CCDA] transition-s">' . $first_part . '</span>';
                $item_output .= '<span>' . $second_part . '</span>';
            } else {
                $item_output .= '<span>' . $title . '</span>';
            }
        }
        $item_output .= '</a>';
        $item_output .= $args->after;

        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }
}
