<?php
add_action('woocommerce_after_single_product', 'custom_content_after_single_product', 10, 2);
add_action('save_post', 'my_custom_action_on_publish', 10, 2);
function my_custom_action_on_publish($ID, $post) {
    update_price_package($ID);
}

function custom_content_after_single_product() {
    global $product;
    update_price_package($product->get_id());
}

function update_price_package($ID) {
    $ID = $ID ?? get_the_ID();
    if (get_post_type($ID) == 'product') {
        $is_package = get_field("is_package", $ID);
        if ($is_package) {
            $list_product = get_field("list_product", $ID);
            if ($list_product) {
                $product_main = wc_get_product($ID);
                $total = 0;
                foreach ($list_product as $key => $value) {
                    $product_id = $value['product'];
                    $product = wc_get_product($product_id);
                    if ($product->is_on_sale()) {
                        $price = $product->get_sale_price();
                    } else {
                        $price = $product->get_regular_price();
                    }
                    $total += $price;
                }
                $product_main->set_regular_price($total);

                $discount_type = get_field("discount_type", $ID);
                if ($discount_type == 'percent') {
                    $percent = get_field('discount_percent', $ID) ?? 0;
                    $percent_discount = $total * ($percent / 100);
                    $total_sale = $total - $percent_discount;
                } elseif ($discount_type == 'amount') {
                    $amount = get_field('discount_amount', $ID) ?? 0;
                    $total_sale = $total - $amount;
                }

                $product_main->set_sale_price($total_sale);
                $product_main->set_price('');
                $product_main->save();
            }
        }
    }
}
