<?php
global $post, $shopi_options;
$term_first = get_first_taxonomy_term(get_the_ID(), 'category');
$get_the_author = get_the_author_meta('display_name', $post->post_author);
$terms = wp_get_post_terms(get_the_ID(), 'category');
$term_ids = wp_get_post_terms(get_the_ID(), 'category', array('fields' => 'ids'));
$args = array(
    'post_type' => get_post_type(),
    'category__in' => $term_ids,
    'posts_per_page' => 6,
    'post__not_in' => [get_the_ID()]
);
$related_posts = new WP_Query($args);
$time =  reading_time(get_the_ID()) . ":00";
$home_url = home_url();
$title = get_the_title();
$url = get_the_permalink();
?>
<?php get_header() ?>
<div class="container 2xl m-auto">
    <div class="max-w-[1170px] min-w-[1170px] m-auto a-xl:max-w-full a-xl:min-w-full">
        <div class="flex items-stretch gap-11 mb-14 a-xl:mb-4 a-xl:gap-6 ml:flex-col">
            <div class="bg-[#e7ecf3] max-w-[465px] min-w-[465px] rounded-[9px] overflow-hidden min-h-[339px] max-h-[339px] ml:hidden">
                <?php if (has_post_thumbnail()) {
                    the_post_thumbnail('img_blog', array('loading' => 'lazy', 'class' => 'w-full h-full object-cover'));
                } else {
                    if (class_exists('WooCommerce')) {
                        echo wc_placeholder_img('full');
                    }
                } ?>
            </div>
            <div class="grow flex flex-col">
                <div class="mb-2 ml:mb-4 order-1">
                    <div class="breadcrumbs scrollbar-hide  flex items-center text-[13px] text-[#969fae] font-bold fill-[#cbd0da] grow">
                        <nav class="woocommerce-breadcrumb" aria-label="Breadcrumb">
                            <?= woocommerce_breadcrumb() ?>
                        </nav>
                    </div>
                </div>
                <div class="hidden ml:flex mb-4 order-3 rounded-[9px] overflow-hidden ">
                    <?php if (has_post_thumbnail()) {
                        the_post_thumbnail('img_blog', array('loading' => 'lazy', 'class' => 'w-full h-full object-cover'));
                    } else {
                        if (class_exists('WooCommerce')) {
                            echo wc_placeholder_img('full');
                        }
                    } ?>
                </div>
                <h1 class='text-[25px] text-[#394454] font-bold mb-10 line-clamp-1 a-xl:mb-6 a-lg:text-[18px] ml:mb-2 order-4 ml:order-1'>
                    <?php the_title() ?>
                </h1>
                <div class='text-[13px] text-[#495666] font-bold line-clamp-4 leading-[2.6] text-justify mb-8 mt-auto a-xl:mb-4 a-md:leading-[1.8] order-5'>
                    <?= get_the_excerpt() ?>
                </div>
                <div class="flex items-center gap-8 a-xl:gap-5 a-xl:flex-col ml:flex-row a-md:flex-col order-6">
                    <div class="flex items-center gap-7 grow a-xl:w-full a-xl:justify-center a-lg:gap-1 a-lg:justify-between a-md:flex-wrap a-md:gap-6">
                        <div class="flex items-center flex-col gap-1">
                            <span class='text-[21px] text-secondary_text  font-bold leading-[1]'><?= reading_time(get_the_ID()) ?></span>
                            <span class='text-[12px] text-secondary_text  font-bold'>دقیقه</span>
                        </div>
                        <div class="flex flex-col gap-1">
                            <span class='text-[14px] text-[#495666] font-bold'><?= @esc_attr($get_the_author) ?></span>
                            <span class='text-[12px] text-[#a3adb9] font-bold'>نویسنده</span>
                        </div>
                        <?php if (isset($term_first) && !empty($term_first)) { ?>
                            <div class="flex flex-col gap-1">
                                <a href="<?= get_term_link($term_first) ?>" class='text-[14px] text-[#495666] font-bold'><?= @esc_attr($term_first->name) ?></a>
                                <span class='text-[12px] text-[#a3adb9] font-bold'>موضوع</span>
                            </div>
                        <?php } ?>
                        <div class="flex flex-col gap-1">
                            <span class='text-[14px] text-[#495666] font-bold'><?= count_post_views(get_the_ID()) ?> نفر</span>
                            <span class='text-[12px] text-[#a3adb9] font-bold'>بازدید</span>
                        </div>
                        <div class="flex flex-col gap-1">
                            <span class='text-[14px] text-[#495666] font-bold'> <?= get_the_date('l j F Y', get_the_ID()) ?></span>
                            <span class='text-[12px] text-[#a3adb9] font-bold'>تاریخ انتشار</span>
                        </div>
                    </div>
                    <div class="flex items-center gap-8 a-xl:justify-center a-xl:w-full a-xl:gap-4 ml:w-max">
                        <div class="flex items-center flex-col gap-3 cursor-pointer favorites-event-post favorites-post-single" data-id="<?= get_the_ID() ?>">
                            <svg class='fill-[#969fae]  w-[15px] h-[15px] transition-3s'>
                                <use xlink:href='#heart-icon'>
                            </svg>
                            <span class='text-[12px] text-[#a3adb9] font-bold whitespace-nowrap'>افزودن به علاقه
                                مندی</span>
                        </div>
                        <a href="#box-social-media" class="flex items-center flex-col gap-3 cursor-pointer">
                            <svg class='fill-[#969fae]  w-[15px] h-[15px]'>
                                <use xlink:href='#share-icon'>
                            </svg>
                            <span class='text-[12px] text-[#a3adb9] font-bold'>اشتراک</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="relative mb-12 a-xl:flex a-xl:flex-col-reverse">
            <div class="sticky top-3 a-xl:relative a-xl:top-0">
                <ul id="box-social-media" class="list-social-footer flex items-end gap-8 absolute -right-7 top-7 flex-col list-social-footer-single translate-x-full a-xl:relative a-xl:top-0 a-xl:flex-row a-xl:translate-x-0 a-xl:right-0">
                    <li>
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?= $url ?>&amp;t=<?= $title ?>" title="Share on Facebook" target="_blank" rel="noreferrer nofollow noopener">
                            <svg class="fill-[#969fae]  w-[18px] h-[18px]">
                                <use xlink:href="#facebook-icon">
                                </use>
                            </svg>
                            <span>facebook</span>
                        </a>
                    </li>
                    <li>
                        <a href="https://telegram.me/share/url?url=<?= $url ?>&amp;text=<?= $title ?>:<?= $home_url ?>" title="telegram" rel="noreferrer nofollow noopener" target="_blank">
                            <svg class="fill-[#969fae]  w-[18px] h-[18px]">
                                <use xlink:href="#telegram-icon">
                                </use>
                            </svg>
                            <span>telegram</span>
                        </a>
                    </li>
                    <li>
                        <a href="whatsapp://send?text=<?= $url ?>" data-action="share/whatsapp/share" title="whatsapp" rel="noreferrer nofollow noopener" target="_blank">
                            <svg class="fill-[#969fae]  w-[18px] h-[18px]">
                                <use xlink:href="#whatsapp-icon">
                                </use>
                            </svg>
                            <span>whatsapp</span>
                        </a>
                    </li>
                    <li>
                        <a href="https://twitter.com/intent/tweet?source=<?= $url ?>&amp;text=<?= $title ?>:<?= $home_url ?>" target="_blank" title="Tweet" rel="noreferrer nofollow noopener" title="">
                            <svg class="fill-[#969fae]  w-[18px] h-[18px]">
                                <use xlink:href="#twitter-icon">
                                </use>
                            </svg>
                            <span>twitter</span>
                        </a>
                    </li>
                    <li>
                        <a href="http://www.linkedin.com/shareArticle?mini=true&url=<?= $url ?>&title=<?= $title ?>&source=<?= $home_url ?>" title="Share on linkedin" rel="noreferrer nofollow noopener" target="_blank">
                            <svg class="fill-[#969fae]  w-[18px] h-[18px]">
                                <use xlink:href="#linkedin-icon">
                                </use>
                            </svg>
                            <span>linkedin</span>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="sticky top-3 order-1">
                <div class="absolute -left-7 top-4 flex flex-col items-center justify-center gap-1 -translate-x-full a-xl:bg-white a-xl:left-0 a-xl:translate-x-0 a-xl:py-4 a-xl:rounded-[10px] a-xl:border a-xl:border-[#eee] a-xl:top-7 a-lg:top-24">
                    <span class="h-[56px] w-[5px] bg-[#eceff5] rounded-[3px] flex overflow-hidden">
                        <span class="bg-secondary_bg w-full mt-auto scroller-content" style="height: 0%;"></span>
                    </span>
                    <span class='text-[21px] text-secondary_text  font-bold'><?= reading_time(get_the_ID()) ?></span>
                    <span class='text-[12px] text-secondary_text  font-bold -rotate-90 flex'>دقیقه</span>
                </div>
            </div>
            <div class="text-[14px] text-[#495666] font-bold text-justify leading-[2.8] content-post">
                <?php the_content() ?>
            </div>
        </div>
        <div class="bg-[#f8f9fb] rounded-[9px] px-11 py-9 flex items-center gap-9 mb-12 tab:p-5 tab:flex-wrap tab:gap-y-3 tab:justify-between a-md:mb-8">
            <div class="flex items-center gap-6">
                <span class='text-[50px] text-secondary_text  font-bold leading-[1] flex avgRating'>
                    <?= avg_rating_post() ?>
                </span>
                <span class="flex flex-col gap-1">
                    <span class='text-[12px] text-[#969fae] font-bold'>امتیاز مقاله</span>
                    <div class="flex items-center flex-row-reverse gap-1 rating-post" data-id="<?= get_the_ID() ?>">
                        <svg data-count="1" class='fill-[#bbb6ac] w-[14px] h-[14px] item-star'>
                            <use xlink:href='#star-icon'>
                        </svg>
                        <svg data-count="2" class='fill-[#bbb6ac] w-[14px] h-[14px] item-star'>
                            <use xlink:href='#star-icon'>
                        </svg>
                        <svg data-count="3" class='fill-[#bbb6ac] w-[14px] h-[14px] item-star'>
                            <use xlink:href='#star-icon'>
                        </svg>
                        <svg data-count="4" class='fill-[#bbb6ac] w-[14px] h-[14px] item-star'>
                            <use xlink:href='#star-icon'>
                        </svg>
                        <svg data-count="5" class='fill-[#bbb6ac] w-[14px] h-[14px] item-star'>
                            <use xlink:href='#star-icon'>
                        </svg>
                    </div>
                </span>
            </div>
            <div class="flex flex-col gap-1">
                <span class='text-[12px] text-[#969fae] font-bold'>از مجموع</span>
                <span class='text-[12px] text-[#969fae] font-bold flex items-center justify-between'>
                    <ins class='text-[16px] text-secondary_text  font-bold countRating'><?= count_rating_post() ?></ins>رای
                </span>
            </div>
            <div class="flex items-center gap-5 cursor-pointer mr-auto tab:w-full tab:justify-center copy-link" data-url="<?= get_attachment_link(get_the_ID(), true); ?>">
                <span class='text-[13px] text-[#969fae] font-bold'><?= get_attachment_link(get_the_ID(), true); ?></span>
                <svg class='fill-[#969fae] w-4 h-4'>
                    <use xlink:href='#copy-clipboard-icon'>
                </svg>
            </div>
        </div>
        <?php if ($related_posts->have_posts()) { ?>
            <div class="mb-16 a-sm:mb-7">
                <span class="title-vip text-[15px] text-[#969fae] font-bold grow  a-md:text-[13px] mb-7 a-sm:mb-4">
                    پست هایی که مطالعه آن ها خالی از لطف نیست
                    <span class="line"></span>
                </span>
                <div class="swiper swiper-blog-slider">
                    <div class="swiper-wrapper">
                        <?php while ($related_posts->have_posts()) {
                            $related_posts->the_post();
                            $term_first_r = get_first_taxonomy_term(get_the_ID(), 'category');
                        ?>
                            <div class="swiper-slide min-w-[370px] max-w-[370px] tab:min-w-[320px] tab:max-w-[320px]">
                                <?php get_template_part('template-parts/cards/card-post') ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php
            wp_reset_query();
            wp_reset_postdata();
        } ?>
        <?php if (isset($shopi_options['banner_single_blog']['id']) && !empty($shopi_options['banner_single_blog']['id'])) { ?>
            <a class="mb-16 a-sm:mb-7 flex">
                <?= wp_get_attachment_image($shopi_options['banner_single_blog']['id'], 'full', false, ['class' => 'w-full h-auto object-contain m-auto rounded-[8px]']) ?>
            </a>
        <?php } ?>
        <div>
            <?php comments_template() ?>
        </div>
    </div>
</div>
<?php get_footer() ?>