module.exports = {
  content: ["./src/**/*.{html,js,php}"],
  purge: [
    './**/*.php',
  ],
  theme: {
    extend: {
      flex: {
        100: "0 0 100%",
      },
      colors: {
        primary_bg: 'var(--color-primary-bg)',
        primary_text: 'var(--color-primary-text)',
        primary_fill: 'var(--color-primary-fill)',
        secondary_bg: 'var(--color-secondary-bg)',
        secondary_text: 'var(--color-secondary-text)',
        secondary_fill: 'var(--color-secondary-fill)',
        responsive_cart_button: 'var(--responsive-cart-button)',
      },
    },
    fontFamily: {
      yekan: ["yekanbakh"],
    },
    lineClamp: {
      1: '1',
      2: '2',
      3: '3',
      4: '4',
      5: '5',
      6: '6',
      7: '7',
      8: '8',
    },
    screens: {
      '2xl': { 'max': '1499.98px' },
      // => @media (max-width: 1500px) { ... }

      'a-sxl': { 'max': '1399.98px' },
      // => @media (max-width: 1400px) { ... }

      'a-xl': { 'max': '1278.98px' },
      // => @media (max-width: 1279px) { ... }

      'lx': { 'max': '1199.98px' },
      // => @media (max-width: 1200px) { ... }

      'a-lg': { 'max': '1022.98px' },
      // => @media (max-width: 1023px) { ... }

      'ml': { 'max': '991.98px' },
      // => @media (max-width: 991px) { ... }

      'a-md': { 'max': '767.98px' },
      // => @media (max-width: 767px) { ... }

      'a-sm': { 'max': '638.98px' },
      // => @media (max-width: 639px) { ... }

      'tab': { 'max': '575.98px' },
      // => @media (max-width: 576px) { ... }

      'a-mob': { 'max': '425.98px' },
      // => @media (max-width: 576px) { ... }

      'mob': { 'max': '379.98px' },
      // => @media (max-width: 379.98px) { ... }
    },
  },
  plugins: [],
}