<?php
$class = get_query_var('class');
if (!$class) {
    $class = "item item-product item-product-slider relative w-[281px] rounded-[28px] tab:rounded-[12px] bg-white border border-[#f2f4f7] p-[30px] flex flex-col a-md:p-5  a-md:w-[257px] tab:min-w-full tab:max-w-full tab:h-full tab:p-2";
}
global $woocommerce, $product, $shopi_options;
$product = wc_get_product(get_the_ID());
$attr_color_card =  $shopi_options['color_variable_slug'] ?? 'pa_رنگ';
$crop_card_product =  $shopi_options['crop_card_product'] ?? 'thumbnail';
$status = $product->is_type('variable') ? 'variable' : 'simple';
$class .= $status;

if (isset($attr_color_card) && !empty($attr_color_card)) {
    $tax_color = wp_get_post_terms(get_the_ID(), $attr_color_card);
}

$_english_title = get_post_meta(get_the_ID(), '_english_title', true);
$status_quantity = $product->is_purchasable() && $product->is_in_stock() && !$product->is_type('variable');
$count_item = get_product_quantity_in_cart(get_the_ID());

$attachment_ids = $product->get_gallery_image_ids();
$gallery_pic = isset($attachment_ids[0]) && !empty($attachment_ids[0]) ? $attachment_ids[0] : null;
$class_pic = 'max-h-[inherit] min-h-[inherit] max-w-[inherit] object-contain m-auto tab:max-w-[70%] absolute left-0 right-0 top-0 bottom-0 transition-3s';
$second_image = $args['product_item_hover_second_image'] ?? '';
?>
<div class="<?= $class ?> <?= ($status == 'simple' && $count_item != 0) ? "active" : "" ?>" data-product-id="<?= get_the_ID() ?>">
    <div class="flex items-start justify-between tab:absolute tab:top-3 tab:z-10 tab:left-3 tab:right-3">
        <?php if (!is_wp_error($tax_color) && !empty($tax_color)) {
            $count = count($tax_color);
            $i = 1; ?>
            <div class="grid grid-cols-2 gap-[2px] w-max">
                <?php foreach ($tax_color as $key => $value) {
                    if ($i > 4) {
                        break;
                    }
                    $color = get_term_meta($value->term_id, 'product_attribute_color', true);
                    if ($color) {
                ?>
                        <span class="w-2 h-2 rounded-full" style="background-color: <?= @$color ?>;"></span>
                <?php
                        $i++;
                    }
                } ?>
                <?php if ($i > 4) {
                    $number =  $i - 4;
                ?>
                    <span class="col-span-2 text-[14px] text-[#969fae] font-bold flex items-center justify-center">
                        <?= @$number ?>+
                    </span>
                <?php } ?>
            </div>
        <?php } ?>
		<?php if ($shopi_options['display_product_info'] === 'rating') { ?>
			<span class="text-[14px] text-[#969fae] font-bold flex flex-col items-center justify-center gap-2 box-rate">
				<svg class="fill-[#cbcfd7] w-[13px] h-[13px]">
					<use xlink:href="#star-icon">
					</use>
				</svg>
				<?= avg_rating_post() ?>
			</span>
		<?php }else{ ?>
			<?php
					$custom_attr = get_post_meta(get_the_ID(), 'custom_attr', true);
					if (!empty($custom_attr)) {
							?>
							<span class="text-[12px] text-[#164B8A] font-bold border border-[#EEF2F6] rounded-[8px] px-3 py-1 inline-flex bg-white mr-auto">
								<?php echo esc_html($custom_attr); ?>
							</span>
							<?php
					}
				?>
		<?php } ?>

    </div>
    <a href="<?php the_permalink() ?>" class="box-pic w-full mb-8 a-md:mb-4 tab:mb-2 max-w-[150px] max-h-[140px] min-h-[140px] flex items-center justify-center m-auto relative <?= $second_image == "yes" ? "pic2" : "" ?>">
        <?php if (has_post_thumbnail()) {
            echo get_the_post_thumbnail(get_the_ID(), $crop_card_product, ['class' => "$class_pic primary-img"]);
        } else {
            echo wc_placeholder_img($crop_card_product, ['class' => 'object-contain m-auto primary-img']);
        } ?>
        <?php if ($second_image == 'yes' && $gallery_pic) { ?>
            <?= wp_get_attachment_image($gallery_pic, $crop_card_product, false,  ['class' => "$class_pic secondary-img"]) ?>
        <?php } ?>
    </a>
    <div class="mb-5 tab:mb-2">
        <h2>
            <a href="<?php the_permalink() ?>" class='title text-[15px] text-[#394454] font-bold line-clamp-2 tab:text-[13px] leading-[1.8] transition-3s'>
                <?php the_title() ?>
            </a>
        </h2>
        <!--<?php if (isset($_english_title) && !empty($_english_title)) { ?>
            <span class='text-[13px] text-[#8c98a5] font-bold line-clamp-1 uppercase'><?= @esc_attr($_english_title) ?></span>
        <?php } ?>-->
    </div>
    <div class="relative flex items-stretch justify-between mt-auto tab:flex-col-reverse tab:gap-2">
        <?php if ( $product && $product->is_in_stock() && $product->get_price() > 0 ) { ?>
            <?php woocommerce_template_loop_add_to_cart() ?>
        <?php } ?>
        <?php woocommerce_template_loop_price() ?>

        <?php if ( $product && $product->is_in_stock() && $product->get_price() > 0 ) { ?>
            <?php if ($status_quantity) { ?>
                <?php
                set_query_var('count_item', $count_item);
                get_template_part('template-parts/cards/card-quantity') ?>
            <?php } ?>
        <?php } ?>
    </div>
</div>