<?php
class Af_Social_List_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'list_social';
    }

    public function get_title() {
        return __('شبکه‌های اجتماعی', 'af-theme');
    }

    public function get_icon() {
        return 'eicon-share';
    }

    public function get_categories() {
        return ['af-footer']; 
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'social_section',
            [
                'label' => __('شبکه‌های اجتماعی', 'af-theme'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __('عنوان', 'af-theme'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'شبکه اجتماعی',
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __('لینک', 'af-theme'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => '#',
            ]
        );

        $repeater->add_control(
            'icon',
            [
                'label' => __('آیکون (ID در SVG Sprite)', 'af-theme'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => 'facebook',
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => __('شبکه‌ها', 'af-theme'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $items = $settings['items'];

        if (isset($items) && !empty($items)) {
            ?>
            <ul class="list-social-footer flex items-center justify-end gap-8 a-md:flex-wrap">
                <?php foreach ($items as $key => $item) : 
                    $title = isset($item['title']) ? $item['title'] : '';
                    $link  = isset($item['link']['url']) ? $item['link']['url'] : '#';
                    $icon  = isset($item['icon']) ? $item['icon'] : '';
                ?>
                    <li>
                        <a href="<?= esc_url($link) ?>" title="<?= esc_attr($title) ?>" class="<?= $key == 0 ? 'active' : '' ?>" target="_blank" rel="nofollow">
                            <svg class="fill-[#969fae] w-[18px] h-[18px]">
                                <use xlink:href="#<?= esc_attr($icon) ?>"></use>
                            </svg>
                            <span><?= esc_html($title) ?></span>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
            <?php
        }
    }
}
