<?php
global $shopi_options;
$cart_count = WC()->cart->get_cart_contents_count();
$shop_page_url = get_permalink(wc_get_page_id('shop'));
$header_type = $shopi_options['header_type'] ?? 'header_full';
$class_logo = 'max-h-[28px] object-contain w-full';
$class_logo_a = $header_type == 'header_full' ? 'mr-auto' : 'mx-auto';
$icon_id = $shopi_options['mega_menu_icon']['id'] ?? 0;
$menu_text = $shopi_options['mega_menu_text'] ?? 'دسته بندی ها';
?>
<header class="mb-9 a-lg:hidden">
        <div class="container 2xl pt-6 ">
                <div class="relative flex items-center">
                        <div class="grow -ml-[150px] relative z-10">
                                <div class="flex items-center pb-2">
                                        <a href="<?= get_permalink(get_option('woocommerce_myaccount_page_id')); ?>" class="text-[15px] text-[#232c38] font-bold ml-6 flex items-center gap-2 border-login-user login-user-action">
                                                <svg class="fill-[#192435] w-[16px] h-[20px]">
                                                        <use xlink:href="#user-icon">
                                                        </use>
                                                </svg>
                                                <?= is_user_logged_in() ? 'حساب کاربری' : 'وارد شوید' ?>
                                        </a>
                                        <?php if (isset($shopi_options['list_link_header']['redux_repeater_data']) && !empty($shopi_options['list_link_header']['redux_repeater_data'])) {  ?>
                                                <ul class="flex items-center gap-5 list-link-top">
                                                        <?php
                                                        foreach ($shopi_options['list_link_header']['redux_repeater_data'] as $key =>  $link) {
                                                                $link = $shopi_options['list_link_header'];
                                                                $link_text   = isset($link['list_link_header_text'][$key]) ? $link['list_link_header_text'][$key] : '';
                                                                $link_url    = isset($link['list_link_header_url'][$key]) ? $link['list_link_header_url'][$key] : '#';
                                                                $link_target = isset($link['list_link_header_target'][$key]) ? $link['list_link_header_target'][$key] : '_self';
                                                                $link_rel    = isset($link['list_link_header_rel'][$key]) ? $link['list_link_header_rel'][$key] : '';
                                                                $link_flow   = isset($link['list_link_header_flow'][$key]) ? $link['list_link_header_flow'][$key] : '';
                                                        ?>
                                                                <li>
                                                                        <a class="text-[12px] text-[#969fae] font-bold" href="<?= esc_url($link_url); ?>" target="<?= esc_attr($link_target); ?>" rel="<?= esc_attr($link_rel); ?>" flow="<?= esc_attr($link_flow); ?>">
                                                                                <?= esc_html($link_text); ?>
                                                                        </a>
                                                                </li>
                                                        <?php
                                                        } ?>
                                                </ul>
                                        <?php } ?>

                                        <div class="flex items-center gap-3 mr-auto">
                                                <?php if (isset($shopi_options['call_title_header']) && !empty($shopi_options['call_title_header'])) { ?>
                                                        <span class="text-[12px] text-[#969fae] font-bold a-xl:hidden"><?= @esc_attr($shopi_options['call_title_header']) ?></span>
                                                <?php } ?>
                                                <?php if (isset($shopi_options['call_text_header']) && !empty($shopi_options['call_text_header'])) { ?>
                                                        <a href="<?= @esc_attr($shopi_options['call_link_header']) ?>" rel="noreferrer nofollow noopener" class="text-[18px] text-primary_text font-bold">
                                                                <?= title_generator($shopi_options['call_text_header'], 'text-[13px] text-[#9fa0a3] font-bold') ?>
                                                        </a>
                                                <?php } ?>
                                        </div>
                                </div>
                                <div class="flex items-center gap-3 mt-4">
                                        <div class="relative box-menu">
                                                <div class="drop-shadow-menu text-[16px] text-[#ffffff] font-bold bg-primary_bg rounded-[20px] flex items-center gap-3 px-7 py-4 cursor-pointer">
                                                        <?php if ($icon_id) : ?>
                                                                <?= wp_get_attachment_image($icon_id, 'full'); ?>
                                                        <?php else : ?>
                                                                <svg class="fill-white w-[15px] h-[13px]">
                                                                <use xlink:href="#menu-icon"></use>
                                                                </svg>
                                                        <?php endif; ?>
                                                        <?php echo esc_html($menu_text); ?>
                                                </div>
                                                <?php get_template_part('template-parts/mega-menu') ?>
                                        </div>
                                        <div class="relative box-cart">
                                                <a href="<?= @wc_get_cart_url() ?>" class="text-[16px] text-[#232c38] font-bold border border-[#e3e7ed] flex items-center gap-[10px] rounded-[20px] p-3 pr-[22px] min-w-[172px] cursor-pointer button-open-mini-cart">
                                                        <svg class="fill-[#232c38] w-5 h-5">
                                                                <use xlink:href="#cart-icon">
                                                                </use>
                                                        </svg>
                                                        سبدخرید
                                                        <span class="count-items-cart text-[19px] text-[#ffffff] font-bold bg-primary_bg rounded-[15px] h-[31px] min-w-[31px] flex items-center justify-center mr-auto px-1">
                                                                <?= @$cart_count ?>
                                                        </span>
                                                </a>
                                                <div class="pt-3 absolute right-0 bottom-4 translate-y-full z-[99] min-w-[373px] max-w-[373px] box-mini-cart opacity-0 invisible transition-3s">
                                                        <div class="border border-[#dfe4ed] rounded-[20px] bg-white append-mini-cart">
                                                                <?php get_template_part('woocommerce/cart/mini-cart') ?>
                                                        </div>
                                                </div>
                                        </div>
                                        <div class="relative mr-auto box-search-ajax box-all-search">
                                                <form action="<?= $shop_page_url ?>" class="bg-[#f8f9fb] rounded-[20px] flex items-stretch min-w-[373px] form-search-ajax border border-transparent transition-3s lx:min-w-[280px]">
                                                        <input name="s" type="text" class="text-[13px] text-[#969fae] font-bold bg-transparent py-[17px] px-6 focus:outline-none grow input-search-ajax" placeholder="جستجوی محصول . . . ">
                                                        <i class="search-loading absolute left-12 top-1/2 w-5 h-5"></i>
                                                        <button type="submit" class="bg-transparent py-[17px] px-6">
                                                                <svg class="fill-[#b2b9c9] w-[15px] h-[15px]">
                                                                        <use xlink:href="#search-vip-icon">
                                                                        </use>
                                                                </svg>
                                                        </button>
                                                </form>
                                                <div class="pt-3 absolute left-0 right-0 bottom-4 translate-y-full z-[99] box-result-search-ajax opacity-0 invisible transition-3s">
                                                        <?php get_template_part('template-parts/search/box-search-ajax') ?>
                                                </div>
                                        </div>
                                        <?php if (!empty($shopi_options['title_link_vip_header']) && !empty($shopi_options['link_vip_header'])) { ?>
                                                <a href="<?= @$shopi_options['link_vip_header'] ?>" target="<?= @$shopi_options['target_link_vip_header'] ?>" class="flex items-center gap-3 mr-3">
                                                        <?php if (isset($shopi_options['pic_link_vip_header']['id']) && !empty($shopi_options['pic_link_vip_header']['id'])) { ?>
                                                                <?= @wp_get_attachment_image($shopi_options['pic_link_vip_header']['id'], 'full', false, ['class' => ' max-w-[27px] max-h-[27px] object-contain']) ?>
                                                        <?php } ?>
                                                        <div class="flex flex-col">
                                                                <?php if (isset($shopi_options['title_link_vip_header']) && !empty($shopi_options['title_link_vip_header'])) { ?>
                                                                        <span class="text-[16px] text-[#495666] font-bold"><?= @esc_attr($shopi_options['title_link_vip_header']) ?></span>
                                                                <?php } ?>
                                                                <?php if (isset($shopi_options['subtitle_link_vip_header']) && !empty($shopi_options['subtitle_link_vip_header'])) { ?>
                                                                        <span class="text-[13px] text-[#969fae]"><?= @esc_attr($shopi_options['subtitle_link_vip_header']) ?></span>
                                                                <?php } ?>
                                                        </div>
                                                </a>
                                        <?php } ?>
                                </div>
                        </div>
                        <span class="wave-header">
                                <?php if (isset($shopi_options['logo']['id']) && !empty($shopi_options['logo']['id'])) { ?>
                                        <a href="<?= home_url() ?>" class="mr-auto">
                                                <?= @wp_get_attachment_image($shopi_options['logo']['id'], 'full', false, ['class' => 'max-h-[80px] max-w-[150px] mt-[20px] object-contain']) ?>
                                        </a>
                                <?php } ?>
                        </span>
                </div>
        </div>
</header>
<header class="bg-white hidden a-lg:flex a-lg:flex-col header-responsive-shadow sticky top-0 z-[9999]  drop-shadow-menu-res mb-6">
        <div class="container 2xl m-auto ">
                <div class="inline-flex items-center justify-between w-full py-3 border-[#eef1f3] border-b">
                        <svg class="fill-[#1a2028] w-[21px] h-[18px] cursor-pointer open-menu-mobile">
                                <use xlink:href="#menu-icon">
                                </use>
                        </svg>
                        <?php if (isset($shopi_options['responsive_logo']['id']) && !empty($shopi_options['responsive_logo']['id'])) { ?>
                                <a href="<?= home_url() ?>" class="inline-block max-w-max w-max <?= $class_logo_a ?>">
                                        <?= @wp_get_attachment_image($shopi_options['responsive_logo']['id'], 'full', false, ['class' => $class_logo . " " . $class_logo_a]) ?>
                                </a>
                        <?php } ?>
                        <?php if ($header_type != 'header_full') { ?>
                                <a href="<?= @esc_attr($shopi_options['call_link_header']) ?>" rel="noreferrer nofollow noopener">
                                        <svg class="fill-[#1a2028] w-[22px] h-[22px] cursor-pointer">
                                                <use xlink:href="#call-vip-icon">
                                                </use>
                                        </svg>
                                </a>
                        <?php } ?>
                </div>
                <div class="flex items-center w-full">
                        <div class="relative grow box-search-ajax box-all-search <?= $header_type != 'header_full' ? 'has-before' : '' ?>">
                                <form action="<?= $shop_page_url ?>" class="flex items-center grow border-vip-user-res relative">
                                        <button type="submit">
                                                <svg class="fill-[#232c38] w-[15px] h-[15px]">
                                                        <use xlink:href="#search-vip-icon">
                                                        </use>
                                                </svg>
                                        </button>
                                        <i class="search-loading absolute left-1 top-1/2 w-4 h-4"></i>
                                        <input id="open-search-mobile" name="s" type="text" placeholder="جستجوی محصول .. " class="input-search-ajax grow text-[12px] text-[#232c38] font-bold px-2 py-3 focus:outline-none">
                                </form>
                                <div id="search-mobile" class="absolute left-0 -right-[15px] bottom-0 z-[99] box-result-search-ajax box-result-search-ajax-responsive transition-3s w-[100vw] overflow-hidden">
                                        <?php get_template_part('template-parts/search/box-search-ajax') ?>
                                </div>
                        </div>
                        <?php if ($header_type == 'header_full') { ?>
                                <span class="relative cursor-pointer py-3 px-3 border-vip-user-res" id="open-mini-cart-mobile">
                                        <span class="count-items-cart bg-primary_bg h-[12px] rounded-[3px] text-[13px] text-white font-bold px-[2px] absolute right-[18px] top-2 leading-[1] translate-x-full min-w-[10px] flex items-center justify-center">
                                                <?= @$cart_count ?>
                                        </span>
                                        <svg class="fill-[#232c38] w-[17px] h-[16px]">
                                                <use xlink:href="#cart-icon">
                                                </use>
                                        </svg>
                                </span>
                                <a href="<?= get_permalink(get_option('woocommerce_myaccount_page_id')); ?>" class="relative pr-3 inline-block py-3">
                                        <span class="relative">
                                                <svg class="fill-[#192435] w-[13px] h-[17px]">
                                                        <use xlink:href="#user-icon">
                                                        </use>
                                                </svg>
                                        </span>
                                </a>
                        <?php } ?>
                </div>
        </div>
</header>
<?php get_template_part('template-parts/menu-responsive'); ?>
