<?php
global $wp_query;
$user = wp_get_current_user();
$panel_url = wc_get_endpoint_url('comment');
$tab = [
    "product" => ["title" => "محصولات", "type" => 'product', 'link' => 'محصول'],
    "post" => ["title" => "مقالات", "type" => 'post', 'link' => 'مقاله'],
];
$status_select = esc_attr(get_status_tab("product", $tab));
$meta_fav = esc_attr($tab[$status_select]['type']);

$paged = $wp_query->query["comment"] ? intval($wp_query->query["comment"]) : 1;
$args = array(
    "post_type" => esc_attr($meta_fav),
    "user_id" => $user->ID,
    'count'         => false,
    'no_found_rows' => false,
    'number'        => 4,
    'paged' => $paged,
    'status'        => 'approve',
);

// The Query 
$comments_query = new WP_Comment_Query($args);
$comments = $comments_query->comments;
?>
<div class="border-b border-[#f2f4f7] flex items-center gap-12 a-md:gap-8">
    <span class="text-[17px] text-[#768699] font-bold pb-6 tab:text-[15px] tab:pb-4">نظرات من</span>
    <?php if (isset($tab) && !empty($tab)) { ?>
        <ul class="flex items-center gap-10 tab:gap-4 list-tab-panel">
            <?php foreach ($tab as $key => $value) { ?>
                <li class="">
                    <a class="text-[14px] text-[#97a0ae] font-bold pb-6 flex a-md:text-[13px] tab:pb-4 <?= ($status_select == $key) ? "active" : "" ?>" href="<?= $panel_url ?>?status=<?= $key ?>"><?= $value["title"] ?></a>
                </li>
            <?php } ?>
        </ul>
    <?php } ?>
</div>
<?php if (isset($comments) && !empty($comments)) { ?>
    <ul>
        <?php foreach ($comments as $key => $item) { ?>
            <li class="py-8 border-b border-[#f2f4f7] last:border-none last:pb-0 a-md:py-5 flex items-center gap-10 mb-4 flex-wrap a-md:gap-3 a-md:justify-between">
                <span class="text-[13px] text-[#969fae] font-bold">
                    <?= get_comment_date('Y F j l', $item); ?>
                </span>
                <span class="text-[13px] text-[#969fae] font-bold">برای محصول : <?= get_the_title($item->comment_post_ID) ?>
                    مدل</span>
                <div class="mr-auto flex items-center gap-3 a-md:order-5">
                    <span class="text-[14px] text-[#647281] font-bold"> <?= count_comment_like($item->comment_ID) ?></span>
                    <span class="text-[13px] text-[#969fae] font-bold">نفر موافق شما بودند</span>
                </div>
                <div class="text-[14px] text-[#495666] font-bold leading-[2.2] a-md:text-[13px] w-full text-justify">
                    <?= @esc_attr($item->comment_content) ?>
                </div>
            </li>
        <?php } ?>
    </ul>
    <div class="comment-pagination">
        <?php
        $args = array(
            'base' => esc_url($panel_url) . '%_%',
            'format' => '%#%',
            'total' => $comments_query->max_num_pages,
            'current' => $paged,
            'show_all' => false,
            'end_size' => 3,
            'mid_size' => 3,
            'prev_next' => true,
            'add_args' => false,
            'type' => '',
            'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
            'next_text' => is_rtl() ? '&larr;' : '&rarr;',
        );
        echo paginate_links($args);
        ?>
    </div>
<?php } else { ?>
    <div class="mt-6">
        <?php print_msg('هیچ کامنتی توسط شما ثبت نشده است') ?>
    </div>
<?php } ?>