<?php
if (!isset($args['search']) && empty($args['search']))
    return;
$search = $args['search'];


$args_product = [
    'post_type' => 'product',
    'post_status' => 'publish',
    'posts_per_page' => 5,
    'order' => 'DESC',
    'orderby' => 'date',
    's' => sanitize_text_field($search),
];
$query_product = new WP_Query($args_product);


$args_cat = array(
    'taxonomy' => array('product_cat'),
    'orderby' => 'name',
    'order' => 'ASC',
    'hide_empty' => false,
    'search' => sanitize_text_field($search),
    'number' => 8,
);
$query_category = new WP_Term_Query($args_cat);
?>
<?php if ($query_product->have_posts()) { ?>
    <div class="mb-10">
        <div class="flex items-center justify-between mb-5">
            <span class="text-[13px] text-[#969fae] font-bold">محصولات یافت
                شده</span>
            <a href="<?= wc_get_page_permalink('shop') . "?s=" . esc_attr($search) ?>" class="text-[13px] text-[#ffffff] font-bold bg-primary_bg rounded-[10px] px-2 pt-[2px]">
                مشاهده همه
            </a>
        </div>
        <div class="swiper swiper-product-search swiper-initialized swiper-horizontal swiper-rtl swiper-backface-hidden">
            <div class="swiper-wrapper" id="swiper-wrapper-a7e66d7597f3b589" aria-live="polite" style="transform: translate3d(0px, 0px, 0px);">
                <?php while ($query_product->have_posts()) {
                    $query_product->the_post();
                ?>
                    <div class="swiper-slide w-max">
                        <div class="border border-[#dfe4ed] rounded-[10px] px-[14px] pb-4 pt-3 min-w-[137px] max-w-[137px] flex flex-col gap-3">
                            <a href="<?php the_permalink() ?>">
                                <?php if (has_post_thumbnail()) {
                                    echo get_the_post_thumbnail(get_the_ID(), 'full', ['class' => 'min-h-[75px] max-h-[75px] object-contain m-auto']);
                                } else {
                                    echo wc_placeholder_img('full', ['class' => 'min-h-[75px] max-h-[75px] object-contain m-auto']);
                                } ?>
                            </a>
                            <a href="<?php the_permalink() ?>" class="text-[13px] text-[#232c38] font-bold line-clamp-2 leading-[1.6]">
                                <?php the_title() ?>
                            </a>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php
    wp_reset_postdata();
    wp_reset_query();
}
?>
<?php
if ($query_category->get_terms()) {
?>
    <ul class="flex flex-col gap-3">
        <?php foreach ($query_category->get_terms() as $term) { ?>
            <li>
                <a href="<?= get_term_link($term->term_id) ?>" class="text-[13px] text-[#232c38] font-bold flex items-center gap-4">
                    <svg class="fill-[#b2b9c9] w-[15px] h-[15px] ">
                        <use xlink:href="#search-vip-icon">
                        </use>
                    </svg>
                    <?= @esc_attr($term->name) ?>
                    <svg class="fill-[#969fae] w-[5px] h-[9px] mr-auto">
                        <use xlink:href="#arrow-left-wave-icon">
                        </use>
                    </svg>
                </a>
            </li>
        <?php } ?>
    </ul>
<?php } ?>