<?php
/* template name: تماس با ما */
global $shopi_options;
$list_link_router_contactus = $shopi_options['list_link_router_contactus'];
$error = [];
if (isset($_POST["submit_report"]) && isset($_POST["token"]) &&  get_csrf_token() == $_POST["token"]) {
    $full_name = $_POST['full_name'] ? sanitize_text_field($_POST['full_name']) :  '';
    $mobile = $_POST['mobile'] ? sanitize_text_field($_POST['mobile']) : '';
    $message = $_POST['message'] ? sanitize_text_field($_POST['message']) : '';

    //full_name
    if (!empty($full_name)) {
        if (!(mb_strlen($full_name) >= 3 && mb_strlen($full_name) < 500)) {
            $error[] = "نام حداقل باید 2 کاراکتر و حداکثر 500 کاراکتر باشد";
        }
    } else {
        $error[] = "پر کردن فیلد نام ضروری می باشد";
    }

    //mobile
    if (!empty($mobile)) {
        if (!validatePhoneNumber($mobile)) {
            $error[] = "فرمت شماره موبایل اشتباه است";
        }
    } else {
        $error[] = "پر کردن فیلد شماره موبایل ضروری می باشد";
    }

    //message
    if (!empty($message)) {
        if (!(mb_strlen($message) > 10 && mb_strlen($message) < 500)) {
            $error[] = "پیام حداقل باید 10 کاراکتر و حداکثر 500 کاراکتر باشد ";
        }
    } else {
        $error[] = "پر کردن فیلد پیام ضروری می باشد";
    }


    if (empty($error)) {
        $result = send_contactus_email_to_admin([
            'full_name' =>  $full_name,
            'mobile' => $mobile,
            'message' => $message,
        ]);

        if (!is_wp_error($result)) {
            $success = "با موفقیت ارسال شد ، کارشناسان به زودی با شما تماس خواهند گرفت";
        }

        regenerate_csrf_token();
    }
}
?>
<?php get_header(); ?>
<div class="container 2xl mb-6">
    <div class="flex items-stretch gap-12 a-sxl:gap-6 a-lg:flex-wrap tab:flex-col">
        <div class="rounded-[7px] relative overflow-hidden flex-1 a-lg:order-2">
            <div id="mapcontact" class="w-full h-full min-h-[423px] tab:min-h-[300px] z-[1]" data-pic="<?= THEME_URL . "/assets/img/map-icon.webp" ?>" data-lat="<?= @esc_attr($shopi_options['lat_address_contactus']) ?>" data-lng="<?= @esc_attr($shopi_options['lng_address_contactus']) ?>"></div>
            <?php if (isset($list_link_router_contactus['redux_repeater_data']) && !empty($list_link_router_contactus['redux_repeater_data'])) {  ?>
                <div class="h-[50px] flex items-stretch gap-2 absolute right-6 bottom-4 z-[999] list-direction-map tab:flex-wrap tab:h-max tab:justify-center">
                    <?php
                    foreach ($list_link_router_contactus['redux_repeater_data'] as $key =>  $item) {
                        $item = $list_link_router_contactus;
                        $link   = isset($item['link'][$key]) && !empty($item['link'][$key]) ? $item['link'][$key] : '#';
                        $pic    = isset($item['pic'][$key]) ? $item['pic'][$key] : '#';
                    ?>
                        <a href="<?= @$link ?>" target="_blank" rel="noreferrer nofollow noopener" class="flex items-center justify-center p-2 bg-white rounded-xl w-[56px]">
                            <?= @wp_get_attachment_image($pic['id'], 'full', false, ['class' => 'w-7 h-7 object-contain']) ?>
                        </a>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
        <div class="min-w-[510px] max-w-[510px] flex flex-col a-sxl:min-w-[400px] a-sxl:max-w-[400px] a-lg:min-w-full a-lg:max-w-full a-lg:order-1">
            <?= @wp_get_attachment_image($shopi_options['pic_contactus']['id'], 'full', false, ['class' => 'm-auto mb-6']) ?>
            <div class="mt-auto">
                <?php if (isset($shopi_options['title_info_contactus']) && !empty($shopi_options['title_info_contactus'])) { ?>
                    <span class='title-head text-[14px] text-[#394454] font-bold title-line pb-7'>
                        <?= @esc_attr($shopi_options['title_info_contactus']) ?>
                        <span class="line"></span>
                    </span>
                <?php } ?>
                <ul class="flex flex-col gap-5 tab:gap-3">
                    <?php if (!empty($shopi_options['title_map_call_access_contactus']) && !empty($shopi_options['link_map_access_contactus'])) { ?>
                        <li class="flex items-center gap-2">
                            <?php if (isset($shopi_options['title_map_access_contactus']) && !empty($shopi_options['title_map_access_contactus'])) { ?>
                                <span class='text-[14px] text-[#394454] font-bold flex items-end gap-3 grow'>
                                    <svg class='fill-[#495666] w-[16px] h-[20px]'>
                                        <use xlink:href='#map-icon'>
                                    </svg>
                                    <?= @esc_attr($shopi_options['title_map_access_contactus']) ?>
                                </span>
                            <?php } ?>
                            <a href="<?= @esc_attr($shopi_options['link_map_access_contactus']) ?>" rel="nofollow" class='text-[14px] text-[#394454] font-bold line-clamp-1'>
                                <?= @esc_attr($shopi_options['title_map_call_access_contactus']) ?>
                            </a>
                        </li>
                    <?php } ?>
                    <?php if (!empty($shopi_options['title_email_call_access_contactus']) && !empty($shopi_options['link_email_access_contactus'])) { ?>
                        <li class="flex items-center gap-2">
                            <?php if (isset($shopi_options['title_email_access_contactus']) && !empty($shopi_options['title_email_access_contactus'])) { ?>
                                <span class='text-[14px] text-[#394454] font-bold flex items-end gap-3 grow'>
                                    <svg class='fill-[#495666] w-[15px] h-[15px]'>
                                        <use xlink:href='#comment'>
                                    </svg>
                                    <?= @esc_attr($shopi_options['title_email_access_contactus']) ?>
                                </span>
                            <?php } ?>
                            <a href="<?= @esc_attr($shopi_options['link_email_access_contactus']) ?>" rel="nofollow" class='text-[13px] text-[#545f70] font-bold line-clamp-1'>
                                <?= @esc_attr($shopi_options['title_email_call_access_contactus']) ?>
                            </a>
                        </li>
                    <?php } ?>
                    <?php if (!empty($shopi_options['title_link_call_access_contactus']) && !empty($shopi_options['link_call_access_contactus'])) { ?>
                        <li class="flex items-center gap-2 leading-[1]">
                            <?php if (isset($shopi_options['title_call_access_contactus']) && !empty($shopi_options['title_call_access_contactus'])) { ?>
                                <span class='text-[14px] text-[#394454] font-bold flex items-end gap-3 grow'>
                                    <svg class='fill-[#495666] w-[17px] h-[17px]'>
                                        <use xlink:href='#call-icon'>
                                    </svg>
                                    <?= @esc_attr($shopi_options['title_call_access_contactus']) ?>
                                </span>
                            <?php } ?>
                            <a href="<?= $shopi_options['link_call_access_contactus'] ? @esc_attr($shopi_options['link_call_access_contactus']) : "#" ?>" rel="nofollow" class='text-[30px] text-primary_text font-bold flex flex-row-reverse items-center gap-1 leading-[1]'>
                                <?= title_generator($shopi_options['title_link_call_access_contactus'], 'text-[23px] text-[#394454] font-bold') ?>
                            </a>
                        </li>
                    <?php } ?>
                    <?php if (!empty($shopi_options['title_link_way_communication_access_contactus']) && !empty($shopi_options['link_way_communication_access_contactus'])) { ?>
                        <li class="flex items-center gap-2">
                            <?php if (isset($shopi_options['title_way_communication_access_contactus']) && !empty($shopi_options['title_way_communication_access_contactus'])) { ?>
                                <span class='text-[14px] text-[#394454] font-bold flex items-end gap-3 grow'>
                                    <svg class='fill-[#495666] w-[16px] h-[16px]'>
                                        <use xlink:href='#support-icon'>
                                    </svg>
                                    <?= @esc_attr($shopi_options['title_way_communication_access_contactus']) ?>
                                </span>
                            <?php } ?>
                            <a href="<?= $shopi_options['link_way_communication_access_contactus'] ? $shopi_options['link_way_communication_access_contactus'] : "#" ?>" class='text-[14px] text-[#394454] font-bold'><?= @esc_attr($shopi_options['title_link_way_communication_access_contactus']) ?></a>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
        <div class="flex-1 a-lg:order-3" id="contact-form">
            <?php if (isset($error) && !empty($error)) { ?>
                <?php foreach ($error as $key => $value) {
                    print_msg($value);
                ?>
            <?php }
            } ?>
            <div class="wpcf7">
                <form action="#contact-form" method="post" class="wpcf7-form init" aria-label="فرم تماس" novalidate="novalidate" data-status="init">
                    <p><label> نام شما (الزامی)<br>
                            <span class="" data-name="your-name">
                                <input size="40" class="" aria-required="true" aria-invalid="false" value="" type="text" name="full_name">
                            </span> </label>
                    </p>
                    <p><label> شماره همراه (الزامی)<br>
                            <span class="" data-name="your-email">
                                <input size="40" class="" aria-required="true" aria-invalid="false" value="" name="mobile">
                            </span>
                        </label>
                    </p>
                    <p><label> پیام شما<br>
                            <span class="" data-name="your-message"><textarea cols="40" rows="10" class="" name="message"></textarea></span> </label>
                    </p>
                    <p><input name="submit_report" class="cursor-pointer" type="submit" value="ارسال"><span class="wpcf7-spinner"></span>
                    </p>
                    <?= csrf_field() ?>
                    <div class="wpcf7-response-output" aria-hidden="true">
                        <?php if (isset($success) && !empty($success)) { ?>
                            <?= @esc_attr($success) ?>
                        <?php } ?>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>