<?php
/* template name: سوالات متداول  */
global $shopi_options;
$paged = get_query_var('paged') ? get_query_var('paged') : 1;
$search = get_query_var('search');
$term = get_queried_object();
$title_main = $term->post_title;
$args = array(
	'post_type' => 'faq',
	'paged' => $paged,
	'posts_per_page' => 8,
	'post_status ' => 'publish',
);
if (isset($search) && !empty($search)) {
	$args["s"] = esc_attr($search);
	$title_main = "جست و جو شده برای : $search : ";
}
if (isset($term->term_id) && !empty($term->term_id)) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => $term->taxonomy,
			'field' => 'term_id',
			'terms' => $term->term_id,
		),
	);
	$title_main = $term->name;
}
$list_posts = new WP_Query($args);
$has_pagination = $list_posts->found_posts > $list_posts->query['posts_per_page'];
?>
<?php get_header(); ?>
<div class="container 2xl m-auto">
	<div class="flex items-center gap-16 mb-11 a-md:mb-6 a-lg:gap-3 a-lg:flex-wrap a-lg:justify-between tab:mb-3">
		<div class="breadcrumbs scrollbar-hide  flex items-center text-[13px] text-[#969fae] font-bold fill-[#cbd0da] grow a-lg:w-full">
			<nav class="woocommerce-breadcrumb" aria-label="Breadcrumb">
				<?= woocommerce_breadcrumb() ?>
			</nav>
		</div>
		<form action="" class="flex items-center tab:w-full tab:border tab:border-[#eee] tab:rounded-[7px] tab:overflow-hidden">
			<input name="search" value="<?= @esc_attr($search) ?>" class="text-[13px] text-[#b1bcca] font-bold bg-transparent focus:outline-none max-w-[60px] hover:max-w-[100px] transition-3s tab:max-w-full tab:grow tab:p-3 tab:hover:max-w-full" type="text" placeholder="جستجو">
			<button type="submit" class="tab:p-3">
				<svg class="fill-[#b8c1d0] w-[14px] h-[14px]">
					<use xlink:href="#search-vip-icon">
					</use>
				</svg>
			</button>
		</form>
	</div>
	<div class="flex items-start gap-4 ml:flex-col ml:gap-0">
		<div class="top-1 sticky">
			<div class="filter cursor-pointer fixed left-[15px] bottom-5 bg-[#f73148] rounded-[7px] w-10 h-10 hidden items-center justify-center shadow-[-3px_3px_6px_#0219591a] a-md:flex z-[99]" id="filter">
				<div class="button-filter flex flex-col items-center">
					<span class="icn inline-block">
						<svg width="25" height="25" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M1.5 2.64286C1.5 3.01057 1.5 4.70931 1.5 5.87377C1.5 6.57346 1.86565 7.22137 2.46419 7.58375L4.90316 9.06035C5.42264 9.37486 5.77109 9.90835 5.85028 10.5104L6.22751 13.3786C6.30587 13.9744 6.88821 14.367 7.46988 14.2162L9.26154 13.7518C9.67371 13.645 9.97303 13.2889 10.0074 12.8645L10.1925 10.5776C10.2443 9.93727 10.6006 9.3608 11.1501 9.02808L13.5358 7.58375C14.1344 7.22137 14.5 6.57329 14.5 5.8736C14.5 4.83391 14.5 3.34771 14.5 2.64286M1.5 2.64286C1.5 3.7888 5 4.5 8 4.5C11 4.5 14.5 3.21737 14.5 2.64286M1.5 2.64286C1.5 2.07143 3.86364 1 8 1C12.143 1 14.5 2.07143 14.5 2.64286" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
							</path>
							<path d="M7.9668 3.78571C3.85099 3.78572 1.5 3.78573 1.5 2.64286C1.5 2.07143 3.86364 1.5 8 1.5C12.143 1.5 14.5 2.07143 14.5 2.64286C14.5 3.21737 12.1364 3.78571 8 3.78571H7.9668Z" fill="#fff" stroke="#fff" stroke-width="1.75" stroke-linecap="round" stroke-linejoin="round">
							</path>
						</svg>
					</span>
				</div>
				<!-- .button-filter -->
			</div>
			<div id="sidebar-archive" class="sidebar-archive-blog faq-fillter border border-[#f2f4f7] rounded-[9px] min-w-[279px] max-w-[279px] py-8">
				<?php if (isset($shopi_options['list_link_side_archive_faq']['redux_repeater_data']) && !empty($shopi_options['list_link_side_archive_faq']['redux_repeater_data'])) {  ?>
					<ul class="list-cat-faq flex flex-col gap-[13px]">
						<?php
						foreach ($shopi_options['list_link_side_archive_faq']['redux_repeater_data'] as $key =>  $item) {
							$item = $shopi_options['list_link_side_archive_faq'];
							$title   = isset($item['title'][$key]) ? $item['title'][$key] : '';
							$pic   = isset($item['pic'][$key]) ? $item['pic'][$key] : '';
							$link   = isset($item['link'][$key]) && !empty($item['link'][$key]) ? $item['link'][$key] : '#';
							$target   = isset($item['target'][$key]) ? $item['target'][$key] : '';
							$rel   = isset($item['rel'][$key]) ? $item['rel'][$key] : '';
						?>
							<li><a href="<?= esc_url($link); ?>" target="<?= esc_attr($target); ?>" rel="<?= esc_attr($rel); ?>" class='item text-[13px] text-[#7f8995] font-bold flex items-center gap-5 px-6 py-1 <?= compare_urls($link) ? 'active' : '' ?>'>
									<?= wp_get_attachment_image($pic['id'], 'full', false, ['class' => 'w-4 h-4 object-contain']) ?>
									<?= @esc_attr($title) ?>
								</a></li>
						<?php } ?>
					</ul>
				<?php } ?>
			</div>
		</div>
		<div class="grow ml:w-full">
			<div class="flex flex-col gap-5 tab:gap-2">
				<?php if ($list_posts->have_posts()) {
					$i = 1; ?>
					<?php while ($list_posts->have_posts()) {
						$list_posts->the_post();
					?>
						<div class="item-accordion item-faq border border-[#f2f4f7] rounded-[9px] px-8 tab:px-4 <?= $i != 1 ? '' : 'active' ?> ">
							<div class="head flex items-center gap-5 cursor-pointer py-7 tab:py-5">
								<span class="min-w-[28px] min-h-[17px] rounded-[9px] bg-primary_bg flex items-center justify-center box-showing transition-3s">
									<svg class='fill-white w-[10px] h-[10px] transition-3s'>
										<use xlink:href='#plus-faq-icon'>
									</svg>
								</span>
								<span class='text-[15px] text-[#495666] font-bold line-clamp-1 tab:text-[14px] tab:line-clamp-2'>
									<?php the_title() ?>
								</span>
							</div>
							<div class="content mb-8 <?= $i != 1 ? 'hidden' : '' ?>">
								<div class='text-[14px] text-[#29333f] font-bold leading-[2.5] text-justify mb-11 tab:mb-4 tab:leading-[1.8] tab:text-[13px]'>
									<?php the_content() ?>
								</div>
								<div class="flex items-center gap-8 LikePost <?= has_like_post(get_the_ID(), 'like') ? 'active' : '' ?>" data-id="<?php the_ID() ?>" data-type="like">
									<span class='text-[15px] text-[#647281] font-bold flex items-center gap-2 cursor-pointer'>
										<svg class='fill-secondary_fill w-[14px] h-[14px]'>
											<use xlink:href='#like-icon'>
										</svg>
										بله
										<span class="number flex items-center text-[15px] text-[#bdcadc] font-normal">
											[
											<span class="inline-block text-[15px] text-[#0c2d5b] mx-[5px] font-bold count">
												<?= @count_post_like(get_the_ID()) ?> </span>
											]
										</span>
									</span>

									<span class='text-[14px] text-[#969fae] font-bold'>آیا این پرسش و پاسخ برای شما مفید بود
										؟</span>
								</div>
							</div>
						</div>
					<?php $i++;
					} ?>
					<?php if ($has_pagination) { ?>
						<?= custom_pagination($list_posts) ?>
					<?php } ?>
				<?php } else { ?>
					<?= print_msg('نتیجه ای یافت نشد') ?>
				<?php } ?>
			</div>
		</div>
	</div>
</div>
<?php get_footer() ?>