<?php
/* template name: report */
get_template_part('template-parts/headers/header-head');
global $shopi_options;
$error = [];
if (isset($_POST["submit_report"]) && isset($_POST["token"]) &&  get_csrf_token() == $_POST["token"]) {
	$full_name = $_POST['full_name'] ? sanitize_text_field($_POST['full_name']) :  '';
	$mobile = $_POST['mobile'] ? sanitize_text_field($_POST['mobile']) : '';
	$message = $_POST['message'] ? sanitize_text_field($_POST['message']) : '';

	//full_name
	if (!empty($full_name)) {
		if (!(mb_strlen($full_name) >= 3 && mb_strlen($full_name) < 500)) {
			$error[] = "نام حداقل باید 2 کاراکتر و حداکثر 500 کاراکتر باشد";
		}
	} else {
		$error[] = "پر کردن فیلد نام ضروری می باشد";
	}

	//mobile
	if (!empty($mobile)) {
		if (!validatePhoneNumber($mobile)) {
			$error[] = "فرمت شماره موبایل اشتباه است";
		}
	} else {
		$error[] = "پر کردن فیلد شماره موبایل ضروری می باشد";
	}

	//message
	if (!empty($message)) {
		if (!(mb_strlen($message) > 10 && mb_strlen($message) < 500)) {
			$error[] = "پیام حداقل باید 10 کاراکتر و حداکثر 500 کاراکتر باشد ";
		}
	} else {
		$error[] = "پر کردن فیلد پیام ضروری می باشد";
	}


	if (empty($error)) {
		$result = send_report_email_to_admin([
			'full_name' =>  $full_name,
			'mobile' => $mobile,
			'message' => $message,
			'referrer_url' => sanitize_text_field($_POST['referrer_url'])
		]);

		if (!is_wp_error($result)) {
			$success = "با موفقیت ارسال شد ، سپاس از همراهی شما";
		}

		regenerate_csrf_token();
	}
}
?>
<div class="min-h-[100dvh] bg-[#ee384e]" style="background: <?= @esc_attr($shopi_options['color_back_report_page']) ?> ;">
	<div class="container 2xl min-h-[100dvh] flex items-center justify-center">
		<div class="bg-white rounded-[10px] min-w-[570px] max-w-[570px] px-10 py-12 my-4 tab:min-w-full tab:max-w-full tab:px-4 tab:py-6">
			<div class="flex items-center justify-between mb-9 tab:mb-6">
				<div class="flex flex-col gap-1">
					<?php if (isset($shopi_options['title_report_page']) && !empty($shopi_options['title_report_page'])) { ?>
						<span class="text-[18px] text-[#495666] font-bold tab:text-[17px]">
							<?= @esc_attr($shopi_options['title_report_page']) ?>
						</span>
					<?php } ?>
					<?php if (isset($shopi_options['subtitle_report_page']) && !empty($shopi_options['subtitle_report_page'])) { ?>
						<span class="text-[15px] text-[#495666] tab:text-[14px]">
							<?= @esc_attr($shopi_options['subtitle_report_page']) ?>
						</span>
					<?php } ?>
				</div>
				<?php if (isset($shopi_options['logo_report_page']['id']) && !empty($shopi_options['logo_report_page']['id'])) { ?>
					<a href="<?= home_url() ?>">
						<?= @wp_get_attachment_image($shopi_options['logo_report_page']['id'], 'full', false, ['class' => 'max-h-12 object-contain']) ?>
					</a>
				<?php } ?>
			</div>
			<?php if (isset($shopi_options['description_report_page']) && !empty($shopi_options['description_report_page'])) { ?>
				<div class='text-[14px] text-[#495666] font-bold leading-[2] mb-9 tab:text-[13px] tab:mb-4 text-justify'>
					<?= @esc_attr($shopi_options['description_report_page']) ?>
				</div>
			<?php } ?>
			<?php if (isset($error) && !empty($error)) { ?>
				<?php foreach ($error as $key => $value) {
					print_msg($value);
				?>
			<?php }
			} ?>
			<?php if (isset($success) && !empty($success)) { ?>
				<div class="alert-wrap w-full mr-auto text-center text-[15px] text-white font-bold mb-3 h-[52px] leading-[52px] rounded-[9px] bg-[#3effb0]">
					<?= @esc_attr($success) ?>
				</div>
			<?php } ?>
			<form method="post" action="" class="flex flex-col gap-2">
				<div class="flex items-stretch gap-4">
					<input name="full_name" type="text" placeholder="نام" class="border border-[#e7e7ee] rounded-[10px] text-[13px] text-[#808b98] font-bold px-6 py-[15px] w-full focus:outline-none">
					<button name="submit_report" class='text-[15px] text-[#fff] font-bold bg-primary_bg rounded-[10px] px-8'>
						گزارش
					</button>
				</div>
				<input name="mobile" type="text" placeholder="شماره تماس" class="border border-[#e7e7ee] rounded-[10px] text-[13px] text-[#808b98] font-bold px-6 py-[15px] w-full focus:outline-none">
				<textarea name="message" type="text" placeholder="مشکل را بنویسید" class="min-h-28 border border-[#e7e7ee] rounded-[10px] text-[13px] text-[#808b98] font-bold px-6 py-[15px] w-full focus:outline-none"></textarea>
				<input name="referrer_url" type="hidden" value="<?= @esc_attr($_SERVER['HTTP_REFERER']) ?>">
				<?= csrf_field() ?>
			</form>
		</div>

	</div>
</div>
<?php
get_template_part('template-parts/footers/footer-foot');
?>