<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

defined('ABSPATH') || exit;
global $shopi_options;
$current_term = get_queried_object();
if ($shopi_options['show_subcategories_archive'] !== '1') {
	if (isset($current_term->taxonomy) && !empty($current_term->taxonomy)) {
		$args = array(
			'taxonomy'   => $current_term->taxonomy,
			'parent'     => $current_term->term_id,
			'hide_empty' => false,
			'number'     => $shopi_options['subcategory_count_archive'] ?? 6,
		);
		$categories = get_terms($args);
	}
} else {
	$categories = $shopi_options['list_link_top_archive_product']['redux_repeater_data'];
}
?>
<?php get_header('shop'); ?>
<div class="container 2xl m-auto">
	<div class="flex items-center gap-16 mb-11 a-md:mb-6 a-lg:gap-3 a-lg:flex-wrap a-lg:justify-between tab:mb-3">
		<div class="breadcrumbs scrollbar-hide  flex items-center text-[13px] text-[#969fae] font-bold fill-[#cbd0da] grow a-lg:w-full">
			<nav class="woocommerce-breadcrumb" aria-label="Breadcrumb">
				<?= woocommerce_breadcrumb() ?>
			</nav>
		</div>
		<div class="tab-wrap flex items-center">
			<?= woocommerce_catalog_ordering() ?>
		</div>
		<form action="" class="flex items-center tab:w-full tab:border tab:border-[#eee] tab:rounded-[7px] tab:overflow-hidden">
			<input name="s" value="<?= isset($_GET['s']) && !empty($_GET['s']) ? esc_attr($_GET['s']) : '' ?>" class='text-[13px] text-[#b1bcca] font-bold bg-transparent focus:outline-none max-w-[60px] hover:max-w-[100px] transition-3s tab:max-w-full tab:grow tab:p-3 tab:hover:max-w-full' type="text" placeholder="جستجو">
			<button type="submit" class="tab:p-3">
				<svg class='fill-[#b8c1d0] w-[14px] h-[14px]'>
					<use xlink:href='#search-vip-icon'>
				</svg>
			</button>
		</form>
	</div>
	<div class="flex gap-5 a-md:flex-col a-md:gap-0">
		<div class="min-w-[279px] max-w-[279px]">
			<div class=" filter cursor-pointer fixed left-[15px] bottom-5 bg-[#f73148] rounded-[7px] w-10 h-10  hidden items-center justify-center shadow-[-3px_3px_6px_#0219591a] a-md:flex z-[99]" id="filter">
				<span class="count-items-fillter counter-cart text-[14px] text-black font-bold rounded-[6px] h-4 min-w-[16px] bg-[#fff] inline-flex items-center justify-center absolute -top-1 right-2 translate-x-full leading-[1] pt-[2px] ">
					0 </span>
				<div class="button-filter flex flex-col items-center text-white text-[15px] font-bold">
					<?php if(isset($shopi_options['filter_text_instead_icon']) && !empty($shopi_options['filter_text_instead_icon'])){ ?>
						فیلتر
					<?php }else{ ?>
						<span class="icn inline-block">
							<svg width="25" height="25" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M1.5 2.64286C1.5 3.01057 1.5 4.70931 1.5 5.87377C1.5 6.57346 1.86565 7.22137 2.46419 7.58375L4.90316 9.06035C5.42264 9.37486 5.77109 9.90835 5.85028 10.5104L6.22751 13.3786C6.30587 13.9744 6.88821 14.367 7.46988 14.2162L9.26154 13.7518C9.67371 13.645 9.97303 13.2889 10.0074 12.8645L10.1925 10.5776C10.2443 9.93727 10.6006 9.3608 11.1501 9.02808L13.5358 7.58375C14.1344 7.22137 14.5 6.57329 14.5 5.8736C14.5 4.83391 14.5 3.34771 14.5 2.64286M1.5 2.64286C1.5 3.7888 5 4.5 8 4.5C11 4.5 14.5 3.21737 14.5 2.64286M1.5 2.64286C1.5 2.07143 3.86364 1 8 1C12.143 1 14.5 2.07143 14.5 2.64286" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
								</path>
								<path d="M7.9668 3.78571C3.85099 3.78572 1.5 3.78573 1.5 2.64286C1.5 2.07143 3.86364 1.5 8 1.5C12.143 1.5 14.5 2.07143 14.5 2.64286C14.5 3.21737 12.1364 3.78571 8 3.78571H7.9668Z" fill="#fff" stroke="#fff" stroke-width="1.75" stroke-linecap="round" stroke-linejoin="round">
								</path>
							</svg>
						</span>
					<?php } ?>
				</div>
				<!-- .button-filter -->
			</div>
			<aside id="sidebar-archive" class="sidebar-archive top-2 sticky flex flex-col">
				<?php
				/**
				 * Hook: woocommerce_sidebar.
				 *
				 * @hooked woocommerce_get_sidebar - 10
				 */
				// do_action('woocommerce_sidebar');
				dynamic_sidebar('sidebar_shop');
				?>
			</aside>
		</div>
		<div class="grow overflow-hidden">
			<?php if (isset($categories) && !empty($categories)) {  ?>
				<div class="swiper-list-cat swiper-list-cat-archive swiper pb-7 a-md:pb-3">
					<div class="swiper-wrapper">
						<?php
						foreach ($categories as $key =>  $item) {
							if (isset($item->term_id)) {
								$title   = $item->name;
								$pic = get_term_meta($item->term_id, 'thumbnail_id', true);
								$link   = get_term_link($item);
								$target   = '_blank';
								$rel = '';
								$subtitle = '';
							} else {
								$item = $shopi_options['list_link_top_archive_product'];
								$title   = isset($item['title'][$key]) ? $item['title'][$key] : '';
								$subtitle   = isset($item['subtitle'][$key]) ? $item['subtitle'][$key] : '';
								$pic   = isset($item['pic'][$key]) ? $item['pic'][$key]['id'] : '';
								$link   = isset($item['link'][$key]) && !empty($item['link'][$key]) ? $item['link'][$key] : '#';
								$target   = isset($item['target'][$key]) ? $item['target'][$key] : '';
								$rel   = isset($item['rel'][$key]) ? $item['rel'][$key] : '';
							}
						?>
							<div class="swiper-slide w-max !overflow-visible">
								<a href="<?= esc_url($link); ?>" target="<?= esc_attr($target); ?>" rel="<?= esc_attr($rel); ?>" class="item flex items-center gap-6 border border-[#f2f4f7] rounded-[9px] bg-white px-6 py-4 min-w-[250px] cursor-pointer a-md:p-3">
									<?= wp_get_attachment_image($pic, 'full', false, ['class' => '!max-w-[60px] max-h-[60px] object-contain pic transition-3s']) ?>
									<span class='flex flex-col gap-1 grow'>
										<?php if (isset($title) && !empty($title)) { ?>
											<span class="text-[15px] text-[#495666] font-bold line-clamp-1 title transition-3s">
												<?= @esc_attr($title) ?>
											</span>
										<?php } ?>
										<?php if (isset($title) && !empty($title)) { ?>
											<span class='text-[13px] text-[#969fae] line-clamp-1'><?= @esc_attr($subtitle) ?></span>
										<?php } ?>
									</span>
									<svg class="fill-[#969fae] w-[5px] h-[9px] icon-cat transition-3s">
										<use xlink:href="#arrow-left-wave-icon">
										</use>
									</svg>
								</a>
							</div>
						<?php } ?>
					</div>
				</div>
			<?php } ?>
			<?php if (woocommerce_product_loop()) { ?>
				<?php
				/**
				 * Hook: woocommerce_before_shop_loop.
				 *
				 * @hooked woocommerce_output_all_notices - 10
				 * @hooked woocommerce_result_count - 20
				 * @hooked woocommerce_catalog_ordering - 30
				 */
				remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
				remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
				remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
				do_action('woocommerce_before_shop_loop');
				?>
				<?php woocommerce_product_loop_start();  ?>
				<ul class="list-product-archive border border-[#f2f4f7] rounded-[9px] grid grid-cols-4 overflow-hidden mb-9 lx:grid-cols-3 ml:grid-cols-2 a-sm:mb-4 <?= $shopi_options['product_two_columns_archive'] ? 'col-2-archive' : 'tab:grid-cols-1';?>">
					<?php if (wc_get_loop_prop('total')) {  ?>
						<?php
						while (have_posts()) {
							the_post();
						?>
							<?php wc_get_template_part('content', 'product'); ?>
						<?php } ?>
					<?php } ?>
				</ul>
				<?php woocommerce_product_loop_end(); ?>
				<?php
				/**
				 * Hook: woocommerce_after_shop_loop.
				 *
				 * @hooked woocommerce_pagination - 10
				 */
				remove_action("woocommerce_after_shop_loop", "woocommerce_pagination", 10);
				do_action('woocommerce_after_shop_loop');
				?>
				<div class="box_woocommerce_pagination">
					<?= woocommerce_pagination() ?>
				</div>
			<?php } else { ?>
				<?php
				/**
				 * Hook: woocommerce_no_products_found.
				 *
				 * @hooked wc_no_products_found - 10
				 */
				do_action('woocommerce_no_products_found');
				?>
			<?php } ?>
			<?php
			$content = '';
			if (is_shop()) {
				$content = get_the_content(null, false, wc_get_page_id('shop'));
			} else {
				$content = get_the_archive_description();
			}
			?>
			<?php if (isset($content) && !empty($content)) { ?>
				<div class="relative border border-[#f2f4f7] rounded-[9px] p-6 mt-5 tab:p-4">
					<div class="text-[14px] text-[#495666] font-bold text-justify leading-[2.8] content-post">
						<?= @$content ?>
					</div>

					<div class="open">
						<svg class="icon w-[10px] h-[10px] fill-white rotate-90">
							<use xlink:href="#arrow-right"></use>
						</svg>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
<?php get_footer('shop'); ?>