<?php

/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

/*
 * @hooked wc_empty_cart_message - 10
 */
remove_action("woocommerce_cart_is_empty", 'wc_empty_cart_message', 10);
do_action('woocommerce_cart_is_empty');
?>

<?php do_action('woocommerce_before_cart_empty'); ?>
<?php if (wc_get_page_id('shop') > 0) : ?>
	<div class="flex items-center justify-center py-12">
		<div class="relative w-max">
			<svg class="icon w-[227px] h-[227px] fill-[#d1e6e6] max-sm:w-[180px] max-sm:h-[180px]">
				<use xlink:href="#cart-icon"></use>
			</svg>
			<span class="text-[30px] text-[#233564] font-bold absolute top-1/2 right-1/2 translate-x-1/2 whitespace-nowrap tab:text-[24px]">سبد
				خرید شما
				خالیست</span>
		</div>
	</div>
<?php endif; ?>