<?php

/**
 * Cross-sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cross-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

defined('ABSPATH') || exit;

if ($cross_sells) : ?>
	<section class="related products">

		<div class="cross-sells">
			<?php
			$heading = apply_filters('woocommerce_product_cross_sells_products_heading', __('You may be interested in&hellip;', 'woocommerce'));

			if ($heading) :
			?>
				<div class="flex items-center justify-between mb-5 a-sm:mb-3">
					<h2 class='text-[18px] text-[#495666] font-bold a-sm:text-[16px]'><?php echo esc_html($heading); ?></h2>

				</div>

			<?php endif; ?>

			<?php woocommerce_product_loop_start(); ?>
			<div class="swiper swiper-related-product">
				<div class="swiper-wrapper">

					<?php foreach ($cross_sells as $cross_sell) : ?>
						<div class="swiper-slide w-max">

							<?php
							$post_object = get_post($cross_sell->get_id());

							setup_postdata($GLOBALS['post'] = &$post_object); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

							get_template_part("template-parts/cards/card-product")
							?>
						</div>
					<?php endforeach; ?>
				</div>
			</div>

			<?php woocommerce_product_loop_end(); ?>

		</div>
	</section>
<?php
endif;

wp_reset_postdata();
