<?php

/**
 * Mini-cart
 *
 * Contains the markup for the mini-cart, used by the cart widget.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/mini-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.2.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_mini_cart'); ?>

<?php if (!WC()->cart->is_empty()) : ?>

	<ul class="woocommerce-mini-cart cart_list product_list_widget px-4 pt-4 <?php echo @esc_attr($args['list_class']); ?>">
		<?php
		do_action('woocommerce_before_mini_cart_contents');

		foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
			$_product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
			$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

			if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key)) {
				/**
				 * This filter is documented in woocommerce/templates/cart/cart.php.
				 *
				 * @since 2.1.0
				 */
				$product_name      = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);
				$thumbnail         = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);
				$thumbnail = str_replace('class="', 'class="w-[80px] h-[60px] object-contain ', $thumbnail);
				$product_price     = apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key);
				$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
		?>
				<li data-product-id="<?= @$product_id ?>" class="item item-product woocommerce-mini-cart-item relative text-white flex items-center gap-3 pb-3 mb-3 border-b border-[#eceff3] last:border-none <?php echo esc_attr(apply_filters('woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key)); ?>" data-count="<?= $cart_item['quantity'] ?? 0 ?>">
					<?php
					echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						'woocommerce_cart_item_remove_link',
						sprintf(
							'<a href="%s" class="remove remove_from_cart_button absolute top-0 w-4 h-4 bg-red-600 rounded-full flex items-center justify-center" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s" data-success_message="%s">&times;</a>',
							esc_url(wc_get_cart_remove_url($cart_item_key)),
							/* translators: %s is the product name */
							esc_attr(sprintf(__('Remove %s from cart', 'woocommerce'), wp_strip_all_tags($product_name))),
							esc_attr($product_id),
							esc_attr($cart_item_key),
							esc_attr($_product->get_sku()),
							/* translators: %s is the product name */
							esc_attr(sprintf(__('&ldquo;%s&rdquo; has been removed from your cart', 'woocommerce'), wp_strip_all_tags($product_name)))
						),
						$cart_item_key
					);
					$discount = get_product_discount_percentage($product_id);

					?>

					<?php if (empty($product_permalink)) : ?>
						<?php echo $thumbnail;
						?>
					<?php else : ?>
						<a href="<?php echo esc_url($product_permalink); ?>">
							<?php echo $thumbnail;
							?>
						</a>
					<?php endif; ?>

					<div class="w-full">
						<a href="<?= get_the_permalink($product_id) ?>" class="text-[15px] text-[#232c38] font-bold mb-4 line-clamp-1"><?= wp_kses_post($product_name) ?></a>
						<div class="flex items-center justify-end gap-3">
							<?php if (isset($discount) && !empty($discount)) { ?>
								<span class="text-[16px] text-[#ffffff] font-bold bg-primary_bg rounded-[5px] flex items-center gap-1 px-[6px]">
									<?= $discount ?>
									<svg class="fill-white w-[9px] h-[9px]">
										<use xlink:href="#percentage-icon">
										</use>
									</svg>
								</span>
							<?php } ?>
							<div class="flex items-center">
								<?= $product_price ?>
							</div>
							<div class="quantity-card box-quantity-cart-item border border-[#dfe4ed] rounded-[10px] flex items-stretch justify-between w-max">
								<button class="increase-quantity px-[10px]">
									<svg class="fill-[#28313b] w-[11px] h-[11px]">
										<use xlink:href="#plus-icon">
										</use>
									</svg>
								</button>
								<?php
								if ($_product->is_sold_individually()) {
									$product_quantity = sprintf('<input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key);
								} else {
									$input_args = array(
										'input_name' => "cart[{$cart_item_key}][qty]",
										'input_value' => $cart_item['quantity'],
										'max_value' => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
										'min_value' => '0',
										'classes' => 'text-[18px] text-[#28313b] font-bold grow text-center focus:outline-none py-1 max-w-[30px]',
										'product_id' => $product_id
									);

									$product_quantity = woocommerce_quantity_input($input_args, $_product, false);
								}
								echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item);
								?>
								<button class="decrease-quantity px-[10px]">
									<svg class="fill-[#28313b] w-[11px] h-[3px]">
										<use xlink:href="#minus-icon">
										</use>
									</svg>
								</button>
							</div>
						</div>
					</div>
				</li>
		<?php
			}
		}

		do_action('woocommerce_mini_cart_contents');
		?>
	</ul>
	<div class="border-t-2 border-[#eceff30] py-6 px-4 flex items-center justify-between box-calc-mini-cart">
		<div>
			<span class="text-[13px] text-[#232c38] font-bold">مبلغ قابل پرداخت</span>
			<div class="flex items-center woocommerce-mini-cart__total total">
				<?php woocommerce_widget_shopping_cart_subtotal() ?>
			</div>
		</div>

		<?php do_action('woocommerce_widget_shopping_cart_before_buttons'); ?>
		<a href="<?= wc_get_cart_url() ?>" class="text-[16px] text-[#ffffff] font-bold bg-primary_bg rounded-[10px] px-6 py-3">
			ثبت سفارش
		</a>
		<?php if (0) { ?>
			<p class="woocommerce-mini-cart__buttons buttons"><?php do_action('woocommerce_widget_shopping_cart_buttons'); ?></p>
		<?php } ?>
		<?php do_action('woocommerce_widget_shopping_cart_after_buttons'); ?>


		<?php
		/**
		 * Hook: woocommerce_widget_shopping_cart_total.
		 *
		 * @hooked woocommerce_widget_shopping_cart_subtotal - 10
		 */
		remove_action('woocommerce_widget_shopping_cart_total', 'woocommerce_widget_shopping_cart_subtotal', 10);
		do_action('woocommerce_widget_shopping_cart_total');
		?>
	</div>

<?php else : ?>

	<p class="woocommerce-mini-cart__empty-message p-7 text-center flex items-center justify-center text-[17px] text-red-600 font-bold"><?php esc_html_e('No products in the cart.', 'woocommerce'); ?></p>

<?php endif; ?>

<?php do_action('woocommerce_after_mini_cart'); ?>