<?php

/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

if (!defined('ABSPATH')) {
	exit;
}

do_action('woocommerce_before_checkout_form', $checkout);

// If checkout registration is disabled and not logged in, the user cannot checkout.
if (!$checkout->is_registration_enabled() && $checkout->is_registration_required() && !is_user_logged_in()) {
	echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'woocommerce')));
	return;
}
global $shopi_options;
?>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data">
	<div class="flex gap-7 mb-9 a-sxl:gap-3 a-lg:flex-col-reverse">
		<div class="order-2 grow border border-dashed border-[#cfd5dd] border-spacing-44 py-12 px-8 rounded-[7px] flex items-stretch gap-14 a-sxl:gap-4 lx:flex-col lx:gap-8 a-md:p-4 mb-6">
			<?php if ($checkout->get_checkout_fields()) : ?>

				<?php do_action('woocommerce_checkout_before_customer_details'); ?>

				<div class="col2-set max-w-[528px] min-w-[528px] lx:min-w-full lx:max-w-full" id="customer_details">
					<div class="col-1">
						<?php do_action('woocommerce_checkout_billing'); ?>
					</div>

					<div class="col-2">
						<?php do_action('woocommerce_checkout_shipping'); ?>
					</div>
				</div>

				<?php do_action('woocommerce_checkout_after_customer_details'); ?>

				<div class="grow lx:w-full">
					<div class="mb-8 a-sm:mb-6">
						<div class="flex items-center justify-between mb-6 a-sm:mb-3">
							<?php if (isset($shopi_options['checkout_fields_title']) && !empty($shopi_options['checkout_fields_title'])) { ?>
								<span class="text-[17px] text-[#394454] font-bold a-sm:text-[14px]"><?= @esc_attr($shopi_options['payment_method_title']) ?></span>
							<?php } ?>
							<?php if (isset($shopi_options['payment_method_description']) && !empty($shopi_options['payment_method_description'])) { ?>
								<span class="text-[12px] text-[#969fae] font-bold flex items-center gap-3 a-sm:text-[11px]">
									<?= @esc_attr($shopi_options['payment_method_description']) ?>
									<svg class="fill-[#969fae] w-[17px] h-[13px]">
										<use xlink:href="#card-bank-icon">
										</use>
									</svg>
								</span>
							<?php } ?>
						</div>
						<div class="px-8 py-10 rounded-[7px] border border-[#e7ebf2] a-sxl:px-4 a-md:p-4">
							<?php if (isset($shopi_options['payment_method_description_top_list_gateway']) && !empty($shopi_options['payment_method_description_top_list_gateway'])) { ?>
								<span class="text-[14px] text-[#a0a7b0] font-bold mb-12 block a-md:mb-6 a-sm:text-[12px]"><?= @esc_attr($shopi_options['payment_method_description_top_list_gateway']) ?></span>
							<?php } ?>
							<?php woocommerce_checkout_payment(); ?>
						</div>
					</div>
				</div>

			<?php endif; ?>
		</div>

		<div class="max-w-[331px] min-w-[331px] a-lg:max-w-full a-lg:min-w-full order-1">
			<?php do_action('woocommerce_checkout_before_order_review_heading'); ?>

			<h3 class="hidden" id="order_review_heading"><?php esc_html_e('Your order', 'woocommerce'); ?></h3>

			<?php do_action('woocommerce_checkout_before_order_review'); ?>

			<div id="order_review" class="woocommerce-checkout-review-order border border-dashed border-[#cfd5dd] border-spacing-44 p-6 rounded-[7px] mb-5">
				<?php remove_action("woocommerce_checkout_order_review", 'woocommerce_checkout_payment', 20) ?>
				<?php do_action('woocommerce_checkout_order_review'); ?>
			</div>

			<?php

			$order_button_text = "ثبت سفارش";
			if (isset($shopi_options['custom_checkout_button_text']) && !empty($shopi_options['custom_checkout_button_text'])) {
				$order_button_text = $shopi_options['custom_checkout_button_text'];
			}
			?>
			<div class="form-row">
				<input type="hidden" name="woocommerce_pay" value="1" />

				<?php wc_get_template('checkout/terms.php'); ?>

				<?php do_action('woocommerce_pay_order_before_submit'); ?>

				<?php echo apply_filters('woocommerce_pay_order_button_html', '<button type="submit" class="button alt text-[19px] text-[#ffffff] font-bold bg-secondary_bg rounded-[7px] w-full py-4 mb-3 a-sm:text-[15px]' . esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : '') . '" id="place_order" value="' . esc_attr($order_button_text) . '" data-value="' . esc_attr($order_button_text) . '">' . esc_html($order_button_text) . '</button>'); // @codingStandardsIgnoreLine 
				?>

				<?php do_action('woocommerce_pay_order_after_submit'); ?>

				<?php wp_nonce_field('woocommerce-pay', 'woocommerce-pay-nonce'); ?>
			</div>


			<?php do_action('woocommerce_checkout_after_order_review'); ?>
		</div>
	</div>
</form>

<?php do_action('woocommerce_after_checkout_form', $checkout); ?>