<?php

/**
 * Output a single payment method
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/payment-method.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.5.0
 */

if (!defined('ABSPATH')) {
	exit;
}
global $shopi_options;
global $shopi_options;
$item_class = ''; 
if ( isset( $shopi_options['display_payment_gateway_single_column'] ) && $shopi_options['display_payment_gateway_single_column'] ) {
    $item_class = 'single-item pb-5 mb-5';
}

?>
<li class="item wc_payment_method payment_method_<?php echo esc_attr($gateway->id); ?> px-1 <?= @$item_class ?>">
	<input id="payment_method_<?php echo esc_attr($gateway->id); ?>" type="radio" class="input-radio hidden" name="payment_method" value="<?php echo esc_attr($gateway->id); ?>" <?php checked($gateway->chosen, true); ?> data-order_button_text="<?php echo esc_attr($gateway->order_button_text); ?>" />
	<label for="payment_method_<?php echo esc_attr($gateway->id); ?>" class="flex flex-col items-center justify-center gap-3 cursor-pointer">
		<span class="transition-3s flex flex-col items-center justify-center text-[13px] font-bold text-[#6e6e6e]">
			<?php if ($gateway->get_icon()) { ?>
				<div class="w-16 h-14 object-contain opacity-60 flex items-center justify-center mb-4">
					<?php echo $gateway->get_icon(); /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?>
				</div>
			<?php } else { ?>
				<?php if (!(isset($shopi_options['display_payment_gateway_title']) && $shopi_options['display_payment_gateway_title'])) { ?>
					<span class="text-center"><?= $gateway->get_title() ?></span>
				<?php } ?>
			<?php } ?>
			<?php
			if (isset($shopi_options['display_payment_gateway_title']) && $shopi_options['display_payment_gateway_title']) {
				echo '<span class="text-center">' . $gateway->get_title() . '</span>';
			}
			?>
		</span>
		<div class="w-[26px] h-[26px] border border-[#e7e7ee] rounded-full flex items-center justify-center check-box-icon transition-3s">
			<svg class="fill-[#e0e5eb] w-[12px] h-[9px] transition-3s">
				<use xlink:href="#tik-icon">
				</use>
			</svg>
		</div>
	</label>
	<?php if ($gateway->has_fields() || $gateway->get_description()) : ?>
		<div class="payment_box payment_method_<?php echo esc_attr($gateway->id); ?> text-[13px] font-bold text-[#6e6e6e] justify-center mt-3 text-center" 
		<?php if (! $gateway->chosen) : /* phpcs:ignore Squiz.ControlStructures.ControlSignature.NewlineAfterOpenBrace */ ?>style="display:none;" <?php endif; /* phpcs:ignore Squiz.ControlStructures.ControlSignature.NewlineAfterOpenBrace */ ?>>
			<?php $gateway->payment_fields(); ?>
		</div>
	<?php endif; ?>
</li>