<?php

/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
	return;
}
global $product, $shopi_options;
$attr_color_card =  $shopi_options['color_variable_slug'] ?? 'pa_رنگ';
$crop_card_product =  $shopi_options['crop_card_product'] ?? 'thumbnail';

if (isset($attr_color_card) && !empty($attr_color_card)) {
	$tax_color = wp_get_post_terms(get_the_ID(), $attr_color_card);
	}

	$_english_title = get_post_meta(get_the_ID(), '_english_title', true);
	$status_quantity = $product->is_purchasable() && $product->is_in_stock() && !$product->is_type('variable');
	$count_item = get_product_quantity_in_cart(get_the_ID());
$class = "item-product-archive item-product bg-white border border-[#f2f4f7] px-[35px] py-6 flex flex-col a-sxl:p-6 tab:p-3 overflow-hidden ";
$status = $product->is_type('variable') ? 'variable' : 'simple';
$class .= ($status == 'simple' && $count_item != 0) ? "active" : "";
$class .= $status;

$attachment_ids = $product->get_gallery_image_ids();
$gallery_pic = isset($attachment_ids[0]) && !empty($attachment_ids[0]) ? $attachment_ids[0] : null;
$class_pic = "object-contain m-auto transition-3s mix-blend-darken min-h-full max-h-full absolute left-0 right-0 top-0 bottom-0 transition-3s";
?>
<li <?php echo esc_attr(wc_product_class($class, $product)); ?>>
	<div class=" flex items-center justify-between mb-3">
		<?php if (!is_wp_error($tax_color) && !empty($tax_color)) {
			$count = count($tax_color);
			$i = 1; ?>
			<div class="grid grid-cols-2 gap-[2px] w-max">
				<?php foreach ($tax_color as $key => $value) {
					if ($i > 4) {
						break;
					}
					$color = get_term_meta($value->term_id, 'product_attribute_color', true);
					if ($color) {
				?>
						<span class="w-2 h-2 rounded-full" style="background-color: <?= @$color ?>;"></span>
				<?php
						$i++;
					}
				} ?>
				<?php if ($i > 4) {
					$number =  $i - 4;
				?>
					<span class="col-span-2 text-[14px] text-[#969fae] font-bold flex items-center justify-center">
						<?= @$number ?>+
					</span>
				<?php } ?>
			</div>
		<?php } ?>

		<?php if ($shopi_options['display_product_info'] === 'rating') { ?>
			<span class="text-[14px] text-[#969fae] font-bold flex flex-col items-center justify-center gap-2 box-rate">
				<svg class="fill-[#cbcfd7] w-[13px] h-[13px]">
					<use xlink:href="#star-icon">
					</use>
				</svg>
				<?= avg_rating_post() ?>
			</span>
		<?php }else{ ?>
			<?php
					$custom_attr = get_post_meta(get_the_ID(), 'custom_attr', true);
					if (!empty($custom_attr)) {
							?>
							<span class="text-[12px] text-[#164B8A] font-bold border border-[#EEF2F6] rounded-[8px] px-3 py-1 inline-flex bg-white mr-auto">
								<?php echo esc_html($custom_attr); ?>
							</span>
							<?php
					}
				?>
		<?php } ?>

	</div>

	<a href="<?php the_permalink() ?>" class="box-pic relative max-h-[120px] min-h-[120px] w-full mb-14 <?= $shopi_options['product_second_image_hover'] == '1' ? 'pic2' : ''?>">
		<?php if (has_post_thumbnail()) {
			echo get_the_post_thumbnail(get_the_ID(), $crop_card_product, ['class' => "$class_pic primary-img"]);
		} else {
			echo wc_placeholder_img($crop_card_product, ['class' => "$class_pic primary-img"]);
		} ?>
		<?php if ($shopi_options['product_second_image_hover'] == 1 && $gallery_pic) { ?>
			<?= wp_get_attachment_image($gallery_pic, $crop_card_product, false,  ['class' => "$class_pic secondary-img"]) ?>
		<?php } ?>
	</a>
	<h2 class="box-title mb-6 mt-auto">
		<a href="<?php the_permalink() ?>" class="title text-[15px] text-[#394454] font-bold line-clamp-2 tab:text-[14px] leading-[1.8]">
			<?php the_title() ?>
		</a>
	</h2>
	<div class="flex items-center justify-between relative">
		<?php if ( $product && $product->is_in_stock() && $product->get_price() > 0 ) { ?>
			<?php woocommerce_template_loop_add_to_cart(['type' => 'archive_pro']) ?>
		<?php } ?>
		<?php woocommerce_template_loop_price() ?>
		<?php if ( $product && $product->is_in_stock() && $product->get_price() > 0 ) { ?>
			<?php if ($status_quantity) { ?>
				<?php
				set_query_var('count_item', $count_item);
				get_template_part('template-parts/cards/card-quantity') ?>
			<?php } ?>
		<?php } ?>
	</div>
</li>