<?php

/**
 * Loop Add to Cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/add-to-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.2.0
 */

if (!defined('ABSPATH')) {
	exit;
}

global $product;
$product_args = $args['product'] ?? null;
if ($product_args) {
	$product = $product_args;
}
$aria_describedby = isset($args['aria-describedby_text']) ? sprintf('aria-describedby="woocommerce_loop_add_to_cart_link_describedby_%s"', esc_attr($product->get_id())) : '';
$type = $args['type'] ?? null;
$class = "add-to-cart-custom !flex items-center justify-between tab:rounded-[10px] tab:bg-responsive_cart_button tab:pr-3";
$text = '<span class="text-[12px] font-bold text-[#fff] hidden tab:flex">افزودن به سبد</span>
<span class="add-c add-to-cart-custom-loading w-[50px] h-[50px] rounded-[16px] tab:rounded-[8px] bg-primary_bg flex items-center justify-center drop-shadow-add-to-cart tab:w-[38px] tab:h-[38px]">
<svg class="fill-[#fff] w-[18px] tab:w-[15px]">
                <use xlink:href="#add-to-cart">
                </use>
            </svg></span>
';
if ($type == 'type_tab') {
	$class = "add-to-cart-sample";
	$text = '<span class="add-c bg-primary_bg rounded-[18px] w-[60px] h-[35px] flex items-center justify-center">
                                                                    <svg class="fill-white w-[14px] h-[14px]">
                                                                        <use xlink:href="#plus-icon">
                                                                    </use></svg>
                                                                </span>
';
}
if ($type == 'offer') {
	$class = "add-to-cart-custom";
	$text = '<span class="add-c add-to-cart-custom-loading w-[50px] h-[50px] rounded-[16px] bg-white flex items-center justify-center lx:bg-primary_bg tab:bg-white">
                                                <svg class="fill-[#ee384e] w-[18px] h-5  lx:fill-[#fff] tab:fill-primary_fill">
                                                    <use xlink:href="#add-to-cart">
                                                </use></svg>
                                            </span>';
}
if ($type == 'side_single') {
	$class = "add-to-cart-custom";
	$text = '<span class="text-[20px] text-[#ffffff] font-bold bg-secondary_bg px-6 py-[18px] flex items-center justify-between gap-2 rounded-[9px] mb-5 a-md:mb-3 a-md:py-3 a-md:text-[17px]">
						افزودن به سبد خرید
						<svg class="fill-white w-[14px] h-[14px]">
							<use xlink:href="#plus-icon">
						</use></svg>
					</span>';
}
if ($type == 'archive_pro') {
	$class = "add-to-cart-custom flex items-center justify-between";
	$text = '
<span class="add-c add-to-cart-custom-loading w-[50px] h-[50px] rounded-[16px] bg-primary_bg flex items-center justify-center drop-shadow-add-to-cart transition-3s">
<svg class="fill-[#fff] w-[18px] transition-3s">
                <use xlink:href="#add-to-cart">
                </use>
            </svg></span>
';
}

echo apply_filters(
	'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
	sprintf(
		'<a href="%s" %s data-quantity="%s" class="%s" %s>%s</a>',
		esc_url($product->add_to_cart_url()),
		$aria_describedby,
		esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
		esc_attr(isset($args['class']) ? $args['class'] : 'button') . " " . $class,
		isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
		$text
	),
	$product,
	$args
);
?>
<?php if (isset($args['aria-describedby_text'])) : ?>
	<span id="woocommerce_loop_add_to_cart_link_describedby_<?php echo esc_attr($product->get_id()); ?>" class="screen-reader-text">
		<?php echo esc_html($args['aria-describedby_text']); ?>
	</span>
<?php endif; ?>