<?php

/**
 * Show options for ordering
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/orderby.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.6.0
 */

if (!defined('ABSPATH')) {
	exit;
}
$text = [
	'menu_order' => ' پیش‌فرض',
	'popularity' => ' محبوبیت',
	'rating' => ' امتیاز',
	'date' => ' جدیدترین',
	'price' => ' ارزانترین',
	'price-desc' => ' گرانترین',
];

?>
<form class="woocommerce-ordering" method="get">
	<ul class="list-tab-archive list-tab-archive-shop  flex items-center gap-7 a-sm:gap-4">
		<?php foreach ($catalog_orderby_options as $id => $name) :
			if (isset($id) && !empty($id) && $id != "menu_order") :
		?>
				<li class="text-[13px] text-[#b1bcca] font-bold <?= isset($_GET["orderby"]) && $_GET["orderby"] == $id ? "active" : "" ?> "><a href="<?= add_query_arg("orderby", esc_attr($id)) ?>"><?php echo @$text[$id] ? $text[$id] : $name; ?></a></li>
		<?php
			endif;
		endforeach; ?>
	</ul>
	<input type="hidden" name="paged" value="1" />
	<?php wc_query_string_form_fields(null, array('orderby', 'submit', 'paged', 'product-page')); ?>
</form>