<?php

/**
 * Edit account form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.7.0
 */

defined('ABSPATH') || exit;
$user_id = get_current_user_id();
if (isset($_POST["change_password"]) && isset($_POST["token"]) && get_csrf_token() == $_POST["token"]) {
	$new_password = $_POST["new_password"];
	$repetition_new_password = $_POST["repetition_new_password"];
	if (!empty($new_password) && !empty($repetition_new_password)) {
		if ($new_password != $repetition_new_password) {
			$errors[] = "رمز عبور جدید وارد شده یکسان نمی باشد";
		} elseif (!validatePassword($new_password) && !validatePassword($repetition_new_password)) {
			$errors[] = "رمز عبور باید شامل حداقل یک عدد و حداقل یک کاراکتر با حروف بزرگ (A-Z) باشد.";
		} elseif ($new_password == $repetition_new_password) {
			wp_set_password($new_password, $user_id);
			wp_set_current_user($user_id);
			wp_set_auth_cookie($user_id);
			$success[] = "رمز عبور شما تغییر کرد";
		}
	} else {
		$errors[] = "فیلد پسورد خالی است";
	}
	regenerate_csrf_token();
}

?><?php
	do_action('woocommerce_before_edit_account_form'); ?>

<div class="flex items-center justify-between border-[#f2f4f7] border-b pb-6 mb-9 tab:mb-4 tab:pb-4">
	<span class="text-[17px] text-[#768699] font-bold tab:text-[15px]">تنظیمات حساب کاربری</span>
</div>
<?php if (isset($errors) && !empty($errors)) { ?>
	<div class="mb-7">
		<?php foreach ($errors as $key => $value) {
			print_msg($value);
		?>
		<?php } ?>
	</div>
<?php } ?>
<?php if (isset($success) && !empty($success)) { ?>
	<div class="mb-7">
		<?php foreach ($success as $key => $value) { ?>
			<?php print_msg($value, 'success'); ?>
		<?php } ?>
	</div>
<?php } ?>
<form class="woocommerce-EditAccountForm edit-account mb-10" action="" method="post" <?php do_action('woocommerce_edit_account_form_tag'); ?>>

	<?php do_action('woocommerce_edit_account_form_start'); ?>

	<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
		<label for="account_first_name"><?php esc_html_e('First name', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_first_name" id="account_first_name" autocomplete="given-name" value="<?php echo esc_attr($user->first_name); ?>" />
	</p>

	<p class="woocommerce-form-row woocommerce-form-row--last form-row form-row-last">
		<label for="account_last_name"><?php esc_html_e('Last name', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_last_name" id="account_last_name" autocomplete="family-name" value="<?php echo esc_attr($user->last_name); ?>" />
	</p>

	<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
		<label for="account_display_name"><?php esc_html_e('Display name', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="account_display_name" id="account_display_name" value="<?php echo esc_attr($user->display_name); ?>" />
	</p>

	<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
		<label for="account_email"><?php esc_html_e('Email address', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
		<input type="email" class="woocommerce-Input woocommerce-Input--email input-text" name="account_email" id="account_email" autocomplete="email" value="<?php echo esc_attr($user->user_email); ?>" />
	</p>

	<?php
	/**
	 * Hook where additional fields should be rendered.
	 *
	 * @since 8.7.0
	 */
	do_action('woocommerce_edit_account_form_fields');
	?>
	<?php
	/**
	 * My Account edit account form.
	 *
	 * @since 2.6.0
	 */
	do_action('woocommerce_edit_account_form');
	?>

	<p class="box-submit-form">
		<?php wp_nonce_field('save_account_details', 'save-account-details-nonce'); ?>
		<button type="submit" class="woocommerce-Button button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" name="save_account_details" value="<?php esc_attr_e('Save changes', 'woocommerce'); ?>"><?php esc_html_e('Save changes', 'woocommerce'); ?></button>
		<input type="hidden" name="action" value="save_account_details" />
	</p>

	<?php do_action('woocommerce_edit_account_form_end'); ?>
</form>

<?php do_action('woocommerce_after_edit_account_form'); ?>


<form method="post" class="body-pass">
	<div class="inputs-wrap grid grid-cols-3 woocommerce-EditAccountForm mb-6">
		<p>
			<label class="">رمز عبور فعلی</label>
			<input class="" type="password" value="*******" placeholder="رمز عبور فعلی" disabled>
		</p>
		<p>
			<label class="">رمز عبور جدید</label>
			<input class="" name="new_password" type="text">
		</p>
		<p>
			<label class="">تکرار رمز عبور جدید</label>
			<input class="" name="repetition_new_password">
		</p>
	</div>
	<!-- .inputs-wrap -->
	<?= csrf_field() ?>
	<button type="submit" name="change_password" class="py-4 px-6 bg-primary_bg text-[15px] text-[#ffffff] font-bold rounded-xl button">
		ذخیره رمز عبور جدید
	</button>
</form>