<?php

/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

if (!defined('ABSPATH')) {
	exit;
}
$list_icons = [
	'dashboard' => ["icon" => "dashboard-icon"],
	'orders' => ["icon" => "orders-icon"],
	'downloads' => ["icon" => "user"],
	'edit-address' => ["icon" => "map-icon"],
	'edit-account' =>  ["icon" => "setting-icon"],
	'customer-logout' => ["icon" => "exit2"],
	'wishlist' => ["icon" => "interested-icon"],
	'visited' => ["icon" => "view-icon"],
	'comment' => ["icon" => "comment-icon"],
];


do_action('woocommerce_before_account_navigation');
?>
<div class="border border-[#f2f4f7] rounded-[9px] bg-white p-6 pb-3 sticky top-2">
	<div class="flex items-center gap-5 pb-3 mb-4 border-b border-[#eef3f8]">
		<span class="w-9 h-9 bg-slate-300 rounded-full flex items-center justify-center">
			<svg class="fill-[#fff] w-[16px] h-[20px]">
				<use xlink:href="#user-icon">
				</use>
			</svg>
		</span>
		<div class="flex flex-col">
			<span class="text-[16px] text-[#495666] font-bold"><?= wp_get_current_user()->display_name ?></span>
			<!-- <span class="text-[13px] text-[#969fae] font-bold">09903861490</span> -->
		</div>
	</div>

	<nav class="woocommerce-MyAccount-navigation" aria-label="<?php esc_html_e('Account pages', 'woocommerce'); ?>">
		<ul class="border-b border-[#e6ebf1] pb-7 list-items-panel">
			<?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
				<li>
					<a href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>" <?php echo wc_is_current_account_menu_item($endpoint) ? 'aria-current="page"' : ''; ?> class="<?php echo wc_get_account_menu_item_classes($endpoint); ?> text-[13px] text-[#768699] font-bold flex items-center gap-5 py-[10px] relative transition-3s">
						<svg class="fill-[#768699] w-[16px] h-[15px] transition-3s">
							<use xlink:href="#<?= @esc_attr($list_icons[$endpoint]["icon"]) ?>">
							</use>
						</svg>
						<span class="grow"><?php echo esc_html($label); ?></span>
						<svg class="fill-[#c8d2e1] w-[5px] h-[9px] transition-3s">
							<use xlink:href="#arrow-left-icon">
							</use>
						</svg>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>
	</nav>
	<a href="<?= wp_logout_url(home_url()) ?>" class="p-3 pt-6 flex items-center justify-center">
		<svg class="fill-[#c0ccdb] w-[15px] h-[16px]">
			<use xlink:href="#off-icon">
			</use>
		</svg>
	</a>
	<?php do_action('woocommerce_after_account_navigation'); ?>
</div>