<?php

/**
 * Orders
 *
 * Shows orders on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/orders.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.2.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_account_orders', $has_orders); ?>
<div class="border-b border-[#f2f4f7] flex items-center justify-between pb-6 tab:flex-col tab:gap-2 tab:mb-4 tab:pb-4">
	<span class="text-[17px] text-[#768699] font-bold tab:text-[15px]">سفارش های من</span>
	<form action="" class="flex items-stretch box-search-order tab:w-full tab:border tab:border-[#eee] tab:rounded-[7px] tab:overflow-hidden tab:p-3">
		<input name="search" type="text" value="<?= isset($_GET['search']) && !empty($_GET['search']) ? esc_attr($_GET['search']) : '' ?>" class="focus:outline-none text-[13px] text-[#b1bcca] font-bold max-w-[0] transition-3s tab:max-w-full grow" placeholder="جست و جو کنید">
		<button type="submit">
			<svg class="fill-[#b2b9c9] w-[15px] h-[15px]">
				<use xlink:href="#search-vip-icon">
				</use>
			</svg>
		</button>
	</form>
</div>
<?php if ($has_orders) : $i_c = 0; ?>
	<div class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table mb-4">
		<div>
			<?php
			foreach ($customer_orders->orders as $customer_order) {
				$order      = wc_get_order($customer_order); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
				$item_count = $order->get_item_count() - $order->get_item_count_refunded();
				$order_items = $order->get_items();
			?>
				<div class="item-accordion item-order <?= $i_c == 0 ? 'active' : '' ?> woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr($order->get_status()); ?> order">
					<ul class="head grid grid-cols-12 gap-6 py-8 border-b border-[#eceff3] cursor-pointer a-md:grid-cols-4 a-md:gap-6 a-sm:grid-cols-2 a-sm:py-4">
						<?php foreach (wc_get_account_orders_columns() as $column_id => $column_name) :
							$is_order_number = 'order-number' === $column_id;
						?>

							<?php if ($is_order_number) : ?>
								<li class="text-[14px] text-[#8793a2] font-bold flex items-center gap-1 ml:flex-col col-span-2 a-sm:col-span-1">
									<span>کد سفارش :</span>
									<a href="<?php echo esc_url($order->get_view_order_url()); ?>" aria-label="<?php echo esc_attr(sprintf(__('View order number %s', 'woocommerce'), $order->get_order_number())); ?>">
										<?php echo esc_html(_x('#', 'hash before order number', 'woocommerce') . $order->get_order_number()); ?>
									</a>
								</li>
							<?php elseif ('order-date' === $column_id) : ?>
								<li class="text-[14px] text-[#8793a2] font-bold flex items-center gap-1 ml:flex-col col-span-2 a-sm:col-span-1">
									<span>تاریخ سفارش :</span>
									<time datetime="<?php echo esc_attr($order->get_date_created()->date('c')); ?>"><?php echo esc_html(wc_format_datetime($order->get_date_created())); ?></time>
								</li>
							<?php elseif ('order-total' === $column_id) : ?>
								<li class="text-[14px] text-[#8793a2] font-bold flex items-center gap-1 ml:flex-col order-total-final col-span-3 a-sm:col-span-1">
									<span>مبلغ کل پرداخت :</span>
									<?php echo wp_kses_post(sprintf(_n('%1$s for %2$s item', '%1$s', 'woocommerce'), $order->get_formatted_order_total()));  ?>
								</li>
							<?php elseif ('order-status' === $column_id) : ?>
								<li class="text-[14px] text-[#8793a2] font-bold flex items-center gap-1 ml:flex-col col-span-2 a-sm:col-span-1">
									<span>وضعیت :</span>
									<span class="text-[#4b5867]"> <?php echo esc_html(wc_get_order_status_name($order->get_status())); ?></span>
								</li>
							<?php elseif ('order-actions' === $column_id) : ?>
							<?php endif; ?>
						<?php endforeach; ?>

						<li class="text-[14px] text-[#4b5867] font-bold cursor-pointer col-span-3 a-md:col-span-4 a-md:m-auto a-sm:col-span-2 flex items-center justify-end gap-7">
							<?php
							$actions = wc_get_account_orders_actions($order);

							if (!empty($actions)) {
								foreach ($actions as $key => $action) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
									/* translators: %s: order number */

									echo '<a href="' . esc_url($action['url']) . '" class="woocommerce-button' . esc_attr($wp_button_class) . ' button ' . sanitize_html_class($key) . '" aria-label="' . esc_attr(sprintf(__('View order number %s', 'woocommerce'), $order->get_order_number())) . '">' . esc_html($action['name']) . '</a>';
								}
							}
							?>
							<span class="text-[14px] text-[#4b5867] font-bold flex items-center gap-2">مشاهده
								جزئیات
								<span class="w-[28px] h-[17px] rounded-[9px] bg-primary_bg flex items-center justify-center icon-drop-down transition-3s">
									<svg class="fill-white w-[9px] h-[5px] transition-3s">
										<use xlink:href="#arrow-btn-icon">
										</use>
									</svg>
								</span>
							</span>
						</li>
					</ul>
					<div class="content <?= $i_c == 0 ? '' : 'hidden' ?>">
						<ul>
							<?php foreach ($order_items as $item_id => $item) {
								$item_data = $item->get_data();
								$variation_attributes = $item->get_meta_data();
							?>
								<li class="flex items-stretch gap-9 border-b border-[#eceff3] py-6 a-md:py-4 a-md:flex-col a-md:items-center a-md:gap-4">
									<?php if (has_post_thumbnail($item_data['product_id'])) {
										echo get_the_post_thumbnail($item_data['product_id'], 'woocommerce_thumbnail', ['class' => 'w-14 h-14 object-contain']);
									} else {
										echo wc_placeholder_img('woocommerce_thumbnail', ['class' => 'w-14 h-14 object-contain']);
									} ?>
									<div class="flex flex-col gap-2 justify-between grow">
										<span class="text-[17px] text-[#495666] font-bold a-md:text-[14px] line-clamp-2 ml:text-[15px]">
											<?= @esc_attr($item_data['name']) ?>
										</span>
										<div class="variation text-[13px] text-[#8995a5] font-bold flex items-center gap-4">
											<?php
											do_action('woocommerce_order_item_meta_start', $item_id, $item, $order, false);

											wc_display_item_meta($item); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

											do_action('woocommerce_order_item_meta_end', $item_id, $item, $order, false);
											?>
										</div>
									</div>
									<div class="product-total flex items-start gap-1">
										<?php
										$qty          = $item->get_quantity();
										$refunded_qty = $order->get_qty_refunded_for_item($item_id);

										if ($refunded_qty) {
											$qty_display = '<del class="text-[17px] text-[#4b5867] font-bold">' . esc_html($qty) . '</del> <ins class="text-[17px] text-[#4b5867] font-bold">' . esc_html($qty - ($refunded_qty * -1)) . '</ins>';
										} else {
											$qty_display = esc_html($qty);
										}

										echo apply_filters('woocommerce_order_item_quantity_html', ' <strong class="product-quantity text-[17px] text-[#4b5867] font-bold">' . sprintf('%s&times;&nbsp;', $qty_display) . '</strong>', $item); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
										?>
										<?php echo $order->get_formatted_line_subtotal($item); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped  
										?>
									</div>
								</li>
							<?php } ?>
						</ul>
					</div>
				</div>
			<?php
				$i_c++;
			}
			?>
		</div>
	</div>

	<?php do_action('woocommerce_before_account_orders_pagination'); ?>
	<div class="pagination-wrap comment-pagination">
		<?php
		$args = array(
			'base' => esc_url(wc_get_endpoint_url('orders')) . '%_%',
			'format' => '%#%',
			'total' => $customer_orders->max_num_pages,
			'current' => $current_page,
			'show_all' => false,
			'end_size' => 3,
			'mid_size' => 3,
			'prev_next' => true,
			'add_args' => false,
			'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
			'next_text' => is_rtl() ? '&larr;' : '&rarr;',
			'type'      => '',
		);
		echo paginate_links($args);
		?>
	</div><!-- .pagination-wrap -->

<?php else : ?>

	<?php wc_print_notice(esc_html__('No order has been made yet.', 'woocommerce') . ' <a class="woocommerce-Button wc-forward button' . esc_attr($wp_button_class) . '" href="' . esc_url(apply_filters('woocommerce_return_to_shop_redirect', wc_get_page_permalink('shop'))) . '">' . esc_html__('Browse products', 'woocommerce') . '</a>', 'notice'); // phpcs:ignore WooCommerce.Commenting.CommentHooks.MissingHookComment 
	?>

<?php endif; ?>

<?php do_action('woocommerce_after_account_orders', $has_orders); ?>