<?php
global $shopi_options;
?>
<?php get_template_part('template-parts/headers/header-head'); ?>
<div class="parallax-container bg-primary_bg min-h-[100dvh] flex items-center justify-center" style="background-color: <?= @$shopi_options['bg_404'] ?>;">
    <div class="container 2xl m-auto min-h-[90dvh] flex flex-col items-center justify-between">
        <div class="flex items-center justify-between w-full tab:flex-col tab:gap-10">
            <div class='text-[14px] text-[#ffffff] font-bold flex flex-col gap-3 tab:items-center'>
                <svg class='fill-[white] w-[81px] h-[35px]'>
                    <use xlink:href='#404-logo-icon'>
                </svg>
                متاسفانه صفحه مورد نظر یافت نشد
            </div>
        </div>
        <svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1014 359" class="parallax-item w-[65vw]" fill="<?= @$shopi_options['color_icon_404'] ?>">
            <path d="m503.3 11c-175.2 0-340.2 98.8-465.4 221.9-18.2 17.9-18.4 47-0.6 65.2 17.9 18.1 47 18.3 65.2 0.5 224.7-221.1 587.5-218.1 808.6 6.7 17.8 18.1 47 18.4 65.1 0.5 18.1-17.8 18.4-47 0.5-65.1-124.4-126.5-290.6-228.2-467.8-229.7q-2.8 0-5.6 0z" />
        </svg>
        <div class="flex items-center justify-between w-full tab:grid tab:grid-cols-11">
            <div class="flex items-center gap-8 tab:col-span-5">
                <a href="<?= home_url() ?>" class='text-[14px] text-[#fff] font-bold flex items-center gap-4 tab:text-[11px] tab:gap-2'>
                    <svg class='fill-white w-4 h-4 tab:w-3 tab:h-3 tab:rotate-180'>
                        <use xlink:href='#arrow-left-vip-icon'>
                    </svg>
                    بازگشت به صفحه اصلی
                </a>
            </div>
            <div class="flex items-center justify-center tab:col-span-1">
                <svg class='fill-white w-5 h-5 tab:w-4 tab:h-4'>
                    <use xlink:href='#search-vip-icon'>
                </svg>
            </div>
            <div class='text-[12px] text-[#ffffff] font-bold flex flex-col items-end text-end tab:text-[10px] tab:col-span-5'>
                <?php if (isset($shopi_options['text_1_introducing_brand']) && !empty($shopi_options['text_1_introducing_brand'])) { ?>
                    <span class="flex items-center gap-1"><svg class='fill-white w-[12px] h-[11px] tab:text-[10px] tab:w-[10px] tab:h-[10px]'>
                            <use xlink:href='#heart-fill-icon'>
                        </svg><?= @esc_attr($shopi_options['text_1_introducing_brand']) ?></span>
                <?php } ?>
                <?php if (isset($shopi_options['text_2_introducing_brand']) && !empty($shopi_options['text_2_introducing_brand'])) { ?>
                    <span><?= @esc_attr($shopi_options['text_2_introducing_brand']) ?></span>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<?php get_template_part('template-parts/footers/footer-foot'); ?>