jQuery(document).ready(function ($) {
    const Toast = Swal.mixin({
        toast: true,
        position: window.innerWidth <= 768 ? 'bottom-end' : theme_redux.sweetalert_position,
        showConfirmButton: false,
        timer: 2500,
        timerProgressBar: true,
        didOpen: (toast) => {
            toast.addEventListener('mouseenter', Swal.stopTimer)
            toast.addEventListener('mouseleave', Swal.resumeTimer)
        }
    })

    if($(".tab-boxes").length){
        $(".tab-boxes").each(function () {
            var tabs = $(this);
            var hash = tabs.data("hash") || false;
            var ajax = tabs.data("ajax") || false;

            if (hash && window.location.hash) {
                if (
                    $(this).find('.tabs li[data-target="' + window.location.hash + '"]')
                        .length
                ) {
                    $(this).find(".tabs li").removeClass("active");
                    $(this)
                        .find('.tabs li[data-target="' + window.location.hash + '"]')
                        .addClass("active");
                }
            }

            $("ul.tabs li", tabs).each(function () {
                if ($(this).hasClass("active")) {
                    /** Ajax load if not loaded already **/
                    if (ajax && $($(this).attr("data-target")).length === 0) {
                        var ajaxData = $(this).data("ajax");
                        ajaxData.wrap_id = $(this).data("target").replace("#", "");

                        $.ajax({
                            method: ajax.method || "GET",
                            url: ajax.url,
                            data: ajaxData,
                            success: function (msg) {
                                tabs.find(".tab-content").append(msg);
                            },
                        });
                    } else {
                        /** Normal load **/
                        $($(this).attr("data-target")).show();
                    }
                } else {
                    $($(this).attr("data-target")).hide();
                }
            });

            tabs
                .find("ul.tabs")
                .eq(0)
                .find("li:not('.exclude')")
                .click(function () {
                    var tabBox = $(this).closest(".tab-boxes");
                    var tab = $(this);
                    var tabtar = tab.attr("data-target");


                    if (hash) {
                        window.location.hash = tabtar;
                    }

                    if (!tab.hasClass("active")) {
                        tabBox.find("ul.tabs").eq(0).find("li").removeClass("active");
                        tab.addClass("active");
                        $(".tab-content", tabBox).hide();

                        /** Ajax load **/
                        if (ajax && tab.data("ajax") && $(tabtar).length === 0) {
                            var ajaxData = $(this).data("ajax");
                            ajaxData.wrap_id = $(this).data("target").replace("#", "");

                            $.ajax({
                                method: ajax.method || "GET",
                                url: ajax.url,
                                data: ajaxData,
                                success: function (msg) {
                                    tabs.find(".tab-contents").append(msg);
                                },
                            });
                        } else {
                            /** Normal load **/
                            $(tabtar).fadeIn("medium");
                        }

                        $(document).trigger("dw_dynamically_updated");
                    }
                });
        });
    }

    new Swiper(".offer-hero-swiper", {
        autoplay: {
            // delay: 4000,
        },
        spaceBetween: 16,
        navigation: {
            nextEl: ".swiper-button-next-vip",
            prevEl: ".swiper-button-prev",
        },
        breakpoints: {
            0: {
                slidesPerView: 1,
                spaceBetween: 40,
            },
            575: {
                slidesPerView: 'auto',
            },
            1200: {
                slidesPerView: 1,
            }
        }
    });

    new Swiper(".swiper-hero", {
        effect: "fade",
        slidesPerView: 1,
        navigation: {
            nextEl: ".swiper-button-next-hero",
            prevEl: ".swiper-button-prev-hero",
        },
        autoplay: {
            delay: 2000,
        },
    });

    const sliders = $('.swiper-slider-product');
    sliders.each((index, element) => {
        const nextButton = element.querySelector('.swiper-button-next');
        const prevButton = element.querySelector('.swiper-button-prev');
        const settings = JSON.parse(element.dataset.settings || '{}');

        const defaultArgs = {
            loop: false,
            autoplay: false,
            autoplayDelay: 3000,
            speed: 500,
            autoplayDisableOnInteraction: false,
        };


        new Swiper(element, {
            slidesPerView: 'auto',
            spaceBetween: 10,
            navigation: {
                nextEl: nextButton,
                prevEl: prevButton,
            },
            breakpoints: {
                0: {
                    slidesPerView: 1.5,
                    spaceBetween: 5,
                },
                575: {
                    slidesPerView: 'auto',
                },
                768: {
                    spaceBetween: 16,
                }
            },
            loop: settings.loop ?? defaultArgs.loop,
            autoplay: settings.autoplay ? {
                delay: settings.autoplay_delay ?? defaultArgs.autoplayDelay,
                disableOnInteraction: settings.autoplay_disable_on_interaction ?? defaultArgs.autoplayDisableOnInteraction,
            } : false,
            speed: settings.speed ?? defaultArgs.speed,
        });
    });


    const swiper_offer_page = $('.swiper-offer-page');
    swiper_offer_page.each((index, element) => {
        const settings = JSON.parse(element.dataset.settings || '{}');

        const defaultArgs = {
            loop: false,
            autoplay: false,
            autoplayDelay: 3000,
            speed: 500,
            autoplayDisableOnInteraction: false,
        };

        const swiperInstance = new Swiper(element, {
            slidesPerView: 'auto',
            pagination: {
                el: '.swiper-pagination',
                type: 'bullets',
                clickable: true,
            },
            on: {
                init: function () {
                    const bullets = this.pagination.el.querySelectorAll('.swiper-pagination-bullet');
                    const activeSlide = this.slides[this.activeIndex];
                    if (!activeSlide) return;

                    const parent = activeSlide.parentElement;
                    const paginationWrapper = $(parent).parents(".box-swiper").find(".swiper-pagination");
                    paginationWrapper.html(bullets);
                },
                slideChange: function () {
                    const bullets = $(this.pagination.el).find('.swiper-pagination-bullet');
                    const activeIndex = this.activeIndex;
                    const activeSlide = this.slides[activeIndex];
                    if (!activeSlide) return;

                    const parent = activeSlide.parentElement;
                    const paginationWrapper = $(parent).parents(".box-swiper").find(".swiper-pagination");
                    const activeBulletIndex = bullets.index($(this.pagination.el).find('.swiper-pagination-bullet-active'));

                    paginationWrapper.find('.swiper-pagination-bullet').removeClass('swiper-pagination-bullet-active');
                    paginationWrapper.find('.swiper-pagination-bullet').eq(activeBulletIndex).addClass('swiper-pagination-bullet-active');
                }
            },
            breakpoints: {
                0: {
                    slidesPerView: 1.5,
                },
                575: {
                    slidesPerView: 'auto',
                }
            },
            loop: settings.loop ?? defaultArgs.loop,
            autoplay: settings.autoplay ? {
                delay: settings.autoplay_delay ?? defaultArgs.autoplayDelay,
                disableOnInteraction: settings.autoplay_disable_on_interaction ?? defaultArgs.autoplayDisableOnInteraction,
            } : false,
            speed: settings.speed ?? defaultArgs.speed,
        });
    });


    const swiper_vip_slider_product = $('.swiper-vip-slider-product');
    swiper_vip_slider_product.each((index, element) => {
        const settings = JSON.parse(element.dataset.settings || '{}');

        const defaultArgs = {
            loop: false,
            autoplay: false,
            autoplayDelay: 3000,
            speed: 500,
            autoplayDisableOnInteraction: false,
        };


        new Swiper(element, {
            slidesPerView: 'auto',
            spaceBetween: 5,
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
            breakpoints: {
                0: {
                    slidesPerView: 1.5,
                },
                575: {
                    slidesPerView: 'auto',
                },
                768: {
                    spaceBetween: 20
                }
            },
            loop: settings.loop ?? defaultArgs.loop,
            autoplay: settings.autoplay ? {
                delay: settings.autoplay_delay ?? defaultArgs.autoplayDelay,
                disableOnInteraction: settings.autoplay_disable_on_interaction ?? defaultArgs.autoplayDisableOnInteraction,
            } : false,
            speed: settings.speed ?? defaultArgs.speed,
        });
    });


    new Swiper(".swiper-list-cat-index", {
        slidesPerView: 'auto',
        spaceBetween: 10,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        breakpoints: {
            0: {
                slidesPerView: 2.1,
            },
            575: {
                slidesPerView: 'auto',
            },
            768: {
                spaceBetween: 20
            }
        }
    });

    new Swiper(".swiper-list-cat-archive", {
        slidesPerView: 'auto',
        spaceBetween: 10,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        breakpoints: {
            768: {
                spaceBetween: 20
            }
        }
    });


    new Swiper(".swiper-brands", {
        slidesPerView: 'auto',
        spaceBetween: 10,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        breakpoints: {
            0: {
                slidesPerView: 2,
            },
            575: {
                slidesPerView: 'auto',
                spaceBetween: 24,
            },
        }
    });

    new Swiper(".swiper-blog", {
        spaceBetween: 10,
        slidesPerView: 'auto',

        breakpoints: {
            0: {
                // slidesPerView: 1,
            },
            370: {
            },
        }

    });

    new Swiper(".swiper-blog-slider", {
        slidesPerView: 'auto',
        spaceBetween: 10,
        breakpoints: {
            768: {
                spaceBetween: 30,
            }
        }
    });

    new Swiper(".swiper-related-product", {
        slidesPerView: 'auto',
        spaceBetween: 10,
        breakpoints: {
            768: {
                spaceBetween: 30,
            }
        }
    });

    var thumbSwiper = null;
    var thumbElement = document.querySelector(".swiper-gallery-thumb");

    if (thumbElement) {
        thumbSwiper = new Swiper(".swiper-gallery-thumb", {
            slidesPerView: 'auto',
            spaceBetween: 10,
            watchSlidesProgress: true,
        });
    }

    var gallerySwiper = new Swiper(".swiper-gallery", {
        slidesPerView: 'auto',
        pagination: {
            el: '.swiper-pagination',
        },
        thumbs: thumbSwiper ? {
            swiper: thumbSwiper,
        } : null,
    });

    new Swiper(".swiper-slider-search", {
        slidesPerView: 'auto',
        spaceBetween: 3,
        navigation: {
            nextEl: ".swiper-button-next-vip",
            prevEl: ".swiper-button-prev",
        },
    });

    new Swiper(".swiper-recent", {
        slidesPerView: 'auto',
        spaceBetween: 10,
        breakpoints: {
            1199: {
                spaceBetween: 20
            }
        }
    });

    new Swiper(".swiper-recent-blog", {
        slidesPerView: 'auto',
        spaceBetween: 10,
        breakpoints: {
            0: {
                slidesPerView: 1,

            },
            576: {
                slidesPerView: 'auto',
            },
            1199: {
                spaceBetween: 20,
                slidesPerView: 'auto',
            }
        }
    });


    if ($(".select-vip.normal").length) {
        if (window.innerWidth < 768) {

            $("body").on("click", '.select-vip.normal ul li', function () {
                $(".tab-title-select li").removeClass("active")
                $(this).addClass("active")
                let parent = $(this).parents(".select-vip")
                let text = $(this).text()
                parent.find(".text").html(text);
                parent.find('ul').fadeOut();
                parent.find(".select-onclick").removeClass("active")
            })

            $("body").on("click", '.select-vip.normal .select-onclick', function () {
                let list = $(this).siblings("ul")
                if ($(this).hasClass("active")) {
                    $(this).removeClass("active")
                    list.fadeOut();
                } else {
                    list.fadeIn()
                    $(this).addClass("active")
                }
            })
        }
    }

    $('.list-social-footer li').hover(function () {
        $(this).find('a').addClass('active');
        $(this).siblings().find('a').removeClass('active')
    });
    if (screen.width <= 992) {
        $('.list-social-footer li').find('a').removeClass('active');
        $('.list-social-footer li').hover(function () {
            $(this).find('a').removeClass('active')
        })
    }

    let element_parent = document.querySelector('.list-product-archive');
    if (element_parent) {
        let rect_parent = element_parent.getBoundingClientRect();

        let tolerance = 5;

        $(".item-product").each(function () {
            let rect = this.getBoundingClientRect();

            if (Math.abs(rect.top - rect_parent.top) <= tolerance) {
                $(this).addClass("top_direction");
            }

            if (Math.abs(rect.bottom - rect_parent.bottom) <= tolerance) {
                $(this).addClass("bottom_direction");
            }

            if (Math.abs(rect.left - rect_parent.left) <= tolerance) {
                $(this).addClass("left_direction");
            }

            if (Math.abs(rect.right - rect_parent.right) <= tolerance) {
                $(this).addClass("right_direction");
            }
        });
    }

    $("body").on("click", ".widget-title", function () {
        let element_show = $(this).siblings();
        let element_parent = $(this).parents(".widget");
        element_show.slideToggle();
        element_parent.toggleClass("accordion-open");
    });

    $("body").on("click", ".product-categories .item-parent-drop .icn", function () {
        $(this).parent().toggleClass("active");
        $(this).parent(".item-parent-drop").siblings(".children").slideToggle(300);
    });

    $(".box-search-widget input").on("keyup", function () {
        var filter = $(this).val()
        let ul_list = $(this).parents(".widget-side").find("ul li")
        ul_list.each(function () {
            var categoryText = $(this).text()
            if (categoryText.indexOf(filter) > -1) {
                $(this).show()
            } else {
                $(this).hide()
            }
        })
    })

    if ($(".content-post").length && $(".scroller-content").length)
        $(window).on('scroll', function () {
            var sectionOffset = $('.content-post').offset().top;
            var sectionHeight = $('.content-post').outerHeight();
            var windowHeight = $(window).height();
            var scrollPosition = $(window).scrollTop();

            if (scrollPosition >= sectionOffset && scrollPosition <= sectionOffset + sectionHeight - windowHeight) {
                var scrollInSection = scrollPosition - sectionOffset;
                var scrollPercentage = (scrollInSection / (sectionHeight - windowHeight)) * 100;
                $('.scroller-content').css('height', scrollPercentage + '%');
            } else if (scrollPosition < sectionOffset) {
                $('.scroller-content').css('height', '0%');
            } else if (scrollPosition > sectionOffset + sectionHeight - windowHeight) {
                $('.scroller-content').css('height', '100%');
            }
        });

    $(".item-accordion .head").click(function () {
        var $parent = $(this).parent();

        if ($parent.hasClass('active')) {
            $parent.find(".content").slideUp();
            $parent.removeClass('active');
        } else {
            $(this).parents().find(".item-accordion").removeClass('active');
            $(this).parents().find(".content").slideUp();

            $parent.find(".content").slideToggle();
            $parent.toggleClass('active');
        }
    });

    $(".slider").each(function () {
        var $slider = $(this);
        var $input = $slider.next("input");

        $slider.slider({
            min: 0,
            max: 5,
            value: 5,
            range: "min",
            slide: function (event, ui) {
                $input.val(ui.value);
            }
        });

        $input.val($slider.slider("value"));
    });

    $(".menu-tab-list li").hover(function () {
        let index = $(this).index();
        $(this).siblings().removeClass("active");
        $(this).addClass("active")
        $(`.list-tabs-menu .item-tab-menu`).removeClass("active");
        $(`.list-tabs-menu .item-tab-menu`).eq(index).addClass("active");
    });

    function setupToggle(openBtnSelector, boxSelector, closeBtnSelector = null) {
        var openBtn = $(openBtnSelector);
        var box = $(boxSelector);

        if (openBtn.length && box.length) {
            openBtn.on('click', function (e) {
                e.preventDefault();
                box.toggleClass('active');
            });

            $(document).on('click', function (event) {
                if (!box.is(event.target) && !box.has(event.target).length && !openBtn.is(event.target) && !openBtn.has(event.target).length) {
                    box.removeClass('active');
                }
            });

            if (closeBtnSelector) {
                var closeBtn = $(closeBtnSelector);
                if (closeBtn.length) {
                    closeBtn.on('click', function () {
                        box.removeClass('active');
                    });
                }
            }
        }
    }

    if ($(".sidebar-archive").length) {
        setupToggle('#filter', '.sidebar-archive');
    }

    if ($("#mini-cart-mobile").length) {
        setupToggle('#open-mini-cart-mobile', '#mini-cart-mobile', '.action-close-min-cart');
    }

    if ($("#menu-mobile").length) {
        setupToggle('.open-menu-mobile', '#menu-mobile', '.action-close-menu-mobile');
    }

    if ($("#search-mobile").length) {
        setupToggle('#open-search-mobile', '#search-mobile');
    }

    if ($("#menu-panel").length) {
        setupToggle('#open-menu-panel', '#menu-panel');
    }

    if ($("#mapcontact").length) {
        let lat = $("#mapcontact").attr("data-lat")
        let lng = $("#mapcontact").attr("data-lng")
        let pic = $("#mapcontact").attr("data-pic")
        var myIcon = L.icon({
            iconUrl: pic,
            iconRetinaUrl: pic,
            iconSize: [25, 41],
            iconAnchor: [12, 41],
            popupAnchor: [1, -34],
            tooltipAnchor: [16, -28],
            shadowUrl: '',
            shadowSize: [41, 41],
            shadowAnchor: [12, 41]
        });

        var mymap = L.map('mapcontact').setView([lat, lng], 16);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '',
            maxZoom: 18,
        }).addTo(mymap);
        L.marker([lat, lng], { icon: myIcon }).addTo(mymap)

    }

    if (document.querySelectorAll(".countdown-container").length > 0) {
        $(function () {
            $(".countdown-container").each(function () {
                var countdownElement = $(this);
                var data = countdownElement.attr("data-endtime") * 1000;
                var currentTime = new Date();
                if (currentTime > data) {
                    data = new Date(2024, 0, 1).getTime();
                }
                countdownElement.countdown({
                    timestamp: data,

                });
            });
        });
    }

    $(document).on("click", '.increase-quantity', function () {
        let product_id = $(this).parent().find(".quantity-input-js").data("product-id")
        stepQuantity(this, 1, product_id);
    })
    $(document).on("click", '.decrease-quantity', function () {
        let product_id = $(this).parent().find(".quantity-input-js").data("product-id")
        stepQuantity(this, -1, product_id);
    })


    function stepQuantity(button, direction, product_id) {
        const input = button.parentNode.querySelector('input[type=number]');
        if (input) {
            let currentValue = parseInt(input.value);
            const minValue = parseInt(input.min) || 0;
            const maxValue = parseInt(input.max) || Infinity;

            if (direction === 1 && currentValue < maxValue) {
                input.value = currentValue + 1;
                $(`.quantity-input-js[data-product-id=${product_id}]`).val(currentValue + 1)
            } else if (direction === -1 && currentValue > minValue) {
                input.value = currentValue - 1;
                $(`.quantity-input-js[data-product-id=${product_id}]`).val(currentValue - 1)
            }
        }
    }

    $(document.body).on('removed_from_cart', function (event, fragments, cart_hash, $button) {
        // Update cart count and content after item is removed
        let html_cart = fragments['div.widget_shopping_cart_content'];
        let count = 0;
        if ($(html_cart).find(".woocommerce-mini-cart li").length) {
            $(html_cart).find(".woocommerce-mini-cart li").each(function () {
                let product_id = $(this).data("product-id")
                let count_item = $(this).data("count")
                $(`.quantity-input-js[data-product-id=${product_id}]`).val(count_item)

                count += count_item;
            });
        }

        // Update the cart items count
        $(".count-items-cart").html(count)
        $(".append-mini-cart").html(html_cart)

        // Show success message
        Toast.fire({
            icon: "success",
            title: 'محصول با موفقیت از سبد خرید حذف شد',
        });
    });

    $(document.body).on('added_to_cart', function (event, fragments, cart_hash, $button) {
        $button.parents(".item-product").find(".add-to-cart-custom-loading").removeClass("loading")
        $button.parents(".item-product").addClass("active")
        let html_cart = fragments['div.widget_shopping_cart_content'];
        let count = 0;
        if ($(html_cart).find(".woocommerce-mini-cart li").length) {
            $(html_cart).find(".woocommerce-mini-cart li").each(function () {
                let product_id = $(this).data("product-id")
                let count_item = $(this).data("count")
                $(`.quantity-input-js[data-product-id=${product_id}]`).val(count_item)

                count += count_item;
            });
        }

        // Update the cart items count
        $(".count-items-cart").html(count)
        $(".append-mini-cart").html(html_cart)
        if (theme_redux.enable_sweetalert_toast != 0) {
            Toast.fire({
                icon: "success",
                title: 'با موفقیت به سبد خرید افزوده شد',
            });
        }


        if (theme_redux.enable_sweetalert_swal_fire != 0) {
            Swal.fire({
                title: "محصول به سبد خرید افزوده شد!",
                text: "آیا می‌خواهید به سبد خرید بروید یا به خرید ادامه دهید؟",
                icon: "success",
                showCancelButton: true,
                confirmButtonText: "رفتن به سبد خرید",
                cancelButtonText: "ادامه خرید",
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = theme_redux.cart_url; // Redirect to cart
                }
            });
        }
    });

    function change_quantity_cart(productID, quantity) {
        $.ajax({
            url: wc_add_to_cart_params.ajax_url,
            type: 'POST',
            data: {
                action: 'update_cart_quantity',
                product_id: productID,
                quantity: quantity
            },
            success: function (response) {
                let html_cart = response.content;
                let count = 0;
                let tempDiv = $('<div>').html(html_cart);
                let $cartItems = tempDiv.find(".woocommerce-mini-cart li");
                if ($cartItems.length) {
                    $cartItems.each(function () {
                        let product_id = $(this).data("product-id")
                        let count_item = $(this).data("count")
                        $(`.quantity-input-js[data-product-id=${product_id}]`).val(count_item)
                        count += count_item;
                    });
                }
                $(".count-items-cart").html(count)
                $('.append-mini-cart').html(response.content);

            }
        });
    }

    $(document).on('change', '.item-product .quantity-input-js', function () {
        var productID = $(this).data('product-id');
        var quantity = $(this).val();
        change_quantity_cart(productID, quantity)
    });

    var timeoutCartUpdate = "";
    $(document).on('click', '.item-product .decrease-quantity , .item-product .increase-quantity', function () {
        clearTimeout(timeoutCartUpdate)
        timeoutCartUpdate = setTimeout(() => {
            var input = $(this).parents(".quantity-card").find(".quantity-input-js")
            var productID = input.data('product-id');
            var quantity = input.val();
            change_quantity_cart(productID, quantity)
        }, 1000);
    });

    $(document).on("click", '.remove_from_cart_button', function (e) {
        let product_id = $(this).data("product_id")
        $(`.quantity-input-js[data-product-id=${product_id}]`).val(0)
        $(`.item-product[data-product-id=${product_id}]`).removeClass("active")

    })


    if ($(".box-all-search")) {
        function saveSearchToCookie(searchText) {
            if (!searchText) return; // اگر متن خالی است، خارج شو

            // بازیابی جستجوهای قبلی از کوکی
            const recentSearches = getSearchesFromCookie();

            // بررسی اگر جستجو از قبل در لیست وجود دارد، آن را اضافه نمی‌کنیم
            if (recentSearches.indexOf(searchText) === -1) {
                // اضافه کردن جستجوی جدید به ابتدای لیست
                recentSearches.unshift(searchText);

                // محدود کردن تعداد جستجوها به 5 مورد
                if (recentSearches.length > 5) {
                    recentSearches.pop();
                }

                // ذخیره لیست به‌روز شده در کوکی
                document.cookie = `recentSearches=${JSON.stringify(recentSearches)}; path=/; max-age=${7 * 24 * 60 * 60}`;
            }
        }

        // تابع کمکی برای خواندن جستجوهای ذخیره‌شده در کوکی
        function getSearchesFromCookie() {
            const cookies = document.cookie.split('; ');
            const recentSearchCookie = cookies.find(row => row.startsWith('recentSearches='));

            // اگر کوکی جستجوها موجود است، آن را تجزیه کن و برگردان، در غیر این صورت آرایه خالی برگردان
            return recentSearchCookie ? JSON.parse(recentSearchCookie.split('=')[1]) : [];
        }

        function get_result_search_ajax(args) {
            $.ajax(theme_data.ajax_url, {
                dataType: 'json',
                data: args.data,
                method: "POST",
                async: false,
                success: function (data, status, xhr) {
                    $(".before-search").hide()
                    $(".after-search").html(data.html).show()
                    new Swiper(".swiper-product-search", {
                        slidesPerView: 'auto',
                        spaceBetween: 7,
                    });
                },
                error: function (jqXhr, textStatus, errorMessage) { // error callback 

                }, complete: function () {
                    $(".box-all-search .search-loading").hide()
                },
            })
        }

        var AjaxSearchTimeOut;
        $(".box-all-search input").on('keypress keydown keyup', function () {
            $(".box-all-search .search-loading").show()
            let search_word = $(this).val();
            if (search_word.length > 2) {
                clearTimeout(AjaxSearchTimeOut);
                AjaxSearchTimeOut = setTimeout(() => {
                    saveSearchToCookie(search_word)
                    args = {
                        'data': {
                            'action': "get_result_search_ajax",
                            'search': search_word,
                        },
                    }
                    get_result_search_ajax(args);
                }, 500);
            }
        });

    }

    if ($(".rating-post").length) {
        function ajaxRatingPost(args) {
            $.ajax(theme_data.ajax_url, {
                dataType: 'json',
                data: args.data,
                async: false,
                method: "POST",
                success: function (data, status, xhr) {
                    if (data.message) {
                        Toast.fire({
                            icon: "success",
                            title: data.message,
                        });
                    }
                    $(".avgRating").html(data.avg)
                    $(".countRating").html(data.count)
                },
                error: function (jqXhr, textStatus, errorMessage) { // error callback 
                }
            })
        }

        $('body').on('click', ".rating-post .item-star", function (e) {
            e.preventDefault();
            let count = $(this).attr("data-count")
            let post_id = $(this).parents(".rating-post").attr("data-id")
            let data = {
                'data': {
                    "action": 'set_rating_post',
                    'post_id': post_id,
                    'rate_count': count
                }
            }
            ajaxRatingPost(data)
        });

        var stars = $(".item-star");
        stars.hover(function () {
            if (!$(this).parent().hasClass("clicked")) {
                $(this).addClass("hover-color-change");
                $(this).prevAll().addClass("hover-color-change");
            }
        }, function () {
            if (!$(this).parent().hasClass("clicked")) {
                stars.removeClass("hover-color-change");
            }
        });

        stars.click(function () {
            if (!$(this).parent().hasClass("clicked")) {
                $(this).addClass("click-color-change");
                $(this).prevAll().addClass("click-color-change");
                stars.removeClass("hover-color-change");
                $(this).parents().addClass("clicked")
            }
        });
    }

    function copyElementText(textElement, msg) {
        let textAreaElem = document.createElement("textarea");
        document.body.appendChild(textAreaElem);
        textAreaElem.value = $.trim(textElement);
        textAreaElem.select();
        document.execCommand("copy");
        document.body.removeChild(textAreaElem);
        Toast.fire({
            icon: "success",
            title: msg,
        });
    }

    $(".copy-link").click(function (params) {
        let content = $(this).data("url");
        let msg = "لینک با موفقیت کپی شد";
        copyElementText(content, msg);
    })

    //start Ajax
    if ($(".CommentLike").length) {
        $(".CommentLike").click(function () {
            let comment_id = $(this).attr("data-id")
            let parent = $(this)
            let data = {
                "action": 'set_comment_like',
                'comment_id': comment_id,
            }

            $.ajax(theme_data.ajax_url, {
                dataType: 'json',
                data,
                async: false,
                method: "POST",
                success: function (data, status, xhr) {
                    if (data.count) {
                        parent.find('.like-count').html(data.count);
                        parent.addClass("active")
                    }
                    if (data.message) {
                        Toast.fire({
                            icon: "success",
                            title: data.message,
                        });
                    }
                },
                error: function (jqXhr, textStatus, errorMessage) { // error callback 
                }
            })
        })
    }

    //function favorite
    var ajax_enable = true;

    function add_list_user_count(args) {
        $.ajax({
            url: theme_data.ajax_url,
            type: "POST",
            dataType: "json",
            data: {
                action: "action_user_list_id_count",
                id: args.id,
                type: args.type,
            },
            success: function (res) {
                Toast.fire({
                    icon: "success",
                    title: res.msg,
                });

                if (res.status == "add") {
                    $(args.active_element).addClass("active");
                } else {
                    $(args.active_element).removeClass("active");
                }
                if ($(args.count).length) {
                    $(args.count).html(res.count);
                }
                ajax_enable = true;
            },
            error: function (error) {
                Toast.fire({
                    icon: "success",
                    title: "لطفا ابتدا وارد شوید",
                });
                ajax_enable = true;
            },
        });
    }

    $(".favorites-event-post").click(function (e) {
        e.stopPropagation();
        let id = $("body").data("product-id");
        let args = {
            "id": id,
            "type": "post",
            "active_element": $(this),
        };

        add_list_user_count(args);
    });

    $(".remove-item-panel").click(function () {
        $(this).parents(".item-parent").remove()
    })

    if ($.fn.selectWoo) {
        $(".variations select").selectWoo({
            width: "100%",
            minimumResultsForSearch: -1,
            placeholder: "انتخاب محصول",
        });
    }

    $(".scrollToTabSingle").click(function (e) {
        e.preventDefault();
        var tabTarget = $(this).data('tab');

        // Trigger the click event on the corresponding li element
        $(`li[aria-controls='${tabTarget.substring(1)}']`).find("a").click();

        // Target the div based on the tab ID
        var targetOffset = $('div' + tabTarget);

        if (targetOffset.length) {
            let top = targetOffset.offset().top;

            // Check the screen width
            let offsetValue = $(window).width() <= 638 ? 170 : 80;

            // Animate the scroll with the appropriate offset
            $('html, body').animate({
                scrollTop: top - offsetValue // Use -170 for smaller screens, -50 for larger screens
            }, 800); // Duration of the scroll animation
        }
    });

    $(".share-single-event").click(function name(params) {
        let url = $(this).data("url");
        let title = $(this).data("title");
        let homeurl = $(this).data("homeurl");

        Swal.fire({
            customClass: {
                container: 'share_social_media_swal2_popup ',
                popup: '...',
                title: '...',
                closeButton: '...',
            },
            title: '<strong>به اشتراک گذاری</strong>',
            html: `
        <div class="swal-list-social-pop">
          <a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u=${url}&amp;t=${title}" title="Share on Facebook" target="_blank" rel="noreferrer nofollow noopener">
            فیسبوک
          </a>
          <a class="telegram" href="https://telegram.me/share/url?url=${url}&amp;text=${title}:${homeurl}" title="telegram" rel="noreferrer nofollow noopener" target="_blank">
          تلگرام
          </a>
          <a class="whatsapp" href="whatsapp://send?text=${url}" data-action="share/whatsapp/share" title="whatsapp" rel="noreferrer nofollow noopener" target="_blank">    
            واتساپ
          </a>
          <a class="twitter" href="https://twitter.com/intent/tweet?source=${url}&amp;text=${title}:${homeurl}" target="_blank" title="Tweet" rel="noreferrer nofollow noopener">
                توییتر
          </a>
          <a class="linkedin" href="http://www.linkedin.com/shareArticle?mini=true&url=${url}&title=${title}&source=${homeurl}" title="Share on linkedin" rel="noreferrer nofollow noopener" target="_blank" >
                لینکدین
          </a>
        </div>
        `,
            showCloseButton: true,
            confirmButtonText: 'خروج',
            showCancelButton: false
        })
    })

    /*
     * button-switch
     */

    $(".switch-button .btn").click(function () {
        $(this).toggleClass("switch");
    });

    $(".open-coupon").click(function (e) {
        e.preventDefault();
        $(".coupon-form").slideToggle()
    })

    if ($(".glightbox").length) {
        GLightbox({
            touchNavigation: true,
            loop: true,
            autoplayVideos: true
        });
    }

    $(".add_to_cart_button").click(function () {
        $(this).find(".add-to-cart-custom-loading").addClass("loading")
    })

    function validatePhoneNumber(input_str) {
        input_str = convertPersianToEnglishNumbers(input_str);
        let regex = /^((\+98|0)9\d{9})$/;
        return regex.test(input_str);
    }

    function convertPersianToEnglishNumbers(input_str) {
        const persianNumbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        const englishNumbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        for (let i = 0; i < persianNumbers.length; i++) {
            input_str = input_str.replace(new RegExp(persianNumbers[i], 'g'), englishNumbers[i]);
        }
        return input_str;
    }

    if ($(".login-info").length) {

        function focusInput() {
            $(this).find(".focus-js").focus()
        }

        //auth
        function updateCountdown(startTime, duration, element, timer) {
            const currentTime = Date.now();
            const elapsed = currentTime - startTime;
            const remaining = Math.max(0, duration - elapsed);

            const minutes = Math.floor(remaining / (60 * 1000));
            const seconds = Math.floor((remaining % (60 * 1000)) / 1000);

            $(element).html(`${minutes} : ${seconds < 10 ? '0' : ''}${seconds}`)

            if (remaining === 0) {
                clearInterval(timer);
            }
        }

        function timer_login(time = null) {
            const startTime = Date.now();
            const duration = time ? time * 1000 : 2 * 60 * 1000;
            let timer = null;
            updateCountdown(startTime, duration, '.countdown', timer);
            timer = setInterval(function () {
                updateCountdown(startTime, duration, '.countdown', timer);
            }, 1000);
        }

        function send_code_mobile(args) {
            let data_obj = args.data;
            $.ajax(theme_data.ajax_url, {
                dataType: 'json',
                data: {
                    'action': 'send_code_mobile',
                    'data': data_obj
                },
                async: false,
                method: "POST",
                success: function (data, status, xhr) {
                    if (data.success == true) {
                        timer_login()
                        Toast.fire({
                            icon: "success",
                            title: data.msg,
                        });
                    }
                },
                error: function (jqXhr, textStatus, errorMessage) { // error callback 
                }
            })
        }

        function verification_code(args, callback) {
            let data_obj = args.data;
            $.ajax(theme_data.ajax_url, {
                dataType: 'json',
                data: {
                    'action': 'verification_code',
                    'data': data_obj
                },
                method: "POST",
                success: function (data, status, xhr) {
                    callback(data); // Pass data to the callback function
                },
                error: function (jqXhr, textStatus, errorMessage) {
                    // Handle error if needed
                }
            });
        }

        function verification_password(args) {
            let data_obj = args.data;
            $.ajax(theme_data.ajax_url, {
                dataType: 'json',
                data: {
                    'action': 'verification_pass',
                    'data': data_obj
                },
                async: false,
                method: "POST",
                success: function (data, status, xhr) {
                    if (data.success == true) {
                        location.reload();
                    }
                    Toast.fire({
                        icon: "success",
                        title: data.msg,
                    });
                },
                error: function (jqXhr, textStatus, errorMessage) { // error callback 
                }
            })
        }

        function send_code_again() {
            $.ajax(theme_data.ajax_url, {
                dataType: 'json',
                data: {
                    'action': 'send_code_again',
                },
                async: false,
                method: "POST",
                success: function (data, status, xhr) {
                    if (data.success == true) {
                        timer_login()
                    }
                    Toast.fire({
                        icon: "success",
                        title: data.msg,
                    });
                },
                error: function (jqXhr, textStatus, errorMessage) { // error callback 
                }
            })
        }

        $(".login-c form").submit(function (e) {
            e.preventDefault();
            let $form = $(this);
            let mobile = $(this).find("input[name=mobile]").val()
            if (!validatePhoneNumber(mobile)) {
                Toast.fire({
                    icon: "success",
                    title: "فرمت شماره موبایل اشتباه است",
                });
                return;
            }
            $form.css("opacity", 0.5);
            $.ajax(theme_data.ajax_url, {
                dataType: 'json',
                data: {
                    'action': 'record_mobile_login',
                    'data': {
                        mobile
                    }
                },
                method: "POST",
                success: function (data, status, xhr) {
                    $form.css("opacity", 1);
                    $(".mobile-number").html(mobile)
                    if (data.user_exists) {
                        $(".login-c").hide();
                        $(".login-password-c").show(focusInput);
                    } else {
                        if (data.send_code_result.success) {
                            timer_login()
                        }
                        $(".login-c").hide();
                        $(".login-code-c").show(focusInput);
                    }
                },
                error: function (jqXhr, textStatus, errorMessage) { // error callback 
                    $form.css("opacity", 1);
                }
            })
        })

        $(".login-password-c .send-code").click(function (e) {
            e.preventDefault();
            let mobile = $("input[name=mobile]").val()
            let args = {
                'data': {
                    mobile
                }
            }
            $(".login-password-c").hide();
            $(".login-code-c").show(focusInput);
            send_code_mobile(args)
        })

        $(".login-code-c form").submit(function (e) {
            e.preventDefault();
            let $form = $(this);
            let code = '';
            $(".list-code input").each(function () {
                let item_code = $(this).val()
                code = code + item_code
            })
            if (code.length == 4) {
                $form.css("opacity", 0.5);
                let args = {
                    'data': {
                        code
                    }
                }

                verification_code(args, function (data) {
                    $form.css("opacity", 1);
                    if (data.success == true && !$(".cart-page").length) {
                        if (data.type == 'login') {
                        } else if (data.type == 'register') {
                            $(".login-c").siblings().hide();
                            // $(".login-password-name").show(focusInput);
                        }
                        location.reload();
                    }
                    if (data.success == true && $(".cart-page").length) {
                        $(".submit_order button").click()
                    }
                    Toast.fire({
                        icon: "success",
                        title: data.msg,
                    });
                });

            }
        })

        $(".login-password-c form").submit(function (e) {
            e.preventDefault();
            let password = $(".login-password-c").find("input[name=password]").val()
            if (password != 0) {
                let args = {
                    'data': {
                        password,
                    }
                }
                verification_password(args)
            }
        })

        $(".login-code-c .send_code_again").click(function (e) {
            e.preventDefault();
            send_code_again()
        })

        $(".coming-back").click(function () {
            $(".login-c").siblings().hide()
            $(".login-c").show(focusInput)
        })

        if ($(".countdown").length) {
            time = $(".countdown").attr("data-time");
            if (time) {
                timer_login(time)
            }
        }

        $(".login-password-name form").submit(function (e) {
            if (!checkPasswordStrengthLive()) {
                e.preventDefault();
            }
        })

        let inputs = $('.list-code .numeric-input');
        inputs.on('input', function () {
            const allFilled = inputs.toArray().every(input => $(input).val());
            if (allFilled) {
                $(this).parents("form").submit()
            }
        });

        inputs.on('keydown', function (event) {
            if (event.which === 8) {
                const currentInput = $(this);
                const currentIndex = inputs.index(currentInput);
                if (currentIndex > 0) {
                    currentInput.val('');
                    inputs.eq(currentIndex - 1).focus();
                }
            }
        });

        $(".numeric-input").first().focus()
        $('.numeric-input').on('input', function (e) {
            $(this).val(function (i, val) {
                return val.replace(/[^0-9]/g, '');
            });

            var num = parseInt($(this).val());
            if (isNaN(num) || num < 0 || num > 9) {
                $(this).val('');
            }

            if ($(this).val().length === 1) {
                $(this).next('.numeric-input').empty();
                $(this).next('.numeric-input').focus();
            }
        });
    }

    $(".mobile-menu .menu-item-has-children").click(function (e) {
        e.stopPropagation();
        if ($(this).hasClass("active")) {
            $(this).removeClass("active");
            $(this).children(".sub-menu").slideUp();
        } else {
            $(this).addClass("active");
            $(this).children(".sub-menu").slideDown();
        }
    });

    if ($(".section-slider-product-tab").length) {
        $(".section-slider-product-tab input").on("keyup", function () {
            var searchTerm = $(this).val().toLowerCase();
            var activeTabContent = $(".section-slider-product-tab .tab-content").filter(function () {
                return $(this).css("display") === "block";
            });
            activeTabContent.find(".swiper-slide").each(function () {
                var productTitle = $(this).find(".title").text().toLowerCase();

                if (productTitle.includes(searchTerm)) {
                    $(this).css("display", "block");
                } else {
                    $(this).css("display", "none");
                }
            });
        });
    }

    if ($(".parallax-item").length) {
        const parallaxItems = document.querySelectorAll('.parallax-item');
        document.addEventListener('mousemove', function (e) {
            let x = (window.innerWidth - e.pageX * 2) / 100;
            let y = (window.innerHeight - e.pageY * 2) / 100;

            parallaxItems.forEach(item => {
                item.style.transform = `translate(${x}px, ${y}px)`;
            });
        });
    }

    if ($(".woocommerce-shop").length || $(".tax-product_cat").length) {
        function init_price_filter() {
            $('input#min_price, input#max_price').hide();
            $('.price_slider, .price_label').show();

            var min_price = $('.price_slider_amount #min_price').data('min'),
                max_price = $('.price_slider_amount #max_price').data('max'),
                step = $('.price_slider_amount').data('step') || 1,
                current_min_price = $('.price_slider_amount #min_price').val(),
                current_max_price = $('.price_slider_amount #max_price').val();

            $('.price_slider:not(.ui-slider)').slider({
                range: true,
                animate: true,
                min: min_price,
                max: max_price,
                step: step,
                values: [current_min_price, current_max_price],
                create: function () {

                    $('.price_slider_amount #min_price').val(current_min_price);
                    $('.price_slider_amount #max_price').val(current_max_price);

                    $(document.body).trigger('price_slider_create', [current_min_price, current_max_price]);
                },
                slide: function (event, ui) {

                    $('input#min_price').val(ui.values[0]);
                    $('input#max_price').val(ui.values[1]);

                    $(document.body).trigger('price_slider_slide', [ui.values[0], ui.values[1]]);
                },
                change: function (event, ui) {

                    $(document.body).trigger('price_slider_change', [ui.values[0], ui.values[1]]);
                }
            });
        }

        function filterProducts(url) {
            $("#nxLoading").show()
            $.ajax({
                url: url,
                type: 'GET',
                success: function (response) {
                    var list_product = $(response).find('.list-product-archive');
                    var sidebar = $(response).find('#sidebar-archive');
                    var pagination = $(response).find('.box_woocommerce_pagination');
                    var list_orderby = $(response).find('.list-tab-archive-shop');
                    let count_fillter_active = sidebar.find(".widget_layered_nav_filters ul li").length;
                    $('.list-product-archive').html(list_product.html());
                    $('#sidebar-archive').html(sidebar.html());
                    $('.box_woocommerce_pagination').html(pagination.html());
                    $('.list-tab-archive-shop').html(list_orderby.html());

                    history.pushState(null, '', url);

                    var offsetValue = window.innerWidth < 768 ? 100 : 10;
                    $('html, body').animate({
                        scrollTop: $('.list-product-archive').offset().top - offsetValue
                    }, 800);

                    init_price_filter();
                    $(document.body).on('init_price_filter', init_price_filter);

                    $("#nxLoading").hide()
                    if (count_fillter_active) {
                        $(".count-items-fillter").html(count_fillter_active)
                        $(".count-items-fillter").show()
                    } else {
                        $(".count-items-fillter").hide()
                    }
                },
                error: function () {
                }
            });
        }

        $('body').on('click', ".woocommerce-widget-layered-nav a", function (e) {
            e.preventDefault();
            var url = $(this).attr('href');
            filterProducts(url)
        });

        $('body').on('click', ".box_woocommerce_pagination a", function (e) {
            e.preventDefault();
            var url = $(this).attr('href');
            filterProducts(url)
        });

        $('body').on('click', ".list-tab-archive-shop a", function (e) {
            e.preventDefault();
            var url = $(this).attr('href');
            filterProducts(url)
        });

        $('body').on('click', '.widget_layered_nav_filters a', function (e) {
            e.preventDefault();
            var url = $(this).attr('href');
            filterProducts(url)
        });

        $('body').on('submit', '.widget_price_filter form', function (e) {
            e.preventDefault();
            var formData = $(this).serialize();
            var baseUrl = $(this).attr('action');
            var fullUrl = baseUrl + '?' + formData;
            filterProducts(fullUrl)
        });

        $('body').on('input', '.woocommerce-ordering-side input', function (e) {
            e.preventDefault();
            var params = {};
            var formData = $(this).serializeArray();
            $.each(formData, function (_, field) {
                params[field.name] = field.value;
            });

            var baseUrl = $(this).attr('action') || window.location.href;
            var fullUrl = baseUrl.split('?')[0] + '?' + $.param(params);

            filterProducts(fullUrl)
        });
    }

    const section = document.querySelector('.swiper-hero');
    if (section) {
        section.addEventListener('mousemove', (event) => {
            const sectionRect = section.getBoundingClientRect();
            const sectionCenter = sectionRect.left + sectionRect.width / 2;

            section.classList.remove('left-navigate', 'right-navigate');

            if (event.clientX < sectionCenter) {
                section.classList.add('left-navigate');
            } else {
                section.classList.add('right-navigate');
            }
        });
    }

    if ($(".LikePost").length) {
        $('body').on('click', ".LikePost , .DisLikePost", function (e) {
            e.preventDefault();
            $(this).addClass("active")
            let item = $(this)

            let post_id = $(this).attr("data-id")
            let status = $(this).attr("data-type")
            let parent = $(this)
            let data = {
                'data': {
                    "action": 'set_post_like',
                    'post_id': post_id,
                    status
                }
            }

            $.ajax(theme_data.ajax_url, {
                dataType: 'json',
                data: data.data,
                async: false,
                method: "POST",
                success: function (data, status, xhr) {
                    Toast.fire({
                        icon: "success",
                        title: data.message,
                    });

                    if (data.message) {
                        Toast.fire({
                            icon: "success",
                            title: data.message,
                        });
                        if (item.find(".count").length) {
                            item.find(".count").text(data.count)
                        }
                    }
                },
                error: function (jqXhr, textStatus, errorMessage) { // error callback 
                }
            })
        });
    }

    $(".woocommerce-info .showlogin").click(function () {
        $(".woocommerce-form-login").slideToggle()
    })


    $(".open-login-checkout").click(function () {
        $("#mask").show();
        $(".box-poupup-login").addClass("active")
    })

    $("#mask").click(function () {
        $("#mask").hide();
        $(".box-poupup-login").removeClass("active")
    })


    if ($(".woocommerce-billing-fields__field-wrapper").length) {
        $('.form-row[data-priority]').each(function () {
            var priority = $(this).data('priority');

            if (priority) {
                $(this).css('order', priority);
            }
        });
    }



    jQuery(document).ready(function ($) {
        $('form.variations_form').on('change', 'select', function () {
            setTimeout(function () {
                var $form = $('form.variations_form');
                var variationId = $form.find('input.variation_id').val() || '';
                var productId = $form.find('input[name="product_id"]').val() || '';

                if (variationId && productId && variationId !== productId) {
                    $.ajax({
                        url: theme_data.ajax_url,
                        type: 'POST',
                        data: {
                            action: 'update_selected_variation',
                            variation_id: variationId,
                            product_id: productId,
                        },
                        success: function (response) {
                            if (response.success) {
                                $('.sidebar-shop-container').html(response.data.sidebar_content);
                            } else {
                                console.log("Error:", response.data.message);
                            }
                        }
                    });
                }
            }, 500);
        });
    });


    // Get the first Swiper slide
    var $gallery = $('.swiper-gallery .swiper-wrapper .swiper-slide').first();
    var isPlaceholder = false;

    // If no Swiper slide exists, use the WooCommerce placeholder
    if(!$gallery.length){
        $gallery = $('.woocommerce-product-gallery__image--placeholder');
        isPlaceholder = true; // Flag to indicate placeholder is used
    }

    var $img = $gallery.find('img');
    var originalSrc = $img.attr('src');
    var originalFullSrc = $gallery.find('a.glightbox').attr('href') || originalSrc;

    // When a variation is selected
    $('form.variations_form').on('found_variation', function(event, variation){
        if(variation && variation.image && variation.image.src){
            var newSrc = variation.image.src;
            var newFullSrc = variation.image.full_src;

            // Replace the image
            $img.attr('src', newSrc).attr('data-full', newFullSrc);

            // Remove srcset and sizes so the image displays correctly
            $img.removeAttr('srcset').removeAttr('sizes');

            // Update lightbox href if it exists
            if($gallery.find('a.glightbox').length){
                $gallery.find('a.glightbox').attr('href', newFullSrc);
            }

            // Update Swiper if this is not a placeholder
            if(!isPlaceholder && $gallery.closest('.swiper').length){
                $gallery.closest('.swiper')[0].swiper.update();
            }
        }
    });

    // When variations are reset
    $('form.variations_form').on('reset_data', function(){
        $img.attr('src', originalSrc).attr('data-full', originalFullSrc);
        $img.removeAttr('srcset').removeAttr('sizes');

        if($gallery.find('a.glightbox').length){
            $gallery.find('a.glightbox').attr('href', originalFullSrc);
        }

        if(!isPlaceholder && $gallery.closest('.swiper').length){
            $gallery.closest('.swiper')[0].swiper.update();
        }
    });


    if(theme_redux.single_product_ajax_add_to_cart  != 0 ){
        $('form.cart:not(.variations_form)').on('submit', function(e){
            e.preventDefault();

            var $form = $(this);
            var product_id = $form.find('button[name="add-to-cart"]').val();
            var quantity = $form.find('input[name="quantity"]').val() || 1;
            
            $.ajax({
                type: 'POST',
                url: '/shopi-v-05/?wc-ajax=add_to_cart',
                data: {
                    product_id: product_id,
                    quantity: quantity
                },
                success: function(response){       
                    if (response.error) {
                        Toast.fire({
                            icon: "error",
                            title: response.message || "مشکلی در افزودن به سبد خرید وجود دارد",
                        });
                    }
                    $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, $form]);
                }
            });
        });

        $('form.variations_form').on('submit', function(e){
            e.preventDefault();

            var $form = $(this);
            var product_id = $form.find('input[name="variation_id"]').val();
            var quantity = $form.find('input[name="quantity"]').val() || 1;

            $.ajax({
                type: 'POST',
                url: '/shopi-v-05/?wc-ajax=add_to_cart', 
                data: {
                    product_id: product_id,
                    quantity: quantity
                },
                success: function(response){           
                        if (response.error) {
                            Toast.fire({
                                icon: "error",
                                title: response.message || "مشکلی در افزودن به سبد خرید وجود دارد",
                            });
                        }
                    $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, $form]);
                }
            });
        });
    }
});

