<?php
defined('ABSPATH') || exit;
global $post;
if (!comments_open()) {
    return;
}
?>
<div id="reviews" class="woocommerce-Reviews">
    <div id="comments" class="mb-6">
        <div class="flex items-center gap-9 mb-8 a-md:gap-3 a-md:flex-wrap a-md:mb-4">
            <span class='title-content-tab text-[20px] text-[#495666] font-bold a-md:text-[16px]'>نظرات کاربران</span>
            <ul class="flex items-center gap-7 grow list-tab-comment a-md:gap-3 a-md:order-3 tab:w-full">
                <li><a href="<?= add_query_arg('sort', 'newest') ?>" class='text-[14px] text-[#a2acb7] font-bold item a-md:text-[13px] <?= isset($_GET['sort']) && $_GET['sort'] == 'newest' ? 'active' : '' ?>'>جدیدترین
                        ها</a></li>
                <li><a href="<?= add_query_arg('sort', 'popular') ?>" class='text-[14px] text-[#a2acb7] font-bold item a-md:text-[13px] <?= isset($_GET['sort']) && $_GET['sort'] == 'popular' ? 'active' : '' ?>'>محبوبترین
                        ها</a></li>
            </ul>
            <svg class='fill-[#969fae]  w-[14px] h-[14px] mr-auto'>
                <use xlink:href='#comment'>
            </svg>
        </div>

        <?php if (get_option('woocommerce_review_rating_verification_required') === 'no' || wc_customer_bought_product('', get_current_user_id(), $post->ID)) : ?>
            <div id="review_form_wrapper">
                <div id="review_form" class="review-form border border-[#e9edf2] rounded-[9px] px-10 py-11 mb-5 a-lg:p-6 a-sm:px-4">
                    <?php
                    $commenter    = wp_get_current_commenter();
                    $comment_form = array(
                        /* translators: %s is product title */
                        'title_reply'         => '',
                        /* translators: %s is product title */
                        'title_reply_to'      => esc_html__('Leave a Reply to %s', 'woocommerce'),
                        'title_reply_before'  => '',
                        'title_reply_after'   => '',
                        'comment_notes_before' => '',
                        'comment_notes_after' => '',
                        'label_submit' => apply_filters('af_comment_form_button_text', 'ثبـت'),
                        'logged_in_as'        => '',
                        'comment_field'       => '',
                        'submit_field' => '<p class="submit_field_box_comment ">%1$s %2$s</p>'
                    );

                    $name_email_required = (bool) get_option('require_name_email', 1);
                    $fields              = array(
                        'author' => array(
                            'label'    => __('Name', 'woocommerce'),
                            'type'     => 'text',
                            'value'    => $commenter['comment_author'],
                            'required' => $name_email_required,
                            'svg' => '<svg class="fill-[#969fae] w-[11px] h-[13px]">
                                                <use xlink:href="#user-icon">
                                            </use></svg>'
                        ),
                        'email'  => array(
                            'label'    => __('Email', 'woocommerce'),
                            'type'     => 'email',
                            'value'    => $commenter['comment_author_email'],
                            'required' => $name_email_required,
                            'svg' => '<svg class="fill-[#969fae] w-[11px] h-[13px]">
                                                <use xlink:href="#mobile-icon">
                                            </use></svg>'

                        ),
                    );

                    $comment_form['fields'] = array();

                    foreach ($fields as $key => $field) {
                        $field_html  = '<div class="comment-form-' . esc_attr($key) . '">';

                        if ($field['required']) {
                            // $field_html .= '&nbsp;<span class="required">*</span>';
                        }
                        $placeholder = apply_filters( 'af_comment_form_placeholder_' . $key, $field['label'], $field );
                        $field_html .= $field['svg'] . '<input class="' . @esc_html($field['class']) . '" placeholder="' . esc_attr($placeholder) . '" id="' . esc_attr($key) . '" name="' . esc_attr($key) . '" type="' . esc_attr($field['type']) . '" value="' . esc_attr($field['value']) . '" size="30" ' . ($field['required'] ? 'required' : '') . ' /></div>';

                        $comment_form['fields'][$key] = $field_html;
                    }

                    $account_page_url = wc_get_page_permalink('myaccount');
                    if ($account_page_url) {
                        /* translators: %s opening and closing link tags respectively */
                        $comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf(esc_html__('You must be %1$slogged in%2$s to post a review.', 'woocommerce'), '<a href="' . esc_url($account_page_url) . '">', '</a>') . '</p>';
                    }

                    $comment_placeholder = apply_filters(
                        'af_comment_form_placeholder_comment', 
                        'متن دیدگاه خود را بنویسید'
                    );

                    $comment_form['comment_field'] = '<p class="comment-form-comment textarea-wrap">
                        <textarea class="" placeholder="' . esc_attr($comment_placeholder) . '" id="comment" name="comment" cols="45" rows="5" required></textarea>
                    </p>';

                    $comment_form["fields"]["cookies"] = '';
                    ?>
                    <span class="title-c text-[18px] text-[#495666] font-bold flex mb-8 a-sm:mb-3 a-sm:text-[16px]">ارسال دیدگاه</span>
                    <?php comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form)); ?>
                </div>
            </div>
        <?php else : ?>
            <p class="woocommerce-verification-required"><?php esc_html_e('Only logged in customers who have purchased this product may leave a review.', 'woocommerce'); ?></p>
        <?php endif; ?>

        <?php if (have_comments()) : ?>
            <ol class="commentlist comments singel-product-cm">
                <?php wp_list_comments(apply_filters('woocommerce_product_review_list_args', array('callback' => 'woocommerce_comments'))); ?>
            </ol>

            <?php
            if (get_comment_pages_count() > 1 && get_option('page_comments')) :
                echo '<nav class="comment-pagination">';
                paginate_comments_links(
                    apply_filters(
                        'woocommerce_comment_pagination_args',
                        array(
                            'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
                            'next_text' => is_rtl() ? '&larr;' : '&rarr;',
                            'type'      => '',
                        )
                    )
                );
                echo '</nav>';
            endif;
            ?>
        <?php else : ?>
            <div class="no-comment-box flex flex-col items-center justify-center h-[341px] bg-white rounded-[9px]  border-[1px] border-[#e9eef4] mb-[25px] tab:h-[140px]">
            	<div class="w-max">
                    <span class="title text-[23px] text-[#6c6c6c] leading-[30px] font-bold text-center">
                        هنـوز دیدگاهی ثبــت نشــده
                    </span>

                    <span class="subtitle text-[13px] text-[#9fafc5] table w-max mr-auto">
                        اولیــن باشــید شــما
                    </span>
                </div>
                <!-- .item-wrap -->
            </div>
        <?php endif; ?>
    </div>
    <div class="clear"></div>
</div>