<?php
//After setup theme
add_action('after_setup_theme', 'ft_theme_setup');
function ft_theme_setup() {
    add_theme_support('title-tag');
    add_theme_support('widgets');
    add_theme_support('post-thumbnails');
    add_theme_support('woocommerce');
}

//Create Themeoption for general setting
add_action('acf/init', 'ft_theme_op_init', 99);
function ft_theme_op_init() {
    if (function_exists('acf_add_options_page')) {
        $option_page = acf_add_options_page(
            array(
                'page_title' => __('تنظیمات عمومی پوسته'),
                'menu_title' => __('تنظیمات پوسته'),
                'menu_slug' => 'theme-general-settings',
                'capability' => 'edit_posts',
                'redirect' => false
            )
        );
    }
}

if (!function_exists('ahanup_register_nav_menu')) {

    function ahanup_register_nav_menu() {
        register_nav_menus(array(
            'mobile-menu' => __('Menu Mobile', 'text_domain'),
            'mega-menu' => __('Mega Menu', 'text_domain'),
        ));
    }
    add_action('after_setup_theme', 'ahanup_register_nav_menu', 0);
}

add_filter('rank_math/frontend/breadcrumb/settings', function ($settings) {
    $settings = array(
        'separator'      => '<i class="icon-arrrow-left"></i>',
    );
    return $settings;
});

/**
 * Filter to change breadcrumb strings.
 *
 * @param  array $settings Breadcrumb Strings.
 * @return array $strings.
 */
add_filter('rank_math/frontend/breadcrumb/strings', function ($strings) {
    if (get_post_type() == 'product') {
        $strings = array(
            'prefix' => '<i class="icon-home home-breadcrumb-icon"></i>',
        );
    }
    return $strings;
});



// Output head content
add_action('wp_head', function () {
    $head_content = get_option(SHOPI_OPTION)['head_content'] ?? '';
    if (!empty($head_content)) {
        echo $head_content;
    }
});

// Output footer content
add_action('wp_footer', function () {
    $footer_content = get_option(SHOPI_OPTION)['footer_content'] ?? '';
    if (!empty($footer_content)) {
        echo $footer_content;
    }
});

// Output custom CSS
add_action('wp_head', function () {
    $custom_css = get_option(SHOPI_OPTION)['advanced_css'] ?? '';
    if (!empty($custom_css)) {
        echo '<style>' . $custom_css . '</style>';
    }
});

// Output custom JavaScript
add_action('wp_footer', function () {
    $custom_js = get_option(SHOPI_OPTION)['advanced_js'] ?? '';
    if (!empty($custom_js)) {
        echo '<script>' . $custom_js . '</script>';
    }
});

// Execute custom PHP code
add_action('wp_loaded', function () {
    $custom_php = get_option(SHOPI_OPTION)['php_code'] ?? '';
    if (!empty($custom_php)) {
        try {
            eval($custom_php);
        } catch (Throwable $e) {
            error_log('Error executing custom PHP code: ' . $e->getMessage());
        }
    }
});


add_filter('woocommerce_product_tabs', 'custom_rename_and_style_product_tabs');
function custom_rename_and_style_product_tabs($tabs) {
    global $shopi_options;

    if (isset($shopi_options['tab_description_title']) && !empty($shopi_options['tab_description_title'])) {
        $tabs['description']['title'] = $shopi_options['tab_description_title'];
    }

    if (isset($shopi_options['tab_reviews_title']) && !empty($shopi_options['tab_reviews_title'])) {
        $tabs['reviews']['title'] = $shopi_options['tab_reviews_title'];
    }

    if (isset($shopi_options['tab_additional_info_title']) && !empty($shopi_options['tab_additional_info_title'])) {
        $tabs['additional_information']['title'] = $shopi_options['tab_additional_info_title'];
    }

    return $tabs;
}




function enqueue_redux_styles() {
    wp_enqueue_style('redux-admin-css', THEME_URL . '/includes/redux-core/assets/css/redux-admin.css');
    wp_enqueue_style('redux-css', THEME_URL . '/includes/redux-core/assets/css/redux.css');
}
add_action('admin_enqueue_scripts', 'enqueue_redux_styles');

function ivahid_scripts() {
    $theme_version = wp_get_theme()->get('Version');

    $my_account = $_SERVER['REQUEST_URI'];
    if (is_checkout() || is_page_template('templates/template-contact.php') || preg_match('/my-account\/(edit-address)/', $my_account, $matches)) {
        wp_enqueue_style('mapp-css', THEME_URL . "/assets/css/mapp.min.css", array(), $theme_version);
        wp_enqueue_style('mapp-fa-css', THEME_URL . '/assets/css/style.css', array(), $theme_version);
        wp_enqueue_script('mapp-env', THEME_URL . '/assets/js/mapp.env.js', array(), $theme_version, true);
        wp_enqueue_script('mapp', THEME_URL . '/assets/js/mapp.min.js', array('jquery'), $theme_version, true);
    }
    wp_enqueue_style('select2', false, array(), $theme_version);

    if (is_singular("product")) {
        wp_enqueue_style('glightbox', THEME_URL . '/assets/css/glightbox.css', array(), $theme_version);
        wp_enqueue_script('glightbox', THEME_URL . '/assets/js/glightbox.min.js', array(), $theme_version, true);
    }

    if (is_singular('product') || is_shop() || is_product_category()) {
        wp_enqueue_style('jquery-ui', THEME_URL . "/assets/css/jquery-ui.css", array(), $theme_version);
        wp_enqueue_script('jquery-ui', THEME_URL . '/assets/js/jquery-ui.js', array(), $theme_version, true);
    }

    wp_enqueue_style('plugins', THEME_URL . "/assets/css/plugins.css", array(), $theme_version);
    wp_enqueue_style('tailwind', THEME_URL . "/assets/css/tailwind.css", array(), $theme_version);
    wp_enqueue_style('theme_rtl', THEME_URL . '/style.css', array(), $theme_version);

    wp_enqueue_script('plugins', THEME_URL . '/assets/js/plugins.js', array(), $theme_version, true);
    wp_enqueue_script('main', THEME_URL . '/assets/js/main.js', array("jquery", 'selectWoo'), $theme_version, true);

    $data = array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'theme' => THEME_URL
    );
    wp_localize_script('main', 'theme_data', $data);

    if (class_exists('Redux')) {
        $enable_sweetalert_toast = Redux::get_option(SHOPI_OPTION, 'enable_sweetalert_toast');
        $enable_sweetalert_swal_fire = Redux::get_option(SHOPI_OPTION, 'enable_sweetalert_swal_fire');
        $sweetalert_position = Redux::get_option(SHOPI_OPTION, 'sweetalert_position');
        $single_product_ajax_add_to_cart = Redux::get_option(SHOPI_OPTION, 'single_product_ajax_add_to_cart');
    }

    $data = array(
        'enable_sweetalert_toast'     => $enable_sweetalert_toast,
        'enable_sweetalert_swal_fire' => $enable_sweetalert_swal_fire,
        'sweetalert_position' => $sweetalert_position,
        'cart_url' => wc_get_cart_url(),
        'single_product_ajax_add_to_cart' => $single_product_ajax_add_to_cart,
    );

    wp_localize_script('main', 'theme_redux', $data);
}
add_action('wp_enqueue_scripts', 'ivahid_scripts', 999);


function save_custom_meta_field($product_id) {
    $new_sale_price = isset($_POST['_sale_price']) ? sanitize_text_field($_POST['_sale_price']) : '';
    $new_regular_price = isset($_POST['_regular_price']) ? sanitize_text_field($_POST['_regular_price']) : '';
    $old_sale_price = get_post_meta($product_id, '_sale_price', true);
    $old_regular_price = get_post_meta($product_id, '_regular_price', true);

    if ($new_sale_price != $old_sale_price) {
        update_post_meta($product_id, 'price_updated', time());
    }

    if ($new_regular_price != $old_regular_price) {
        update_post_meta($product_id, 'price_updated', time());
    }
}
add_action('woocommerce_process_product_meta', 'save_custom_meta_field');


function get_highest_discount_percentage() {
    global $wpdb;
    $query = "
        SELECT 
        ((pm1.meta_value - pm2.meta_value) / pm1.meta_value) * 100 AS discount_percentage
        FROM {$wpdb->prefix}posts p
        INNER JOIN {$wpdb->prefix}postmeta pm1 ON p.ID = pm1.post_id AND pm1.meta_key = '_regular_price'
        INNER JOIN {$wpdb->prefix}postmeta pm2 ON p.ID = pm2.post_id AND pm2.meta_key = '_sale_price'
        WHERE p.post_type = 'product' 
        AND p.post_status = 'publish'
        AND pm2.meta_value > 0
        ORDER BY discount_percentage DESC
        LIMIT 1
    ";
    if (isset($wpdb->get_row($query)->discount_percentage)) {
        $result = round($wpdb->get_row($query)->discount_percentage);
    } else {
        $result = 0;
    }

    return $result;
}

function get_max_sale_price_date_to() {
    global $wpdb;

    $query = "SELECT MAX(meta_value+0) AS max_date
              FROM {$wpdb->postmeta}
              WHERE meta_key = '_sale_price_dates_to'";

    $max_date = $wpdb->get_var($query);

    if ($max_date) {
        return   $max_date;
    } else {
        return 0;
    }
}

function upload_user_image($file_input = [], $size_support = 1 * 1024 * 1024, $pathDir = 'list_pic_user/') {
    if (empty($file_input['tmp_name'])) {
        return [
            'success' => true,
            'message' => 'هیچ فایلی آپلود نشده است.',
            'url' => ''
        ];
    }
    if (isset($file_input) && !empty($file_input)) {
        $list_file = [$file_input];

        $allowedExts = [
            "image/png",
            "image/jpeg",
            "image/JPG",
            "image/gif",
            "application/pdf",
            "application/msword",
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            "text/plain",
            "application/vnd.ms-excel",
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            "text/csv",
            "application/zip"
        ];

        $upload_dir = wp_upload_dir();
        $filepath = $upload_dir['basedir'] . '/' . $pathDir;
        $fileurl = $upload_dir['baseurl'] . '/' . $pathDir;

        if (!file_exists($filepath)) {
            if (!wp_mkdir_p($filepath)) {
                return [
                    'success' => false,
                    'message' => 'خطا در ایجاد دایرکتوری.',
                    'url' => ''
                ];
            }
        }

        $current_year = date("Y");
        $current_month = date("m");

        $year_month_dir = $filepath . $current_year . '/' . $current_month . '/';

        if (!file_exists($year_month_dir)) {
            if (!wp_mkdir_p($year_month_dir)) {
                return [
                    'success' => false,
                    'message' => 'خطا در ایجاد دایرکتوری سال/ماه.',
                    'url' => ''
                ];
            }
        }

        foreach ($list_file as $key => $item) {
            $file_format = $item['type'];
            $file_size = $item["size"];
            if (($file_size < $size_support) && in_array($file_format, $allowedExts)) {
                $filenamepart = explode('.', $item['name']);
                $newfilename = "pic_" . uniqid() . '.' . end($filenamepart);
                $newaddresspath = $year_month_dir . $newfilename;

                if (!move_uploaded_file($item['tmp_name'], $newaddresspath)) {
                    return [
                        'success' => false,
                        'message' => 'خطا در انتقال فایل آپلود شده.',
                        'url' => ''
                    ];
                }

                $final_url = extractPathAfterKeyword($newaddresspath, "wp-content");
                return [
                    'success' => true,
                    'message' => 'فایل با موفقیت آپلود شد.',
                    'url' => $final_url
                ];
            } else {
                return [
                    'success' => false,
                    'message' => 'سایز یا فرمت فایل پشتیبانی نمی‌شود.',
                    'url' => ''
                ];
            }
        }

        return [
            'success' => false,
            'message' => 'هیچ فایلی پردازش نشده است.',
            'url' => ''
        ];
    }
}

add_action('init', 'custom_form_validation');

function custom_form_validation() {
    if (isset($_POST['form_fillter_top_header'])) {
        $expiration = time() + 12 * 60 * 60;
        $list = $_POST['fillter_top_header'];
        if (is_array($list) && !empty($list)) {
            $cookie_json = implode(',', $_POST['fillter_top_header']);
        } else {
            $cookie_json = '';
        }
        setcookie('filter_cookie', $cookie_json, $expiration, '/');
    }
}


add_filter('woocommerce_get_price_html', 'display_discount_percentage_in_old_price', 10, 2);

function display_discount_percentage_in_old_price($price, $product) {
    $post_type = get_post_type($product->get_id());

    if (($product->is_type('simple') && $product->is_on_sale()) || $post_type == 'product_variation') {
        $discount_percentage = get_simple_product_discount_percentage($product->get_id());
        if ($discount_percentage) {
            $discount_html = "<span class='discount-box fill-[#fcfcfc] inline-flex items-center gap-1 text-[19px] text-[#ffffff] font-bold h-[20px] rounded-[20px_20px_20px_0] bg-primary_bg p-[2px_7px_0_7px] leading-[1] a-md:text-[15px]'>
                                        " . $discount_percentage . "
                                        <svg class=' w-[11px] h-[11px] a-md:w-2 a-md:h-2'>
                                            <use xlink:href='#discount-icon'>
                                        </use></svg>
                                    </span>";
            $price = preg_replace('/<del(.*?)>(.*?)<\/del>/', '<del$1>' . $discount_html . ' $2</del>', $price);
        }
    }

    if ($product->is_type('variable')) {
        if (preg_match('/<del\b[^>]*>/', $price)) {
            $discount_percentage = get_product_discount_percentage($product->get_id());
            if ($discount_percentage) {
                $discount_html = "<span class='discount-box fill-[#fcfcfc] inline-flex items-center gap-1 text-[19px] text-[#ffffff] font-bold h-[20px] rounded-[20px_20px_20px_0] bg-primary_bg p-[2px_7px_0_7px] leading-[1] a-md:text-[15px]'>
                                        " . $discount_percentage . "
                                        <svg class=' w-[11px] h-[11px] a-md:w-2 a-md:h-2'>
                                            <use xlink:href='#discount-icon'>
                                        </use></svg>
                                    </span>";
                $price = preg_replace('/<del(.*?)>(.*?)<\/del>/', '<del$1>' . $discount_html . ' $2</del>', $price);
            }
        } else {
            $discount_percentage = get_product_discount_percentage($product->get_id());
            if ($discount_percentage) {
                $discount_html = "<span class='discount-box fill-[#fcfcfc] inline-flex items-center gap-1 text-[16px] text-[#ffffff] font-bold h-[20px] rounded-[20px_20px_20px_0] bg-primary_bg p-[2px_7px_0_7px] leading-[1] a-md:text-[15px]'>
                                        " . $discount_percentage . "
                                        <svg class=' w-[11px] h-[11px] a-md:w-2 a-md:h-2'>
                                            <use xlink:href='#discount-icon'>
                                        </use></svg>
                                    </span>";
                $price = preg_replace('/<span class="starting-price"(.*?)>(.*?)<\/span>/', '<span class="starting-price flex items-center gap-2"><span class="text-starting-p">$2</span> <span class="discount-inner">' . $discount_html . '</span></span>', $price);
            }
        }
    }

    return $price;
}



add_filter('woocommerce_variable_sale_price_html', 'custom_variable_price_html', 10, 2);
add_filter('woocommerce_variable_price_html', 'custom_variable_price_html', 10, 2);

function custom_variable_price_html($price, $product) {
    $min_price = $product->get_variation_price('min');
    $max_price = $product->get_variation_price('max');
    if ($min_price != $max_price) {
        $price = '<span class="starting-price">' . __('شروع قیمت از: ', 'text-domain') . '</span>' . wc_price($min_price);
    }
    return $price;
}


function custom_single_product_price_message($price, $product) {
    global $shopi_options; 

    $contact_text = $shopi_options['contact_message_text_id'] ?? __('تماس بگیرید', 'text-domain');
    $contact_link = $shopi_options['contact_message_link_id'] ?? '';

    $out_of_stock_text = $shopi_options['out_of_stock_text_id'] ?? __('محصول ناموجود است', 'text-domain');
    $out_of_stock_link = $shopi_options['out_of_stock_link_id'] ?? '';

    if (!$product->is_in_stock()) {
        if (!empty($out_of_stock_link)) {
            return '<a href="' . esc_url($out_of_stock_link) . '" class="out-of-stock-message">' . esc_html($out_of_stock_text) . '</a>';
        } else {
            return '<span class="out-of-stock-message">' . esc_html($out_of_stock_text) . '</span>';
        }
    } elseif (!$product->get_price()) {
        if (!empty($contact_link)) {
            return '<a href="' . esc_url($contact_link) . '" class="contact-message">' . esc_html($contact_text) . '</a>';
        } else {
            return '<span class="contact-message">' . esc_html($contact_text) . '</span>';
        }
    }

    return $price;
}
add_filter('woocommerce_get_price_html', 'custom_single_product_price_message', 10, 2);

add_action('wp_ajax_update_cart_quantity', 'update_cart_quantity');
add_action('wp_ajax_nopriv_update_cart_quantity', 'update_cart_quantity');

function update_cart_quantity() {
    if (isset($_POST['product_id']) && isset($_POST['quantity'])) {
        $product_id = intval($_POST['product_id']);
        $quantity = intval($_POST['quantity']);

        $cart = WC()->cart;
        $cart_item_data = null;

        foreach ($cart->get_cart() as $cart_item_key => $cart_item) {
            if ($cart_item['product_id'] == $product_id) {
                $cart_item_key = $cart_item_key;
                break;
            }
        }

        if ($quantity <= 0) {
            // Remove item from cart if quantity is zero or negative
            WC()->cart->remove_cart_item($cart_item_key);
        } else {
            // Update item quantity in cart
            WC()->cart->set_quantity($cart_item_key, $quantity, true);
        }

        ob_start();
        woocommerce_mini_cart();
        $mini_cart_content = ob_get_clean();
        wp_send_json(['content' => $mini_cart_content], 200);
    }
}

function get_product_quantity_in_cart($product_id) {
    $cart_item_qty = 0;

    if (WC()->cart && WC()->cart->get_cart()) {
        foreach (WC()->cart->get_cart() as $cart_item) {
            if ($cart_item['product_id'] == $product_id) {
                $cart_item_qty = $cart_item['quantity'];
                break;
            }
        }
    }

    return $cart_item_qty;
}

add_filter('woocommerce_locate_template', 'custom_mini_cart_template', 999, 999);

function custom_mini_cart_template($template, $template_name, $template_path) {
    if ($template_name === 'cart/mini-cart.php') {
        $new_template = get_stylesheet_directory() . '/woocommerce/cart/mini-cart.php';

        if (file_exists($new_template)) {
            return $new_template;
        }
    }
    return $template;
}

function get_discount_days_remaining($product_id) {
    $sale_price_dates_to = get_post_meta($product_id, '_sale_price_dates_to', true);

    if ($sale_price_dates_to) {
        $current_date = current_time('timestamp');
        $end_date = intval($sale_price_dates_to);

        $days_remaining = ($end_date - $current_date) / (60 * 60 * 24);

        return max(0, ceil($days_remaining));
    }

    return 0;
}

function add_main_checkbox_to_menu_item($item_id, $item, $depth, $args) {
    $main_checked = get_post_meta($item_id, '_menu_item_main', true);
?>
    <p class="field-main-checkbox description description-wide">
        <label for="edit-menu-item-main-<?php echo $item_id; ?>">
            <input type="checkbox" id="edit-menu-item-main-<?php echo $item_id; ?>" name="menu-item-main[<?php echo $item_id; ?>]" value="1" <?php checked($main_checked, '1'); ?> />
            <?php _e('اصلی'); ?>
        </label>
    </p>
<?php
}
add_action('wp_nav_menu_item_custom_fields', 'add_main_checkbox_to_menu_item', 10, 4);

function save_main_checkbox_for_menu_item($menu_id, $menu_item_db_id) {
    if (isset($_POST['menu-item-main'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_menu_item_main', 1);
    } else {
        delete_post_meta($menu_item_db_id, '_menu_item_main');
    }
}
add_action('wp_update_nav_menu_item', 'save_main_checkbox_for_menu_item', 10, 2);



function add_icon_to_menu_items_with_submenu($item_output, $item, $depth, $args) {
    if ($args->theme_location == 'mobile-menu') {
        if (in_array('menu-item-has-children', $item->classes)) {
            $icon = '<span class="childer"><svg class="fill-[#b8cece] w-3 h-3">
                                            <use xlink:href="#arrow-down-icon">
                                        </use></svg></span>';
            $item_output = str_replace('</a>', '</a>' . $icon, $item_output);
        }
    }
    return $item_output;
}
add_filter('walker_nav_menu_start_el', 'add_icon_to_menu_items_with_submenu', 10, 4);



function hexToRgb($hex) {
    $hex = str_replace("#", "", $hex);
    if (strlen($hex) == 3) {
        $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
        $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
        $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
    } else {
        $r = hexdec(substr($hex, 0, 2));
        $g = hexdec(substr($hex, 2, 2));
        $b = hexdec(substr($hex, 4, 2));
    }
    return "$r, $g, $b";
}

function send_report_email_to_admin($report_data) {
    $admin_email = get_option('admin_email');

    $subject = 'گزارش جدید از کاربر';

    $message = "<html><body>";
    $message .= "<p>یک گزارش جدید از کاربر دریافت شده است:</p>";
    $message .= "<p><strong>نام کاربر:</strong> " . esc_html($report_data['full_name']) . "</p>";
    $message .= "<p><strong>شماره تماس:</strong> " . esc_html($report_data['mobile']) . "</p>";
    $message .= "<p><strong>از چه آدرسی آمده:</strong> <a href='" . esc_url($report_data['referrer_url']) . "'>" . esc_html($report_data['referrer_url']) . "</a></p>";
    $message .= "<p><strong>متن گزارش:</strong><br>" . nl2br(esc_html($report_data['message'])) . "</p>";
    $message .= "</body></html>";

    $headers = array('Content-Type: text/html; charset=UTF-8');

    $result = wp_mail($admin_email, $subject, $message, $headers);
    return $result;
}

function send_contactus_email_to_admin($report_data) {
    $admin_email = get_option('admin_email');

    $subject = 'فرم تماس با ما';

    $message = "<html><body>";
    $message .= "<p>یک درخواست تماس از کاربر دریافت شده است:</p>";
    $message .= "<p><strong>نام کاربر:</strong> " . esc_html($report_data['full_name']) . "</p>";
    $message .= "<p><strong>شماره تماس:</strong> " . esc_html($report_data['mobile']) . "</p>";
    $message .= "<p><strong>پیام:</strong><br>" . nl2br(esc_html($report_data['message'])) . "</p>";
    $message .= "</body></html>";

    $headers = array('Content-Type: text/html; charset=UTF-8');

    $result = wp_mail($admin_email, $subject, $message, $headers);
    return $result;
}

add_filter('woocommerce_gateway_icon', 'add_custom_gateway_icon', 10, 2);

function add_custom_gateway_icon($icon, $gateway_id) {
    if ($gateway_id === 'cheque') {
        $image_url = THEME_URL . "/assets/img/icon-pay-defualt.png";
        $icon =  '<img src="' . esc_url($image_url) . '" alt="پرداخت امن" style="max-width: 100%; height: auto;">';
    }
    return $icon;
}

function is_product_available($product_id = null) {
    if ($product_id) {
        $product = wc_get_product($product_id);

        if (!$product->is_in_stock()) {
            return false;
        }

        if ($product->get_price() === '' || $product->get_price() === null) {
            return false;
        }
        return true;
    }

    return false;
}

add_filter('woocommerce_show_admin_notice', function ($show, $notice) {
    if (
        'template_files' === $notice
    ) {
        return false;
    }

    return $show;
}, 10, 2);


add_filter('woocommerce_checkout_fields', 'disable_shipping_address_validation');
function disable_shipping_address_validation($fields) {
    if (isset($fields['shipping'])) {
        foreach ($fields['shipping'] as $key => $field) {
            $fields['shipping'][$key]['required'] = false;
        }
    }

    return $fields;
}


add_action('woocommerce_update_product', 'save_variable_product_discount_meta');

function save_variable_product_discount_meta($product_id) {
    $product = wc_get_product($product_id);

    if ($product->is_type('variable')) {
        $max_discount = 0;
        $earliest_sale_date = null;
        $latest_sale_date = null;
        $has_sale = false;
        $max_sale_price = 0;

        $variations = $product->get_children();

        foreach ($variations as $variation_id) {
            $variation = wc_get_product($variation_id);

            if ($variation && $variation->is_on_sale()) {
                $has_sale = true;
                $regular_price = $variation->get_regular_price();
                $sale_price = $variation->get_sale_price();

                if ($regular_price && $sale_price) {
                    $discount_percentage = round(($regular_price - $sale_price) / $regular_price * 100);
                    // $max_discount = max($max_discount, $discount_percentage);

                    $max_sale_price = max($max_sale_price, $sale_price);

                    $sale_start_date = get_post_meta($variation_id, '_sale_price_dates_from', true);
                    $sale_end_date = get_post_meta($variation_id, '_sale_price_dates_to', true);

                    if ($sale_start_date) {
                        $sale_start_date = intval($sale_start_date);
                        $earliest_sale_date = $earliest_sale_date ? min($earliest_sale_date, $sale_start_date) : $sale_start_date;
                    }

                    if ($sale_end_date) {
                        $sale_end_date = intval($sale_end_date);
                        $latest_sale_date = $latest_sale_date ? max($latest_sale_date, $sale_end_date) : $sale_end_date;
                    }
                }
            }
        }

        if ($has_sale) {
            update_post_meta($product_id, '_sale_price_dates_from', $earliest_sale_date);
            update_post_meta($product_id, '_sale_price_dates_to', $latest_sale_date);
            update_post_meta($product_id, '_sale_price', $max_sale_price);
        } else {
            delete_post_meta($product_id, '_sale_price_dates_from');
            delete_post_meta($product_id, '_sale_price_dates_to');
            delete_post_meta($product_id, '_sale_price');
        }
    }
}

add_filter('woocommerce_related_products', 'add_related_products', 10, 1);
function add_related_products($related_product_ids) {
    global $shopi_options;

    if (!is_product()) return $related_product_ids;

    global $post;

    $product = wc_get_product($post->ID);
    if (!$product) return $related_product_ids;

    $related_option = isset($shopi_options['related_products_option']) ? $shopi_options['related_products_option'] : '';

    if ($related_option == 'by_category') {
        $related_product_ids = [];

        // Get the product categories
        $terms = wp_get_post_terms($product->get_id(), 'product_cat', array('fields' => 'ids'));

        if (!empty($terms)) {
            // Prepare query arguments to fetch related products by category
            $args = array(
                'posts_per_page' => 8,
                'post_type'      => 'product',
                'post__not_in'   => array($product->get_id()),
                'fields'         => 'ids',
                'tax_query'      => array(
                    array(
                        'taxonomy' => 'product_cat',
                        'field'    => 'term_id',
                        'terms'    => $terms,
                        'operator' => 'IN',
                    ),
                ),
            );

            $related_products = get_posts($args);

            if (!empty($related_products)) {
                $related_product_ids = $related_products;
            }
        }
    }

    return $related_product_ids;
}


function custom_related_products_limit($args) {
    $args['posts_per_page'] = 8;
    return $args;
}
add_filter('woocommerce_output_related_products_args', 'custom_related_products_limit');


function get_wp_image_sizes() {
    global $_wp_additional_image_sizes;
    $sizes = array();

    foreach (get_intermediate_image_sizes() as $size) {
        $sizes[$size] = $size;
    }

    return $sizes;
}

add_filter('auth_cookie_expiration', function ($expiration, $user_id, $remember) {
    return 30 * DAY_IN_SECONDS;
}, 10, 3);


function update_selected_variation() {
    $variation_id = isset($_POST['variation_id']) ? intval($_POST['variation_id']) : 0;
    $product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : 0;

    if (!$variation_id || !$product_id || $variation_id === $product_id) {
        wp_send_json_error(['message' => 'Invalid variation or product ID']);
    }

    $product = wc_get_product($product_id);
    if (!$product) {
        wp_send_json_error(['message' => 'Invalid product']);
    }

    ob_start();
    set_query_var('product', $product);
    set_query_var('variation_id', $variation_id);
    get_template_part('template-parts/single-product/sidebar-shop');
    $sidebar_content = ob_get_clean();

    wp_send_json_success([
        'sidebar_content' => $sidebar_content
    ]);
}
add_action('wp_ajax_update_selected_variation', 'update_selected_variation');
add_action('wp_ajax_nopriv_update_selected_variation', 'update_selected_variation');



function add_custom_styles_before_head() {
    global $shopi_options;

    $primary_text    = isset($shopi_options['primary_text_color']) ? $shopi_options['primary_text_color'] : '#ee384e';
    $primary_bg      = isset($shopi_options['primary_bg_color']) ? $shopi_options['primary_bg_color'] : '#ee384e';
    $primary_fill    = isset($shopi_options['primary_fill_color']) ? $shopi_options['primary_fill_color'] : '#ee384e';
    $secondary_text  = isset($shopi_options['secondary_text_color']) ? $shopi_options['secondary_text_color'] : '#00a651';
    $secondary_bg    = isset($shopi_options['secondary_bg_color']) ? $shopi_options['secondary_bg_color'] : '#00a651';
    $secondary_fill  = isset($shopi_options['secondary_fill_color']) ? $shopi_options['secondary_fill_color'] : '#00a651';
    $responsive_cart_button  = isset($shopi_options['responsive_cart_button']) ? $shopi_options['responsive_cart_button'] : '#ae344d';
?>
    <style>
        :root {
            --color-primary-text: <?= $primary_text; ?>;
            --color-primary-bg: <?= $primary_bg; ?>;
            --color-primary-fill: <?= $primary_fill; ?>;
            --color-primary-bg-rgb: <?= hexToRgb($primary_bg); ?>;

            --color-secondary-text: <?= $secondary_text; ?>;
            --color-secondary-bg: <?= $secondary_bg; ?>;
            --color-secondary-fill: <?= $secondary_fill; ?>;
            --color-secondary-bg-rgb: <?= hexToRgb($secondary_bg); ?>;

            --responsive-cart-button: <?= $responsive_cart_button; ?>;
        }
    </style>
<?php
}
add_action('wp_head', 'add_custom_styles_before_head', 0);

function add_span_after_body(): void {
    echo '<span id="mask" class="hidden"></span>';
    get_template_part('template-parts/svg');
}
add_action('wp_body_open', 'add_span_after_body');



function clear_cache_on_theme_update() {
    $current_version = wp_get_theme()->get('Version');
    $saved_version = get_option('theme_version_cache');

    if ($current_version !== $saved_version) {
        update_option('theme_version_cache', $current_version);

        if (function_exists('rocket_clean_domain')) {
            rocket_clean_domain();
        }

        if (class_exists('LiteSpeed_Cache_API')) {
            LiteSpeed_Cache_API::purge_all();
        }
    }
}
add_action('init', 'clear_cache_on_theme_update');



add_filter('woocommerce_currency_symbol', 'custom_currency_symbol_svg', 10, 2);
function custom_currency_symbol_svg($currency_symbol, $currency) {
        if (!is_admin() || (defined('DOING_AJAX') && DOING_AJAX)) {
            if ($currency == 'IRT') {
            $currency_symbol = "<svg class='w-4 h-4'><use xlink:href='#toman-icon'></svg>";
        }
    }
    return $currency_symbol;
}


add_filter('woocommerce_price_format', 'custom_price_format_for_cart_checkout', 10, 2);
function custom_price_format_for_cart_checkout($format, $currency) {
    if (!is_admin() || (defined('DOING_AJAX') && DOING_AJAX)) {
        if (get_woocommerce_currency() === 'IRT') {
            $format = '<span class="woocommerce-Price-currencySymbol-c IRT">%1$s</span>%2$s';
        } else {
            $format = '<span class="woocommerce-Price-currencySymbol-c">%1$s</span>%2$s';
        }
    }
    return $format;
}



function add_glightbox_white_class($classes) {
    global $shopi_options;
    if (is_product()) {
        if (!isset($shopi_options['glightbox_dark_mode']) || !$shopi_options['glightbox_dark_mode']) {
            $classes[] = 'glightbox-white';
        }
    }
    return $classes;
}
add_filter('body_class', 'add_glightbox_white_class');


remove_action('wp_head', 'wp_generator');

add_action('wp_head', function(){
    echo '<meta name="generator" content="talentra.ir" />' . "\n";
});		
		
		
		
add_action('add_meta_boxes', 'add_custom_attr_metabox');
function add_custom_attr_metabox() {
    add_meta_box(
        'custom_attr_metabox',
        __('تنظیمات', 'your-textdomain'),
        'display_custom_attr_metabox',
        'product',
        'side',
        'default'
    );
}

function display_custom_attr_metabox($post) {
    $custom_attr = get_post_meta($post->ID, 'custom_attr', true);
    ?>
    <label for="custom_attr_field"><?php _e('ویژگی سفارشی را وارد کنید', 'your-textdomain'); ?></label>
    <input type="text" name="custom_attr_field" id="custom_attr_field" value="<?php echo esc_attr($custom_attr); ?>" style="width:100%;" />
    <?php
}

add_action('save_post', 'save_custom_attr_meta');
function save_custom_attr_meta($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (isset($_POST['custom_attr_field'])) {
        update_post_meta($post_id, 'custom_attr', sanitize_text_field($_POST['custom_attr_field']));
    }
}

add_action( 'pre_get_posts', 'sort_products_by_latest' );
function sort_products_by_latest( $query ) {
    if ( ! is_admin() && $query->is_main_query() && ( is_shop() || is_product_category() || is_product_tag() ) ) {
        $query->set( 'orderby', 'date' ); 
        $query->set( 'order', 'DESC' );   
    }
}


/**
 * Customize WooCommerce product description tab.
 */
add_filter( 'woocommerce_product_tabs', 'custom_product_description_tab_content', 99 );
function custom_product_description_tab_content( $tabs ) {
    if ( isset( $tabs['description'] ) ) {
        $tabs['description']['callback'] = 'custom_woocommerce_product_description_tab';
    }
    return $tabs;
}

function custom_woocommerce_product_description_tab() {
    $heading = apply_filters( 'woocommerce_product_description_heading', __( 'Description', 'woocommerce' ) );

    if ( $heading ) {
        echo '<div class="flex flex-col gap-1">';
        echo '<h2 class="title-content-tab text-[20px] text-[#495666] font-bold a-md:text-[16px]">' . esc_html( $heading ) . '</h2>';
        echo '</div>';
    }

    echo '<div class="text-[14px] text-[#495666] font-bold text-justify leading-[2.8] content-post">';
    the_content();
    echo '</div>';
}

add_filter('woocommerce_enable_order_notes_field', function($enabled) {
    global $shopi_options;

    if (isset($shopi_options['disable_order_notes']) && $shopi_options['disable_order_notes']) {
        return false; 
    }

    return $enabled;
});

function af_get_svg_or_img($attachment_id, $class = '') {
    if (!$attachment_id) return '';

    $file_path = get_attached_file($attachment_id);
    $file_ext  = pathinfo($file_path, PATHINFO_EXTENSION);

    if (strtolower($file_ext) === 'svg' && file_exists($file_path)) {
        $svg = file_get_contents($file_path);

        return $svg;
    } else {
        return wp_get_attachment_image($attachment_id, 'full', false, ['class' => $class]);
    }
}

add_action('woocommerce_after_shop_loop', function() use ($shopi_options) { ?>
        <div id="nxLoading" class="hidden">
            <div class="loading_wrapper">
                <div class="loading_box">
                    <div class="loading_img">
                        <?= @wp_get_attachment_image($shopi_options['logo']['id'], 'full', false, ['class' => 'max-h-[80px] max-w-full object-contain']) ?>
                    </div>
                    <div class="loading_bullets_holder"> <i class="loading_bullet loading_bullet--1"></i> <i class="loading_bullet loading_bullet--2"></i> <i class="loading_bullet loading_bullet--3"></i> <i class="loading_bullet loading_bullet--4"></i></div>
                </div>
            </div>
        </div>
    <?php 
}, 5); 


add_action('template_redirect', function() {
    if (!is_singular()) return;

    ob_start(function($buffer) {
        global $post;
        $product_id    = $post->ID;
        $product_title = get_the_title($post->ID);
        $product_sku   = get_post_meta($post->ID, '_sku', true);
        $product_price = get_post_meta($post->ID, '_price', true);

        $data_attrs = sprintf(
            ' data-product-id="%s" data-product-title="%s" data-product-sku="%s" data-product-price="%s"',
            esc_attr($product_id),
            esc_attr($product_title),
            esc_attr($product_sku),
            esc_attr($product_price)
        );

        $buffer = preg_replace('/<body(.*?)>/', '<body$1' . $data_attrs . '>', $buffer, 1);

        return $buffer;
    });
});
