(function ($) {
    if ($(".map_location").length) {
        $(".map_location").each(function () {
            var lat = $(this).data("lat");
            var lng = $(this).data("lng");
            if (lat.length == 0) {
                lat = '32.67237925383597';
            }
            if (lng.length == 0) {
                lng = '51.728525161743164';
            }
            var pic = $(this).data("pic");
            var pinText = $(this).data("pintext");
            var map_ob = this;
            var mymap = L.map(map_ob).setView([lat, lng], 16);
            var placeName = $(this).data("target");

            L.tileLayer(
                "https://api.mapbox.com/styles/v1/mapbox/streets-v11/tiles/{z}/{x}/{y}?access_token={accessToken}",
                {
                    attribution:
                        'ASEN STEEL, Map data &copy; <a target="_blank" href="https://www.openstreetmap.org/">OpenStreetMap</a>',
                    maxZoom: 18,
                    id: "mapbox.streets",
                    accessToken:
                        "pk.eyJ1IjoiZG9ybmF3ZWIiLCJhIjoiY2ppdTZxeG1iMXl6ajN2dDkxdXJpZmV5diJ9.vXLXmJd9GGLcvEbHngwy-A",
                }
            ).addTo(mymap);

            var marker = L.marker([lat, lng], {
                draggable: true,
                icon: new L.DivIcon({
                    className: "map-market-icon",
                    html:
                        '<img src="' + pic + '" alt="img">',
                }),
            }).addTo(mymap);

            mymap.on('click', function (e) {
                var lat = e.latlng.lat;
                var lng = e.latlng.lng;
                marker.setLatLng([lat, lng]);
                $("input[name='lat']").val(lat)
                $("input[name='lng']").val(lng)

            });

            $(".current_location").click(function () {
                showCurrentLocation(marker, mymap);
            });
        });
    }
})