<?php
global $shopi_options;
if (is_array($shopi_options) && isset($shopi_options['enable_invoice_system']) && !$shopi_options['enable_invoice_system']) {
    return;
}

define("PATH_INVOICE", __DIR__);
define("URL_INVOICE", get_template_directory_uri() . "/includes/invoice/");


/**
 * Check if a shipping address is enabled
 *
 * @param object $order Order object.
 */
function wcdn_has_shipping_address($order) {
    // Works only with WooCommerce 2.2 and higher.
    if (version_compare(WC_VERSION, '2.2.0', '>=')) {
        if (!wc_ship_to_billing_address_only() && $order->needs_shipping_address() && 'no' !== get_option('woocommerce_calc_shipping')) {
            return true;
        } else {
            return false;
        }
    }
    return true;
}

// Add "View Invoice" action to My Account Orders
add_filter('woocommerce_my_account_my_orders_actions', 'add_view_invoice_to_my_account', 10, 2);
function add_view_invoice_to_my_account($actions, $order) {
    $actions['view_invoice'] = array(
        'url'  => wp_nonce_url(home_url('view-invoice?order_id=' . $order->get_id() . '&type=view-invoice'), 'view-invoice'),
        'name' => __('فاکتور', 'text-domain'),
    );

    return $actions;
}


add_action('template_redirect', 'handle_view_invoice_page');
function handle_view_invoice_page() {
    // Check if 'order_id', 'type', and '_wpnonce' are set and valid
    if (isset($_GET['order_id'], $_GET['type'], $_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], $_GET['type'])) {

        $order_id = absint($_GET['order_id']);
        $order = wc_get_order($order_id);
        $type = sanitize_text_field($_GET['type']); // Get the 'type' parameter

        // Determine the template path based on the 'type' parameter
        $template_path = '';
        if ($type === 'view-invoice') {
            $template_path = PATH_INVOICE . '/template-parts/view-invoice.php'; // For invoice
        } elseif ($type === 'view-shipping-label') {
            $template_path = PATH_INVOICE . '/template-parts/view-shipping-label.php'; // For shipping label
        }elseif ($type === 'view-shipping-label-2') {
            $template_path = PATH_INVOICE . '/template-parts/view-shipping-label-2.php'; // For shipping label
        } elseif ($type === 'view-shipping-tag') {
            $template_path = PATH_INVOICE . '/template-parts/view-shipping-tag.php'; // For shipping tag
        }

        // If the order exists and the user has permission (admin or user own order)
        if ($order && (current_user_can('manage_options') || $order->get_user_id() === get_current_user_id())) {
            include PATH_INVOICE . "/template-parts/header-head.php"; // Optional header
            include $template_path; // Include the appropriate template based on the 'type'
            include PATH_INVOICE . "/template-parts/footer-foot.php"; // Optional footer
            exit;
        } else {
            wp_redirect(home_url('/my-account'));
            exit;
        }
    }
}

// Adding a new column "Invoice" to the orders table
add_filter('manage_edit-shop_order_columns', 'add_invoice_column_to_orders');
add_filter('manage_woocommerce_page_wc-orders_columns', 'add_invoice_column_to_orders');
function add_invoice_column_to_orders($columns) {
    $reordered_columns = array();

    foreach ($columns as $key => $column) {
        $reordered_columns[$key] = $column;

        // Adding the "Invoice" column after the order status column
        if ($key === 'order_status') {
            $reordered_columns['view-invoice'] = __('مدیریت فاکتور، رسید و لیبل پستی', 'text-domain');
        }
    }

    return $reordered_columns;
}

// Display content for the "Invoice" column (3 links in one column)
add_action('manage_shop_order_posts_custom_column', 'display_invoice_column_content', 10, 2);
add_action('manage_woocommerce_page_wc-orders_custom_column', 'display_invoice_column_content', 10, 2);
function display_invoice_column_content($column, $order) {
    if ($column === 'view-invoice') {
        if (did_action('manage_shop_order_posts_custom_column')) {
            $order_id = $order;
            $order = wc_get_order($order);;
        } elseif (did_action('manage_woocommerce_page_wc-orders_custom_column')) {
            $order_id = $order->get_id();
            $order = $order;
        }

        $icon_invoice = '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M17 21.25H7C3.35 21.25 1.25 19.15 1.25 15.5V8.5C1.25 4.85 3.35 2.75 7 2.75H17C20.65 2.75 22.75 4.85 22.75 8.5V15.5C22.75 19.15 20.65 21.25 17 21.25ZM7 4.25C4.14 4.25 2.75 5.64 2.75 8.5V15.5C2.75 18.36 4.14 19.75 7 19.75H17C19.86 19.75 21.25 18.36 21.25 15.5V8.5C21.25 5.64 19.86 4.25 17 4.25H7Z" fill="#292D32"/>
                            <path d="M6 16.75C5.59 16.75 5.25 16.41 5.25 16V8C5.25 7.59 5.59 7.25 6 7.25C6.41 7.25 6.75 7.59 6.75 8V16C6.75 16.41 6.41 16.75 6 16.75Z" fill="#292D32"/>
                            <path d="M9 12.75C8.59 12.75 8.25 12.41 8.25 12V8C8.25 7.59 8.59 7.25 9 7.25C9.41 7.25 9.75 7.59 9.75 8V12C9.75 12.41 9.41 12.75 9 12.75Z" fill="#292D32"/>
                            <path d="M9 16.75C8.59 16.75 8.25 16.41 8.25 16V15C8.25 14.59 8.59 14.25 9 14.25C9.41 14.25 9.75 14.59 9.75 15V16C9.75 16.41 9.41 16.75 9 16.75Z" fill="#292D32"/>
                            <path d="M15 9.75C14.59 9.75 14.25 9.41 14.25 9V8C14.25 7.59 14.59 7.25 15 7.25C15.41 7.25 15.75 7.59 15.75 8V9C15.75 9.41 15.41 9.75 15 9.75Z" fill="#292D32"/>
                            <path d="M12 16.75C11.59 16.75 11.25 16.41 11.25 16V8C11.25 7.59 11.59 7.25 12 7.25C12.41 7.25 12.75 7.59 12.75 8V16C12.75 16.41 12.41 16.75 12 16.75Z" fill="#292D32"/>
                            <path d="M15 16.75C14.59 16.75 14.25 16.41 14.25 16V12C14.25 11.59 14.59 11.25 15 11.25C15.41 11.25 15.75 11.59 15.75 12V16C15.75 16.41 15.41 16.75 15 16.75Z" fill="#292D32"/>
                            <path d="M18 16.75C17.59 16.75 17.25 16.41 17.25 16V8C17.25 7.59 17.59 7.25 18 7.25C18.41 7.25 18.75 7.59 18.75 8V16C18.75 16.41 18.41 16.75 18 16.75Z" fill="#292D32"/>
                            </svg>';
        $icon_shipping_label = '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M13 14.75H2C1.59 14.75 1.25 14.41 1.25 14V7.62C1.25 7.29999 1.44999 7.01997 1.73999 6.90997C2.03999 6.79997 2.37001 6.89001 2.57001 7.13C3.18001 7.86 4.13001 8.26999 5.07001 8.23999C5.87001 8.21999 6.60998 7.92001 7.16998 7.39001C7.42998 7.17001 7.63999 6.91 7.79999 6.62C8.10999 6.09 8.26 5.50998 8.25 4.91998C8.23 3.99998 7.83002 3.15999 7.15002 2.54999C6.91002 2.33999 6.83 2.00997 6.94 1.71997C7.05 1.42997 7.33001 1.22998 7.64001 1.22998H15C15.41 1.22998 15.75 1.56998 15.75 1.97998V11.98C15.75 13.52 14.52 14.75 13 14.75ZM2.75 13.25H13C13.69 13.25 14.25 12.69 14.25 12V2.75H9.19C9.54 3.4 9.73 4.13001 9.75 4.89001C9.77 5.76001 9.54998 6.62 9.10999 7.37C8.86999 7.79999 8.53999 8.21001 8.17999 8.51001C7.37999 9.27001 6.27999 9.72 5.10999 9.75C4.26999 9.78 3.46001 9.57 2.76001 9.19V13.25H2.75Z" fill="#292D32"/>
                                <path d="M19 20.75H18C17.59 20.75 17.25 20.41 17.25 20C17.25 19.31 16.69 18.75 16 18.75C15.31 18.75 14.75 19.31 14.75 20C14.75 20.41 14.41 20.75 14 20.75H10C9.59 20.75 9.25 20.41 9.25 20C9.25 19.31 8.69 18.75 8 18.75C7.31 18.75 6.75 19.31 6.75 20C6.75 20.41 6.41 20.75 6 20.75H5C2.93 20.75 1.25 19.07 1.25 17V14C1.25 13.59 1.59 13.25 2 13.25H13C13.69 13.25 14.25 12.69 14.25 12V5C14.25 4.59 14.59 4.25 15 4.25H16.84C17.83 4.25 18.74 4.78001 19.23 5.64001L20.94 8.63C21.07 8.86 21.07 9.15 20.94 9.38C20.81 9.61 20.56 9.75 20.29 9.75H19C18.86 9.75 18.75 9.86 18.75 10V13C18.75 13.14 18.86 13.25 19 13.25H22C22.41 13.25 22.75 13.59 22.75 14V17C22.75 19.07 21.07 20.75 19 20.75ZM18.65 19.25H19C20.24 19.25 21.25 18.24 21.25 17V14.75H19C18.04 14.75 17.25 13.96 17.25 13V10C17.25 9.04 18.03 8.25 19 8.25L17.93 6.38C17.71 5.99 17.29 5.75 16.84 5.75H15.75V12C15.75 13.52 14.52 14.75 13 14.75H2.75V17C2.75 18.24 3.76 19.25 5 19.25H5.34998C5.67998 18.1 6.74 17.25 8 17.25C9.26 17.25 10.32 18.1 10.65 19.25H13.36C13.69 18.1 14.75 17.25 16.01 17.25C17.27 17.25 18.32 18.1 18.65 19.25Z" fill="#292D32"/>
                                <path d="M8 22.75C6.48 22.75 5.25 21.52 5.25 20C5.25 18.48 6.48 17.25 8 17.25C9.52 17.25 10.75 18.48 10.75 20C10.75 21.52 9.52 22.75 8 22.75ZM8 18.75C7.31 18.75 6.75 19.31 6.75 20C6.75 20.69 7.31 21.25 8 21.25C8.69 21.25 9.25 20.69 9.25 20C9.25 19.31 8.69 18.75 8 18.75Z" fill="#292D32"/>
                                <path d="M16 22.75C14.48 22.75 13.25 21.52 13.25 20C13.25 18.48 14.48 17.25 16 17.25C17.52 17.25 18.75 18.48 18.75 20C18.75 21.52 17.52 22.75 16 22.75ZM16 18.75C15.31 18.75 14.75 19.31 14.75 20C14.75 20.69 15.31 21.25 16 21.25C16.69 21.25 17.25 20.69 17.25 20C17.25 19.31 16.69 18.75 16 18.75Z" fill="#292D32"/>
                                <path d="M22 14.75H19C18.04 14.75 17.25 13.96 17.25 13V10C17.25 9.04 18.04 8.25 19 8.25H20.29C20.56 8.25 20.81 8.39 20.94 8.63L22.65 11.63C22.71 11.74 22.75 11.87 22.75 12V14C22.75 14.41 22.41 14.75 22 14.75ZM19 9.75C18.86 9.75 18.75 9.86 18.75 10V13C18.75 13.14 18.86 13.25 19 13.25H21.25V12.2L19.85 9.75H19Z" fill="#292D32"/>
                                <path d="M4.9901 9.75C3.6101 9.75 2.31011 9.14998 1.43011 8.09998C1.29011 7.94998 1.14012 7.73998 1.01012 7.53998C0.540123 6.82998 0.280123 5.98999 0.260123 5.10999C0.220123 3.64999 0.840136 2.27998 1.96014 1.34998C2.81014 0.649976 3.83009 0.27 4.91009 0.25C6.09009 0.26 7.27014 0.650002 8.15014 1.44C9.15014 2.32 9.73012 3.55001 9.76012 4.89001C9.78012 5.76001 9.56011 6.62 9.12011 7.37C8.88011 7.79999 8.55012 8.21001 8.19012 8.51001C7.39012 9.27001 6.29011 9.72 5.12011 9.75C5.07011 9.75 5.0301 9.75 4.9901 9.75ZM4.9901 1.75C4.9701 1.75 4.95011 1.75 4.93011 1.75C4.20011 1.76 3.50009 2.03001 2.91009 2.51001C2.15009 3.14001 1.73011 4.08001 1.75011 5.07001C1.77011 5.67001 1.94012 6.24002 2.26012 6.71002C2.35012 6.85002 2.4401 6.97998 2.5501 7.09998C3.1901 7.85998 4.14012 8.25999 5.07012 8.23999C5.87012 8.21999 6.6101 7.92001 7.1701 7.39001C7.4301 7.17001 7.6401 6.91 7.8001 6.62C8.1101 6.09 8.26011 5.50998 8.25011 4.91998C8.23011 3.99998 7.83014 3.15999 7.15014 2.54999C6.55014 2.03999 5.7901 1.75 4.9901 1.75Z" fill="#292D32"/>
                                <path d="M4.44988 6.74993C4.25988 6.74993 4.07986 6.6799 3.92986 6.5399L2.91985 5.57994C2.61985 5.28994 2.60989 4.81995 2.89989 4.51995C3.18989 4.21995 3.65989 4.20993 3.95989 4.49993L4.44988 4.9699L6.01988 3.44994C6.31988 3.15994 6.78988 3.1699 7.07988 3.4699C7.36988 3.7699 7.35986 4.23996 7.05986 4.52996L4.96984 6.54991C4.81984 6.67991 4.62988 6.74993 4.44988 6.74993Z" fill="#292D32"/>
                                </svg>';
        $icon_shipping_tag = '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 12.95H8C7.59 12.95 7.25 12.61 7.25 12.2C7.25 11.79 7.59 11.45 8 11.45H15C15.41 11.45 15.75 11.79 15.75 12.2C15.75 12.61 15.41 12.95 15 12.95Z" fill="#292D32"/>
                                <path d="M12.38 16.95H8C7.59 16.95 7.25 16.61 7.25 16.2C7.25 15.79 7.59 15.45 8 15.45H12.38C12.79 15.45 13.13 15.79 13.13 16.2C13.13 16.61 12.79 16.95 12.38 16.95Z" fill="#292D32"/>
                                <path d="M14 6.75H10C9.04 6.75 7.25 6.75 7.25 4C7.25 1.25 9.04 1.25 10 1.25H14C14.96 1.25 16.75 1.25 16.75 4C16.75 4.96 16.75 6.75 14 6.75ZM10 2.75C9.01 2.75 8.75 2.75 8.75 4C8.75 5.25 9.01 5.25 10 5.25H14C15.25 5.25 15.25 4.99 15.25 4C15.25 2.75 14.99 2.75 14 2.75H10Z" fill="#292D32"/>
                                <path d="M15 22.75H9C3.38 22.75 2.25 20.17 2.25 16V9.99999C2.25 5.43999 3.9 3.48999 7.96 3.27999C8.36 3.25999 8.73 3.56999 8.75 3.98999C8.77 4.40999 8.45 4.74999 8.04 4.76999C5.2 4.92999 3.75 5.77999 3.75 9.99999V16C3.75 19.7 4.48 21.25 9 21.25H15C19.52 21.25 20.25 19.7 20.25 16V9.99999C20.25 5.77999 18.8 4.92999 15.96 4.76999C15.55 4.74999 15.23 4.38999 15.25 3.97999C15.27 3.56999 15.63 3.24999 16.04 3.26999C20.1 3.48999 21.75 5.43999 21.75 9.98999V15.99C21.75 20.17 20.62 22.75 15 22.75Z" fill="#292D32"/>
                                </svg>';
        // Link to view invoice
        $invoice_url = wp_nonce_url(home_url('view-invoice?order_id=' . $order_id . '&type=view-invoice'), 'view-invoice');
        echo '<a href="' . esc_url($invoice_url) . '" target="_blank" title="چاپ فاکتور" class="button-x invoice-print">' . $icon_invoice . '</a>';

        // Link to view shipping label
        $shipping_label_url = wp_nonce_url(home_url('view-shipping-label?order_id=' . $order_id . '&type=view-shipping-label'), 'view-shipping-label');
        echo '<a href="' . esc_url($shipping_label_url) . '" target="_blank" title="چاپ لیبل پستی" class="button-x label-print">' . $icon_shipping_label . '</a>';

         // Link to view shipping label
        $shipping_label_url = wp_nonce_url(home_url('view-shipping-label-2?order_id=' . $order_id . '&type=view-shipping-label-2'), 'view-shipping-label-2');
        echo '<a href="' . esc_url($shipping_label_url) . '" target="_blank" title="چاپ لیبل پستی 2" class="button-x label-print">' . $icon_shipping_label . '</a>';


        // Link to view shipping tag
        $shipping_tag_url = wp_nonce_url(home_url('view-shipping-tag?order_id=' . $order_id . '&type=view-shipping-tag'), 'view-shipping-tag');
        echo '<a href="' . esc_url($shipping_tag_url) . '" target="_blank" title="چاپ رسید" class="button-x receipt-print">' . $icon_shipping_tag . '</a>';
    }
}
