<?php
if (!defined('ABSPATH')) {
    exit;
}
global $shopi_options;
$oid = $order->get_order_number();

$title = $shopi_options['invoice_title'];
$admin_message = $shopi_options['custom_message_invoice'];

$company_logo = $shopi_options['invoice_company_logo'];
$company_name = $shopi_options['invoice_company_name'];
$company_address = $shopi_options['invoice_company_address'];
$company_phone = $shopi_options['invoice_company_phone'];
$company_fax = $shopi_options['invoice_company_fax'];
$company_postal_code = $shopi_options['invoice_company_postal_code'];
$company_nid = $shopi_options['invoice_company_nid'];
$company_rid = $shopi_options['invoice_company_rid'];
$company_eid = $shopi_options['invoice_company_eid'];
$enable_barcode =  $shopi_options['show_order_barcode_invoice'];
$enable_product_image =  $shopi_options['show_product_image_invoice'];
$enable_product_code =  $shopi_options['show_product_code_invoice'];

$order_number = $order->get_order_number();
$order_date = wc_format_datetime($order->get_date_created(), 'j F Y');
$payment_method = $order->get_payment_method_title();
?>
<div class="invoice-box">
    <div id="print-content">
        <div class="box-order-branding">
            <div class="order-branding">
                <?php
                if ($company_logo != '') {
                    echo '<div class="company-logo">';
                    echo '<img src="' . esc_url($company_logo['url']) . '" alt="' . get_bloginfo('name') . '"/>';
                    echo '</div>';
                }

                if ($title) {
                    echo '<div class="company-name"><h1>' . esc_html($title) . '</h1></div>';
                }
                ?>
            </div><!-- .order-branding -->
            <?php if (isset($enable_barcode) && !empty($enable_barcode)) { ?>
                <div id="qrcode"></div>
            <?php } ?>
        </div>

        <div class="order-info box">
            <ul class="info-list">
                <li>
                    <strong>شماره سفارش:</strong>
                    <span id="order-number"><?php echo esc_html($order_number); ?></span>
                </li>
                <li>
                    <strong>تاریخ سفارش:</strong>
                    <span><?php echo esc_html($order_date); ?></span>
                </li>
                <li>
                    <strong>روش پرداخت:</strong>
                    <span><?php echo esc_html($payment_method); ?></span>
                </li>
            </ul>
        </div>

        <div class="order-addresses 
	<?php
    $order_id = $order->get_order_number();
    if (!wcdn_has_shipping_address($order)) :
    ?>
		no-shipping-address<?php endif; ?>">
            <div class="billing-address address-box">
                <h3><span>خریدار</span></h3>
                <div class="box-inner">
                    <?php
                    if (!$order->get_formatted_billing_address()) {
                        esc_attr_e('N/A', 'woocommerce-delivery-notes');
                    } else {
                        $billing_info = [
                            'نام' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
                            'تلفن' => $order->get_billing_phone(),
                            'آدرس' => $order->get_billing_state() . ' ' . $order->get_billing_city() . ' ' . $order->get_billing_address_1(),
                            'کد پستی' => $order->get_billing_postcode(),
                        ];

                        foreach ($billing_info as $title => $value) {
                            echo '<div class="item">';
                            echo '<span class="title">' . esc_html($title) . ':</span>';
                            echo '<span class="value">' . esc_html($value) . '</span>';
                            echo '</div>';
                        }

                        // نمایش اطلاعات اضافی بر اساس نوع مشتری
                        $customer_type = get_post_meta($order_id, 'customer-type', true);

                        if ($customer_type == 'haghighi') {
                            echo '<div class="item">';
                            echo '<span class="title">کد ملی:</span>';
                            echo '<span class="value">' . esc_html(get_post_meta($order_id, 'national-code', true)) . '</span>';
                            echo '</div>';
                        } elseif ($customer_type == 'hoghooghi') {
                            $company_info = [
                                'نام شرکت' => get_post_meta($order_id, 'company', true),
                                'شماره ثبت' => get_post_meta($order_id, 'register-number', true),
                                'کد اقتصادی' => get_post_meta($order_id, 'economic-code', true),
                                'شناسه ملی' => get_post_meta($order_id, 'national-id', true),
                            ];

                            foreach ($company_info as $title => $value) {
                                echo '<div class="item">';
                                echo '<span class="title">' . esc_html($title) . ':</span>';
                                echo '<span class="value">' . esc_html($value) . '</span>';
                                echo '</div>';
                            }
                        }
                    }
                    ?>
                </div>
            </div>

            <div class="shipping-address address-box">
                <h3><span>گیرنده</span></h3>
                <div class="box-inner">
                    <?php
                    if (!$order->get_formatted_shipping_address()) {
                        esc_attr_e('N/A', 'woocommerce-delivery-notes');
                    } else {
                        $shipping_info = [
                            'نام' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
                            'تلفن' => $order->get_shipping_phone(),
                            'آدرس' => ($order->get_shipping_state()) . ' ' . $order->get_shipping_city() . ' ' . $order->get_shipping_address_1(),
                            'کد پستی' => $order->get_shipping_postcode(),
                        ];

                        // نمایش اطلاعات آدرس ارسال
                        foreach ($shipping_info as $title => $value) {
                            echo '<div class="item">';
                            echo '<span class="title">' . esc_html($title) . ':</span>';
                            echo '<span class="value">' . esc_html($value) . '</span>';
                            echo '</div>';
                        }
                    }
                    ?>
                </div>
            </div>

        </div>
        <?php
        $th = 5;
        ?>
        <div class="order-items">
            <table>
                <thead>
                    <tr>
                        <th class=""><span>ردیف</span></th>
                        <?php if (isset($enable_product_image) && !empty($enable_product_image)) { ?>
                            <th class=""><span>تصویر</span></th>
                        <?php $th++;
                        } ?>
                        <?php if (isset($enable_product_code) && !empty($enable_product_code)) { ?>
                            <th class=""><span>کد کالا</span></th>
                        <?php $th++;
                        } ?>
                        <th class="head-name"><span>کالا</span></th>
                        <th class="head-item-price">قیمت</th>
                        <th class="head-quantity"><span>تعداد</span></th>
                        <th class="head-price"><span>مجموع</span></th>
                    </tr>
                </thead>

                <tbody>
                    <?php if (count($order->get_items()) > 0) : $i = 1;  ?>
                        <?php foreach ($order->get_items() as $item) :
                            $product = apply_filters('wcdn_order_item_product', $item->get_product(), $item);
                            if (!$product) continue;

                            $item_meta = version_compare(get_option('woocommerce_version'), '3.0.0', '>=')
                                ? new WC_Order_Item_Product($item['item_meta'], $product)
                                : new WC_Order_Item_Meta($item['item_meta'], $product);
                        ?>

                            <tr>
                                <td><?= $i ?></td>
                                <?php if (isset($enable_product_image) && !empty($enable_product_image)) { ?>
                                    <td>
                                        <?php if (has_post_thumbnail($item['product_id'])) {
                                            echo get_the_post_thumbnail($item['product_id'], 'woocommerce_thumbnail', ['class' => 'woocommerce_thumbnail']);
                                        } else {
                                            echo wc_placeholder_img('woocommerce_thumbnail', ['class' => 'woocommerce_thumbnail']);
                                        } ?>
                                    </td>
                                <?php } ?>
                                <?php if (isset($enable_product_code) && !empty($enable_product_code)) { ?>
                                    <td class="">
                                        <?= @$product->get_sku() ?>
                                    </td>
                                <?php } ?>

                                <td class="product-name">
                                    <?php
                                    do_action('wcdn_order_item_before', $product, $order, $item);
                                    $addon_name = $item->get_meta('_wc_pao_addon_name', true);
                                    $addon_value = $item->get_meta('_wc_pao_addon_value', true);
                                    if ($addon_value) {
                                        echo '<div class="wc-pao-order-item-name">' . esc_html($addon_name) . '</div><div class="wc-pao-order-item-value">' . esc_html($addon_value) . '</div>';
                                    } else {
                                        echo wp_kses_post(apply_filters('wcdn_order_item_name', $product->get_name(), $item));
                                        if (version_compare(get_option('woocommerce_version'), '3.0.0', '>=')) {
                                            if (isset($item['variation_id']) && 0 !== $item['variation_id']) {
                                                $variation = wc_get_product($item['product_id']);
                                                foreach ($item['item_meta'] as $key => $value) {
                                                    if (strpos($key, '_') !== 0) {
                                                        $term_wp = get_term_by('slug', $value, $key);
                                                        $attribute_name = wc_attribute_label($key, $variation);
                                                        echo ' - ' . wp_kses_post($attribute_name . ':' . ($term_wp->name ?? urldecode($value)));
                                                    }
                                                }
                                            } else {
                                                foreach ($item['item_meta'] as $key => $value) {
                                                    if (strpos($key, '_') !== 0 && !is_array($value)) {
                                                        echo '<br>' . wp_kses_post($key . ':' . $value);
                                                    }
                                                }
                                            }
                                        } else {
                                            $item_meta->display();
                                        }
                                    }
                                    ?>
                                </td>
                                <td class="product-item-price">
                                    <span><?php echo wc_price($item->get_subtotal() / $item->get_quantity()); ?></span>
                                </td>
                                <td class="product-quantity">
                                    <span><?php echo esc_attr(apply_filters('wcdn_order_item_quantity', $item['qty'], $item)); ?></span>
                                </td>
                                <td class="product-price">
                                    <span><?php echo wp_kses_post($order->get_formatted_line_subtotal($item)); ?></span>
                                </td>
                            </tr>
                            <?php $i++; ?>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>

                <tfoot>
                    <?php if ($totals_arr = $order->get_order_item_totals()) : ?>
                        <?php foreach ($totals_arr as $total) : ?>
                            <tr>
                                <td class="total-name" colspan="<?= $th - 1; ?>"><span><?php echo wp_kses_post($total['label']); ?></span></td>
                                <?php echo ('Total' === $total['label']) ? wp_kses_post($order->get_item_count()) : ''; ?>
                                </td>
                                <td class="total-price"><span><?php echo wp_kses_post($total['value']); ?></span></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tfoot>
            </table>
        </div><!-- .order-items -->

        <?php
        $customer_notes = $order->get_customer_note();

        if (!empty($customer_notes)) {
            echo '<div class="order-notes box">';
            echo '<div class="list-item">';
            echo '<span class="title">یادداشت مشتری:</span>';
            echo '<span class="value">' . esc_html($customer_notes) . '</span>';
            echo '</div>';
            echo '</div>';
        }

        if ($admin_message) {
            echo '<div class="order-thanks box">';
            echo '<div class="list-item">';
            echo '<span class="title">پیام :</span>';
            echo '<span class="value"><p>' . esc_html($admin_message) . '</p></span>';
            echo '</div>';
            echo '</div>';
        }
        ?>
        <div class="order-colophon">
            <?php
            if ($company_name or $company_phone or $company_fax or $company_nid or $company_rid or $company_eid or $company_address or $company_postal_code) {
                echo '<div class="company-info box">';
                if ($company_name or $company_phone or $company_fax) {
                    if ($company_name) {
                        echo '<div class="list-item"><span class="title">نام فروشنده/شرکت:</span><span class="value">' . esc_html($company_name) . '</span></div>';
                    }
                    if ($company_phone) {
                        echo '<div class="list-item"><span class="title">شماره تماس:</span><span class="value">' . esc_html($company_phone) . '</span></div>';
                    }
                    if ($company_fax) {
                        echo '<div class="list-item"><span class="title">فکس:</span><span class="value">' . esc_html($company_fax) . '</span></div>';
                    }
                }
                if ($company_nid or $company_rid or $company_eid) {
                    if ($company_nid) {
                        echo '<div class="list-item"><span class="title">شناسه ملی:</span><span class="value">' . esc_html($company_nid) . '</span></div>';
                    }
                    if ($company_rid) {
                        echo '<div class="list-item"><span class="title">شماره ثبت:</span><span class="value">' . esc_html($company_rid) . '</span></div>';
                    }
                    if ($company_eid) {
                        echo '<div class="list-item"><span class="title">شماره اقتصادی:</span><span class="value">' . esc_html($company_eid) . '</span></div>';
                    }
                }
                if ($company_address or $company_postal_code) {
                    if ($company_address) {
                        echo '<div class=" list-item address"><span class="title">آدرس:</span><span class="value">' . esc_html($company_address) . '</span></div>';
                    }
                    if ($company_postal_code) {
                        echo '<div class="list-item"><span class="title">کد پستی:</span><span class="value">' . esc_html($company_postal_code) . '</span></div>';
                    }
                }
                echo '</div>';
            }
            ?>
        </div><!-- .order-colophon -->
    </div>
    <div class="container-print-button-box">
        <div class="print-button-box">
            <a href="javascript:window.print()">
                <svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path d="M16.75 7.75H7.25C6.84 7.75 6.5 7.41 6.5 7V5C6.5 2.44 7.69 1.25 10.25 1.25H13.75C16.31 1.25 17.5 2.44 17.5 5V7C17.5 7.41 17.16 7.75 16.75 7.75ZM8 6.25H16V5C16 3.3 15.45 2.75 13.75 2.75H10.25C8.55 2.75 8 3.3 8 5V6.25Z" />
                    <path d="M13 22.75H11C8.58 22.75 7.25 21.42 7.25 19V15C7.25 14.59 7.59 14.25 8 14.25H16C16.41 14.25 16.75 14.59 16.75 15V19C16.75 21.42 15.42 22.75 13 22.75ZM8.75 15.75V19C8.75 20.58 9.42 21.25 11 21.25H13C14.58 21.25 15.25 20.58 15.25 19V15.75H8.75Z" />
                    <path d="M18 18.75H16C15.59 18.75 15.25 18.41 15.25 18V15.75H8.75V18C8.75 18.41 8.41 18.75 8 18.75H6C3.58 18.75 2.25 17.42 2.25 15V10C2.25 7.58 3.58 6.25 6 6.25H18C20.42 6.25 21.75 7.58 21.75 10V15C21.75 17.42 20.42 18.75 18 18.75ZM16.75 17.25H18C19.58 17.25 20.25 16.58 20.25 15V10C20.25 8.42 19.58 7.75 18 7.75H6C4.42 7.75 3.75 8.42 3.75 10V15C3.75 16.58 4.42 17.25 6 17.25H7.25V15C7.25 14.59 7.59 14.25 8 14.25H16C16.41 14.25 16.75 14.59 16.75 15V17.25Z" />
                    <path d="M17 15.75H7C6.59 15.75 6.25 15.41 6.25 15C6.25 14.59 6.59 14.25 7 14.25H17C17.41 14.25 17.75 14.59 17.75 15C17.75 15.41 17.41 15.75 17 15.75Z" />
                    <path d="M10 11.75H7C6.59 11.75 6.25 11.41 6.25 11C6.25 10.59 6.59 10.25 7 10.25H10C10.41 10.25 10.75 10.59 10.75 11C10.75 11.41 10.41 11.75 10 11.75Z" />
                </svg>
                چاپ فاکتور</a>
            <button id="save-button">
                <svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15 22.75H9C3.57 22.75 1.25 20.43 1.25 15V9C1.25 3.57 3.57 1.25 9 1.25H15C20.43 1.25 22.75 3.57 22.75 9V15C22.75 20.43 20.43 22.75 15 22.75ZM9 2.75C4.39 2.75 2.75 4.39 2.75 9V15C2.75 19.61 4.39 21.25 9 21.25H15C19.61 21.25 21.25 19.61 21.25 15V9C21.25 4.39 19.61 2.75 15 2.75H9Z" />
                    <path d="M9 10.75C7.48 10.75 6.25 9.52 6.25 8C6.25 6.48 7.48 5.25 9 5.25C10.52 5.25 11.75 6.48 11.75 8C11.75 9.52 10.52 10.75 9 10.75ZM9 6.75C8.31 6.75 7.75 7.31 7.75 8C7.75 8.69 8.31 9.25 9 9.25C9.69 9.25 10.25 8.69 10.25 8C10.25 7.31 9.69 6.75 9 6.75Z" />
                    <path d="M2.67002 19.7C2.43002 19.7 2.19002 19.58 2.05002 19.37C1.82002 19.03 1.91002 18.56 2.26002 18.33L7.19002 15.02C8.27002 14.29 9.76002 14.38 10.74 15.21L11.07 15.5C11.57 15.93 12.42 15.93 12.91 15.5L17.07 11.93C18.13 11.02 19.8 11.02 20.87 11.93L22.5 13.33C22.81 13.6 22.85 14.07 22.58 14.39C22.31 14.7 21.84 14.74 21.52 14.47L19.89 13.07C19.39 12.64 18.54 12.64 18.04 13.07L13.88 16.64C12.82 17.55 11.15 17.55 10.08 16.64L9.75002 16.35C9.29002 15.96 8.53002 15.92 8.02002 16.27L3.09002 19.58C2.96002 19.66 2.81002 19.7 2.67002 19.7Z" />
                </svg>
                دانلود تصویر
            </button>
            <button id="download-pdf">
                <svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15 22.75H9C3.57 22.75 1.25 20.43 1.25 15V9C1.25 3.57 3.57 1.25 9 1.25H14C14.41 1.25 14.75 1.59 14.75 2C14.75 2.41 14.41 2.75 14 2.75H9C4.39 2.75 2.75 4.39 2.75 9V15C2.75 19.61 4.39 21.25 9 21.25H15C19.61 21.25 21.25 19.61 21.25 15V10C21.25 9.59 21.59 9.25 22 9.25C22.41 9.25 22.75 9.59 22.75 10V15C22.75 20.43 20.43 22.75 15 22.75Z" />
                    <path d="M22 10.75H18C14.58 10.75 13.25 9.41999 13.25 5.99999V1.99999C13.25 1.69999 13.43 1.41999 13.71 1.30999C13.99 1.18999 14.31 1.25999 14.53 1.46999L22.53 9.46999C22.74 9.67999 22.81 10.01 22.69 10.29C22.57 10.57 22.3 10.75 22 10.75ZM14.75 3.80999V5.99999C14.75 8.57999 15.42 9.24999 18 9.24999H20.19L14.75 3.80999Z" />
                    <path d="M13 13.75H7C6.59 13.75 6.25 13.41 6.25 13C6.25 12.59 6.59 12.25 7 12.25H13C13.41 12.25 13.75 12.59 13.75 13C13.75 13.41 13.41 13.75 13 13.75Z" />
                    <path d="M11 17.75H7C6.59 17.75 6.25 17.41 6.25 17C6.25 16.59 6.59 16.25 7 16.25H11C11.41 16.25 11.75 16.59 11.75 17C11.75 17.41 11.41 17.75 11 17.75Z" />
                </svg>
                دانلود PDF
            </button>
        </div>
    </div>
</div>