<?php
require_once 'list-jobs.php';

/* Creating create jobs list post type
 */

function create_jobs_post_type() {

    // Set UI labels for Custom Post Type
    $labels = array(
        'name' => "فرصت های شغلی",
        'singular_name' => 'فرصت شغلی',
        'menu_name' => 'فرصت های شغلی',
        'parent_item_colon' => 'سوال والد',
        'all_items' => 'همه فرصت های شغلی',
        'view_item' => 'مشاهده فرصت شغلی',
        'add_new_item' => 'افزودن فرصت شغلی',
        'add_new' => 'افزودن فرصت شغلی',
        'edit_item' => 'ویرایش فرصت شغلی',
        'update_item' => 'بروزرسانی فرصت شغلی',
        'search_items' => 'جستجوی فرصت شغلی',
        'not_found' => 'پیدا نشد',
        'not_found_in_trash' => 'در زباله دان پیدا نشد.'
    );

    // Set other options for Custom Post Type
    $args = array(
        'label' => 'فرصت های شغلی',
        'description' => 'فرصت های شغلی',
        'labels' => $labels,
        'supports' => array(
            'title',
            'author',
            'custom-fields',
            'thumbnail',
        ),
        'hierarchical' => true,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-id',
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'publicly_queryable' => true,
        'capability_type' => 'post',
        'show_in_rest' => true,

    );

    // Registering your Custom Post Type
    register_post_type('jobs', $args);
}

add_action('init', 'create_jobs_post_type', 0);


// create faq category taxonomy
add_action('init', function () {
    register_taxonomy('jobs_category', [], [
        'label' => 'دسته بندی فرصت های شغلی',
        'hierarchical' => true,
        'show_admin_column' => true,
        'show_in_rest' => true,
        'labels' => [
            'singular_name' => 'دسته بندی فرصت های شغلی',
            'all_items' => 'همه دسته بندی ها',
            'edit_item' => 'ویرایش دسته بندی',
            'view_item' => 'نمایش دسته بندی',
            'update_item' => 'بروزرسانی دسته بندی',
            'add_new_item' => 'افزودن دسته بندی فرصت های شغلی',
            'new_item_name' => 'نام دسته بندی فرصت های شغلی',
            'search_items' => 'جستجو دسته بندی فرصت های شغلی',
            'parent_item' => 'دسته بندی والد',
            'parent_item_colon' => 'دسته بندی والد',
            'not_found' => 'پیدا نشد',
        ]
    ]);
    register_taxonomy_for_object_type('jobs_category', 'jobs');
});
