<?php
/* Creating create podcast post type
 */

function create_jobs_list_post_type() {

    // Set UI labels for Custom Post Type
    $labels = array(
        'name' => "لیست رزومه ها",
        'singular_name' => 'لیست رزومه ها',
        'menu_name' => 'لیست رزومه ها',
        'parent_item_colon' => 'سوال والد',
        'all_items' => 'همه لیست رزومه ها',
        'view_item' => 'مشاهده رزومه ها',
        'add_new_item' => 'افزودن رزومه ها',
        'add_new' => 'افزودن رزومه ها',
        'edit_item' => 'ویرایش رزومه ها',
        'update_item' => 'بروزرسانی رزومه ها',
        'search_items' => 'جستجوی رزومه ها',
        'not_found' => 'پیدا نشد',
        'not_found_in_trash' => 'در زباله دان پیدا نشد.'
    );

    // Set other options for Custom Post Type
    $args = array(
        'label' => 'لیست رزومه ها',
        'description' => 'لیست رزومه ها',
        'labels' => $labels,
        'supports' => array(
            'title',
            'custom-fields',
        ),
        'hierarchical' => true,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 5,
        'menu_icon' => 'dashicons-portfolio',
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'publicly_queryable' => true,
        'capability_type' => 'post',
        'show_in_rest' => false,
    );

    // Registering your Custom Post Type
    register_post_type('jobs-list', $args);
}

add_action('init', 'create_jobs_list_post_type', 0);



//show link file in edit post consultation
add_action('edit_form_after_title', 'display_custom_meta_as_link');
function display_custom_meta_as_link() {
    global $post;
    // Check if the current post type is 'consultation'
    if ($post->post_type === 'jobs-list') {
        // Replace 'meta_key' with your actual meta key
        $address_file = get_field('address_file', $post->ID);
        // If meta value is found, display it as a link
        if (!empty($address_file)) {
            $address_file = home_url() . "/" . $address_file;
            $file_info = pathinfo($address_file);
            $file_extension = $file_info['extension'];
            $filename = basename($address_file);
?>
            <div id="postimagediv" class="postbox ">
                <div class="postbox-header">
                    <h2 class="hndle ui-sortable-handle">فایل ضمیمه شده</h2>
                </div>
                <div class="inside">
                    <p class="hide-if-no-js"><a href="<?= @esc_url($address_file) ?>" download=""><?= @esc_attr($filename) ?></a></p>
                    <p class="hide-if-no-js">فرمت فایل : <?= @esc_attr($file_extension) ?></a></p>
                </div>
            </div>
<?php
        }
    }
}
