<?php

add_action('admin_init', function () {
    global $wpdb;

    $table_name = $wpdb->prefix . "mailchimp_subscribers";

    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") !== $table_name) {
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';

        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE $table_name (
        id INT NOT NULL AUTO_INCREMENT,
        email VARCHAR(255) NOT NULL,
        subscription_status ENUM('subscribed', 'unsubscribed', 'pending') DEFAULT 'pending',
        signup_date DATETIME DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id)
    ) $charset_collate;";


        dbDelta($sql);
    }
});



function insert_mailchimp_subscriber($email, $subscription_status = 'subscribed') {
    global $wpdb;
    $table_name = $wpdb->prefix . 'mailchimp_subscribers';

    $existing_email = $wpdb->get_var($wpdb->prepare(
        "SELECT email FROM $table_name WHERE email = %s",
        $email
    ));

    if (!$existing_email) {
        $result = $wpdb->insert(
            $table_name,
            array(
                'email' => $email,
                'subscription_status' => $subscription_status,
            ),
            array(
                '%s',
                '%s',
            )
        );

        return $result;
    } else {
        return false;
    }
}
